/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Buffer;
import db.Field;
import db.LongField;
import db.Schema;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.util.Arrays;

public class Record
implements Comparable<Record> {
    private Field key;
    private Field[] fieldValues;
    private boolean dirty = false;
    private int length = -1;
    private boolean isVariableLength;

    Record(Field key, Field[] fieldValues) {
        this.key = key;
        this.fieldValues = fieldValues;
    }

    public void setKey(long key) {
        if (!(this.key instanceof LongField)) {
            throw new AssertException();
        }
        this.key = new LongField(key);
    }

    public void setKey(Field key) {
        if (!this.key.getClass().equals(key.getClass())) {
            throw new AssertException();
        }
        this.key = key;
    }

    public long getKey() {
        return this.key.getLongValue();
    }

    public Field getKeyField() {
        return this.key;
    }

    public boolean hasSameSchema(Record otherRec) {
        Field[] otherFieldValues = otherRec.fieldValues;
        if (this.fieldValues.length != otherFieldValues.length) {
            return false;
        }
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i].getClass().equals(otherFieldValues[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public boolean hasSameSchema(Schema schema) {
        if (this.fieldValues.length != schema.getFieldCount()) {
            return false;
        }
        Class<?>[] schemaFieldClasses = schema.getFieldClasses();
        for (int i = 0; i < this.fieldValues.length; ++i) {
            if (this.fieldValues[i].getClass().equals(schemaFieldClasses[i])) continue;
            return false;
        }
        return true;
    }

    public int getColumnCount() {
        return this.fieldValues.length;
    }

    public Field getFieldValue(int columnIndex) {
        Field f = this.fieldValues[columnIndex];
        return f.newField(f);
    }

    public void setField(int colIndex, Field value) {
        if (this.fieldValues[colIndex].getFieldType() != value.getFieldType()) {
            throw new IllegalArgumentException();
        }
        this.fieldValues[colIndex] = value;
    }

    Field getField(int columnIndex) {
        return this.fieldValues[columnIndex];
    }

    Field[] getFields() {
        return this.fieldValues;
    }

    public boolean fieldEquals(int columnIndex, Field field) {
        return this.fieldValues[columnIndex].equals(field);
    }

    public int compareFieldTo(int columnIndex, Field value) {
        return this.fieldValues[columnIndex].compareTo(value);
    }

    public Record copy() {
        Field newKey = this.key.newField(this.key);
        Field[] fields = new Field[this.fieldValues.length];
        for (int i = 0; i < fields.length; ++i) {
            Field f = this.fieldValues[i];
            fields[i] = f.newField(f);
        }
        return new Record(newKey, fields);
    }

    public int length() {
        if (this.length < 0) {
            this.length = 0;
            this.isVariableLength = false;
            for (int i = 0; i < this.fieldValues.length; ++i) {
                this.length += this.fieldValues[i].length();
                this.isVariableLength |= this.fieldValues[i].isVariableLength();
            }
        }
        return this.length;
    }

    public long getLongValue(int colIndex) {
        return this.fieldValues[colIndex].getLongValue();
    }

    public void setLongValue(int colIndex, long value) {
        this.dirty = true;
        this.fieldValues[colIndex].setLongValue(value);
    }

    public int getIntValue(int colIndex) {
        return this.fieldValues[colIndex].getIntValue();
    }

    public void setIntValue(int colIndex, int value) {
        this.dirty = true;
        this.fieldValues[colIndex].setIntValue(value);
    }

    public short getShortValue(int colIndex) {
        return this.fieldValues[colIndex].getShortValue();
    }

    public void setShortValue(int colIndex, short value) {
        this.dirty = true;
        this.fieldValues[colIndex].setShortValue(value);
    }

    public byte getByteValue(int colIndex) {
        return this.fieldValues[colIndex].getByteValue();
    }

    public void setByteValue(int colIndex, byte value) {
        this.dirty = true;
        this.fieldValues[colIndex].setByteValue(value);
    }

    public boolean getBooleanValue(int colIndex) {
        return this.fieldValues[colIndex].getBooleanValue();
    }

    public void setBooleanValue(int colIndex, boolean value) {
        this.dirty = true;
        this.fieldValues[colIndex].setBooleanValue(value);
    }

    public byte[] getBinaryData(int colIndex) {
        return this.fieldValues[colIndex].getBinaryData();
    }

    public void setBinaryData(int colIndex, byte[] bytes) {
        this.dirty = true;
        this.length = -1;
        this.fieldValues[colIndex].setBinaryData(bytes);
    }

    public String getString(int colIndex) {
        return this.fieldValues[colIndex].getString();
    }

    public void setString(int colIndex, String str) {
        this.dirty = true;
        this.length = -1;
        this.fieldValues[colIndex].setString(str);
    }

    public void write(Buffer buf, int offset) throws IOException {
        for (int i = 0; i < this.fieldValues.length; ++i) {
            offset = this.fieldValues[i].write(buf, offset);
        }
        this.dirty = false;
    }

    public void read(Buffer buf, int offset) throws IOException {
        for (int i = 0; i < this.fieldValues.length; ++i) {
            offset = this.fieldValues[i].read(buf, offset);
        }
        this.dirty = false;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Record)) {
            return false;
        }
        Record rec = (Record)obj;
        return this.key.equals(rec.key) && Arrays.equals(this.fieldValues, rec.fieldValues);
    }

    @Override
    public int compareTo(Record otherRec) {
        return this.key.compareTo(otherRec.key);
    }
}

