/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.internal.PaintContext;
import docking.widgets.fieldpanel.support.FieldRange;
import docking.widgets.fieldpanel.support.FieldSelection;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ClangTextField;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.DecompilerProvider;
import ghidra.app.services.ClipboardContentProviderService;
import ghidra.app.util.ByteCopier;
import ghidra.app.util.ClipboardType;
import ghidra.util.task.TaskMonitor;
import java.awt.FontMetrics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.StringUtils;

public class DecompilerClipboardProvider
extends ByteCopier
implements ClipboardContentProviderService {
    private static final PaintContext PAINT_CONTEXT = new PaintContext();
    private static final ClipboardType TEXT_TYPE = new ClipboardType(DataFlavor.stringFlavor, "Text");
    private static final List<ClipboardType> COPY_TYPES = new LinkedList<ClipboardType>();
    private DecompilerProvider provider;
    private FieldSelection selection;
    private boolean copyFromSelectionEnabled;
    private Set<ChangeListener> listeners = new CopyOnWriteArraySet<ChangeListener>();
    private int spaceCharWidthInPixels = 7;

    public DecompilerClipboardProvider(DecompilePlugin plugin, DecompilerProvider provider) {
        this.provider = provider;
        this.tool = plugin.getTool();
        PAINT_CONTEXT.setTextCopying(true);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyStateChanged() {
        ChangeEvent event = new ChangeEvent((Object)this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    public Transferable copy(TaskMonitor monitor) {
        if (!this.copyFromSelectionEnabled) {
            return DecompilerClipboardProvider.createStringTransferable((String)this.getCursorText());
        }
        return this.copyText(monitor);
    }

    private String getCursorText() {
        DecompilerPanel panel = this.provider.getDecompilerPanel();
        ClangToken token = panel.getTokenAtCursor();
        if (token == null) {
            return null;
        }
        String text = token.getText();
        return text;
    }

    public List<ClipboardType> getCurrentCopyTypes() {
        if (this.copyFromSelectionEnabled) {
            return COPY_TYPES;
        }
        return EMPTY_LIST;
    }

    public List<ClipboardType> getCurrentPasteTypes(Transferable t) {
        return null;
    }

    public Transferable copySpecial(ClipboardType copyType, TaskMonitor monitor) {
        if (copyType == TEXT_TYPE) {
            return this.copyText(monitor);
        }
        return null;
    }

    public boolean isValidContext(ActionContext context) {
        return context.getComponentProvider() == this.provider;
    }

    public void selectionChanged(FieldSelection sel) {
        this.selection = sel;
        this.copyFromSelectionEnabled = this.selection != null && this.selection.getNumRanges() > 0;
        this.notifyStateChanged();
    }

    public ComponentProvider getComponentProvider() {
        return this.provider;
    }

    public boolean enableCopy() {
        return true;
    }

    public boolean enableCopySpecial() {
        return false;
    }

    public boolean canCopy() {
        return this.copyFromSelectionEnabled || !StringUtils.isBlank((CharSequence)this.getCursorText());
    }

    public boolean canCopySpecial() {
        return false;
    }

    protected Transferable copyText(TaskMonitor monitor) {
        return DecompilerClipboardProvider.createStringTransferable((String)this.getText());
    }

    String getText() {
        StringBuffer buffer = new StringBuffer();
        int numRanges = this.selection.getNumRanges();
        for (int i = 0; i < numRanges; ++i) {
            this.appendText(buffer, this.selection.getFieldRange(i));
        }
        return buffer.toString();
    }

    void appendText(StringBuffer buffer, FieldRange fieldRange) {
        int endIndex;
        int startIndex = fieldRange.getStart().getIndex().intValue();
        if (startIndex == (endIndex = fieldRange.getEnd().getIndex().intValue())) {
            this.appendTextSingleLine(buffer, startIndex, this.selection.intersect(startIndex));
            return;
        }
        this.appendText(buffer, startIndex, this.selection.intersect(startIndex));
        for (int line = startIndex + 1; line <= endIndex; ++line) {
            buffer.append('\n');
            this.appendText(buffer, line, this.selection.intersect(line));
        }
    }

    private void appendText(StringBuffer buffer, int lineNumber, FieldSelection singleLineSelection) {
        int endIndex;
        if (singleLineSelection.isEmpty()) {
            return;
        }
        FieldRange fieldRange = singleLineSelection.getFieldRange(0);
        int startColumn = fieldRange.getStart().getCol();
        int endColumn = Integer.MAX_VALUE;
        int startRow = fieldRange.getStart().getRow();
        int endRow = Integer.MAX_VALUE;
        int startIndex = fieldRange.getStart().getIndex().intValue();
        if (startIndex == (endIndex = fieldRange.getEnd().getIndex().intValue())) {
            endColumn = fieldRange.getEnd().getCol();
            endRow = fieldRange.getEnd().getRow();
        }
        LayoutModel model = this.provider.getDecompilerPanel().getLayoutModel();
        Layout layout = model.getLayout(BigInteger.valueOf(lineNumber));
        ClangTextField field = (ClangTextField)layout.getField(0);
        int numSpaces = (field.getStartX() - field.getLineNumberWidth()) / this.spaceCharWidthInPixels;
        for (int i = 0; i < numSpaces; ++i) {
            buffer.append(' ');
        }
        int startPos = field.screenLocationToTextOffset(startRow, startColumn);
        int endPos = field.screenLocationToTextOffset(endRow, endColumn);
        for (int i = 0; i < startPos; ++i) {
            buffer.append(' ');
        }
        if (startPos >= 0 && endPos >= startPos) {
            buffer.append(field.getText().substring(startPos, endPos));
        }
    }

    private void appendTextSingleLine(StringBuffer buffer, int lineNumber, FieldSelection singleLineSelection) {
        if (singleLineSelection.isEmpty()) {
            return;
        }
        FieldRange fieldRange = singleLineSelection.getFieldRange(0);
        int startColumn = fieldRange.getStart().getCol();
        int endColumn = fieldRange.getEnd().getCol();
        int startRow = fieldRange.getStart().getRow();
        int endRow = fieldRange.getEnd().getRow();
        LayoutModel model = this.provider.getDecompilerPanel().getLayoutModel();
        Layout layout = model.getLayout(BigInteger.valueOf(lineNumber));
        ClangTextField field = (ClangTextField)layout.getField(0);
        int startPos = field.screenLocationToTextOffset(startRow, startColumn);
        int endPos = field.screenLocationToTextOffset(endRow, endColumn);
        if (startPos >= 0 && endPos >= startPos) {
            buffer.append(field.getText().substring(startPos, endPos));
        }
    }

    public boolean enablePaste() {
        return false;
    }

    public boolean canPaste(DataFlavor[] availableFlavors) {
        return false;
    }

    public boolean paste(Transferable pasteData) {
        return false;
    }

    public boolean pasteSpecial(Transferable pasteData, ClipboardType pasteType) {
        return false;
    }

    public void lostOwnership(Transferable transferable) {
    }

    public void setFontMetrics(FontMetrics metrics) {
        this.spaceCharWidthInPixels = metrics.charWidth(' ');
    }

    static {
        COPY_TYPES.add(TEXT_TYPE);
    }
}

