/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class CreateDataInStructureBackgroundCmd
extends BackgroundCommand {
    private Address addr;
    private int length;
    private int[] startPath;
    private DataType newDataType;
    private boolean stackPointers;

    public CreateDataInStructureBackgroundCmd(Address addr, int[] startPath, int length, DataType dt) {
        this(addr, startPath, length, dt, false);
    }

    public CreateDataInStructureBackgroundCmd(Address addr, int[] startPath, int length, DataType dt, boolean stackPointers) {
        super("Create " + dt.getDisplayName() + " component(s)", false, true, true);
        this.addr = addr;
        this.startPath = startPath;
        this.length = length;
        this.newDataType = dt;
        this.stackPointers = stackPointers;
    }

    public boolean applyTo(DomainObject obj, TaskMonitor monitor) {
        Program program = (Program)obj;
        Data data = program.getListing().getDefinedDataContaining(this.addr);
        Data startData = data.getComponent(this.startPath);
        if (startData == null) {
            this.setStatusMsg("Component data not found");
            return false;
        }
        Data parent = startData.getParent();
        DataType parentDataType = parent.getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            this.setStatusMsg("Range based operation only supported within Structures");
            return false;
        }
        DataType existingDT = startData.getDataType();
        int startIndex = startData.getComponentIndex();
        Data lastComp = parent.getComponentAt((int)(startData.getMinAddress().subtract(parent.getMinAddress()) + (long)this.length - 1L));
        int endIndex = lastComp.getComponentIndex();
        Structure struct = (Structure)parentDataType;
        if (this.newDataType instanceof FactoryDataType) {
            this.setStatusMsg("Factory data-type not allowed in structure: " + this.newDataType.getName());
            return false;
        }
        this.newDataType = this.newDataType.clone(program.getDataTypeManager());
        this.newDataType = DataUtilities.reconcileAppliedDataType((DataType)existingDT, (DataType)this.newDataType, (boolean)this.stackPointers);
        if (this.newDataType instanceof Dynamic && !((Dynamic)this.newDataType).canSpecifyLength()) {
            this.setStatusMsg("Non-sizable Dynamic data-type not allowed in structure: " + this.newDataType.getName());
            return false;
        }
        for (int i = endIndex; i >= startIndex; --i) {
            struct.clearComponent(i);
        }
        if (this.newDataType != DataType.DEFAULT) {
            int index = startIndex;
            int numCreated = 0;
            while (this.length > 0) {
                try {
                    DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)this.newDataType, (int)this.length);
                    if (dti == null || dti.getLength() > this.length) break;
                    DataTypeComponent dtc = struct.replace(index, dti.getDataType(), dti.getLength());
                    this.length -= dtc.getLength();
                    ++numCreated;
                    ++index;
                }
                catch (Exception e) {
                    this.setStatusMsg(e.getMessage());
                    return false;
                }
            }
            if (numCreated == 0) {
                this.setStatusMsg("Not enough space");
                return false;
            }
        }
        return true;
    }
}

