/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.app.plugin.core.analysis.validator.PostAnalysisValidator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class PercentAnalyzedValidator
extends PostAnalysisValidator {
    private static final String NAME = "Percent Analyzed Validator";
    public static final String COVERAGE_THRESHOLD = "Minimum analysis coverage threshold";
    public static final float COVERAGE_THRESHOLD_DEFAULT = 0.75f;

    public PercentAnalyzedValidator(Program program) {
        super(program);
    }

    @Override
    public ConditionResult doRun(TaskMonitor monitor) {
        float percent;
        float threshold = 0.75f;
        ConditionStatus status = ConditionStatus.Passed;
        StringBuilder warnings = new StringBuilder();
        try {
            percent = this.checkPercentAnalyzed(this.program, monitor);
        }
        catch (MemoryAccessException e) {
            return new ConditionResult(ConditionStatus.Error, "Error accessing memory in " + this.program.getDomainFile().getName() + ": " + e.getMessage());
        }
        catch (CancelledException e) {
            return new ConditionResult(ConditionStatus.Cancelled);
        }
        if (percent < threshold) {
            status = ConditionStatus.Warning;
            warnings.append(this.program.getDomainFile().getName() + " percent disassembled/defined in executable memory = " + PercentAnalyzedValidator.format(percent) + "\n");
        }
        return new ConditionResult(status, warnings.toString());
    }

    private static String format(float percent) {
        return String.format("%.1f%%", (double)percent * 100.0);
    }

    private float checkPercentAnalyzed(Program prog, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        AddressSetView execMemSet = prog.getMemory().getExecuteSet();
        AddressSetView initMemSet = prog.getMemory().getLoadedAndInitializedAddressSet();
        AddressSet execMemSetInitialized = execMemSet.intersect(initMemSet);
        monitor.setIndeterminate(false);
        long numPossibleDefined = execMemSetInitialized.getNumAddresses();
        monitor.initialize(numPossibleDefined);
        InstructionIterator instIter = prog.getListing().getInstructions((AddressSetView)execMemSetInitialized, true);
        int instCount = 0;
        while (!monitor.isCancelled() && instIter.hasNext()) {
            Instruction inst = instIter.next();
            int length = inst.getBytes().length;
            monitor.incrementProgress((long)length);
            instCount += length;
        }
        monitor.checkCanceled();
        DataIterator dataIter = prog.getListing().getData((AddressSetView)execMemSetInitialized, true);
        int dataCount = 0;
        while (!monitor.isCancelled() && dataIter.hasNext()) {
            Data data = dataIter.next();
            int length = data.getLength();
            monitor.incrementProgress((long)length);
            if (!data.isDefined()) continue;
            dataCount += length;
        }
        monitor.setProgress(numPossibleDefined);
        int totalDefined = instCount + dataCount;
        float coverage = (float)totalDefined / (float)numPossibleDefined;
        return coverage;
    }

    public String getDescription() {
        return "Make sure program is at least " + PercentAnalyzedValidator.format(0.75f) + " disassembled/defined";
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return this.getName();
    }
}

