/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.cmd.function.FunctionStackAnalysisCmd;
import ghidra.app.cmd.function.NewFunctionStackAnalysisCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;

public class StackVariableAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Stack";
    private static final String DESCRIPTION = "Creates stack variables for a function.";
    private boolean doNewStackAnalysis = true;
    private boolean doLocalAnalysis = true;
    private boolean doParameterAnalysis = true;

    public StackVariableAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.FUNCTION_ANALYZER);
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.after().after().after());
        this.setDefaultEnablement(true);
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        BackgroundCommand cmd = this.doNewStackAnalysis ? new NewFunctionStackAnalysisCmd(set, this.doParameterAnalysis, this.doLocalAnalysis, false) : new FunctionStackAnalysisCmd(set, this.doParameterAnalysis, this.doLocalAnalysis, false);
        cmd.applyTo((DomainObject)program, monitor);
        return true;
    }

    private boolean useOldStackAnalysisByDefault(Program program) {
        Language language = program.getLanguage();
        return language.getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"x86")) && language.getLanguageDescription().getSize() == 16;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption("useNewFunctionStackAnalysis", (Object)(!this.useOldStackAnalysisByDefault(program) ? 1 : 0), null, "Use General Stack Reference Propogator (This works best on most processors)");
        options.registerOption("Create Local Variables", (Object)this.doLocalAnalysis, null, "Create Function Local stack variables and references");
        options.registerOption("Create Param Variables", (Object)this.doParameterAnalysis, null, "Create Function Parameter stack variables and references");
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.doNewStackAnalysis = options.getBoolean("useNewFunctionStackAnalysis", !this.useOldStackAnalysisByDefault(program));
        this.doLocalAnalysis = options.getBoolean("Create Local Variables", this.doLocalAnalysis);
        this.doParameterAnalysis = options.getBoolean("Create Param Variables", this.doParameterAnalysis);
    }
}

