/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import ghidra.framework.data.DomainObjectAdapterDB;
import ghidra.framework.model.Transaction;
import ghidra.framework.model.TransactionListener;
import ghidra.program.database.ProgramDB;
import ghidra.program.model.listing.Program;
import ghidra.util.HTMLUtilities;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;
import resources.ResourceManager;

class TransactionMonitor
extends JComponent
implements TransactionListener {
    private static ImageIcon busyIcon;
    private static Dimension prefSize;
    ProgramDB program;
    Transaction lastTx;

    TransactionMonitor() {
        busyIcon = ResourceManager.loadImage((String)"images/editbytes.gif");
        prefSize = new Dimension(busyIcon.getIconWidth(), busyIcon.getIconHeight());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    void setProgram(Program p) {
        if (this.program != null) {
            this.program.removeTransactionListener((TransactionListener)this);
        }
        if (p instanceof ProgramDB) {
            this.program = (ProgramDB)p;
            this.program.addTransactionListener((TransactionListener)this);
        } else {
            this.program = null;
        }
        this.lastTx = null;
        this.repaint();
    }

    public void transactionStarted(DomainObjectAdapterDB domainObj, Transaction tx) {
        this.lastTx = tx;
        this.repaint();
    }

    public void transactionEnded(DomainObjectAdapterDB domainObj) {
        this.lastTx = null;
        this.repaint();
    }

    public void undoStackChanged(DomainObjectAdapterDB domainObj) {
    }

    public void undoRedoOccurred(DomainObjectAdapterDB domainObj) {
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(prefSize);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.lastTx != null) {
            busyIcon.paintIcon(this, g, 0, 0);
        }
    }

    @Override
    public String getToolTipText() {
        if (this.lastTx != null) {
            ArrayList list = this.lastTx.getOpenSubTransactions();
            StringBuffer tip = new StringBuffer();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (tip.length() != 0) {
                    tip.append('\n');
                }
                tip.append((String)iter.next());
            }
            return HTMLUtilities.toHTML((String)tip.toString());
        }
        return null;
    }
}

