/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.widgets.table.AbstractSortedTableModel;
import ghidra.app.cmd.refs.UpdateExternalNameCmd;
import ghidra.app.plugin.core.references.ExternalPath;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExternalNamesTableModel
extends AbstractSortedTableModel<ExternalPath> {
    static final int NAME_COL = 0;
    static final int PATH_COL = 1;
    static final String EXTERNAL_NAME = "Name";
    static final String PATH_NAME = "Ghidra Program";
    private final List<String> columns = List.of("Name", "Ghidra Program");
    private PluginTool tool;
    private Program program;
    private List<ExternalPath> paths = new ArrayList<ExternalPath>();

    public ExternalNamesTableModel(PluginTool tool) {
        this.tool = tool;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public String getColumnName(int column) {
        return this.columns.get(column);
    }

    public String getName() {
        return "External Programs Model";
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    public List<ExternalPath> getModelData() {
        return this.paths;
    }

    public Object getColumnValueForRow(ExternalPath t, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return t.getName();
            }
            case 1: {
                return t.getPath();
            }
        }
        return "Unknown Column!";
    }

    public void setValueAt(Object aValue, int row, int column) {
        String newName = ((String)aValue).trim();
        if (StringUtils.isBlank((CharSequence)newName)) {
            return;
        }
        int index = this.indexOf(newName);
        if (index >= 0) {
            Window window = this.tool.getActiveWindow();
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)window, (String)"Duplicate Name", (Object)("Name already exists: " + newName));
            return;
        }
        ExternalPath path = this.paths.get(row);
        String oldName = path.getName();
        UpdateExternalNameCmd cmd = new UpdateExternalNameCmd(oldName, newName, SourceType.USER_DEFINED);
        if (!this.tool.execute((Command)cmd, (DomainObject)this.program)) {
            this.tool.setStatusInfo(cmd.getStatusMsg());
        }
    }

    private int indexOf(String name) {
        for (int i = 0; i < this.paths.size(); ++i) {
            ExternalPath path = this.paths.get(i);
            if (!path.getName().equals(name)) continue;
            return i;
        }
        return 0;
    }

    void setProgram(Program program) {
        this.program = program;
        this.updateTableData();
    }

    void updateTableData() {
        this.paths.clear();
        if (this.program == null) {
            this.fireTableDataChanged();
            return;
        }
        ExternalManager extMgr = this.program.getExternalManager();
        Object[] programNames = extMgr.getExternalLibraryNames();
        Arrays.sort(programNames);
        for (Object programName : programNames) {
            if ("<EXTERNAL>".equals(programName)) continue;
            ExternalPath path = new ExternalPath((String)programName, extMgr.getExternalLibraryPath((String)programName));
            this.paths.add(path);
        }
        this.fireTableDataChanged();
    }
}

