/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class PrebindChecksumCommand
extends LoadCommand {
    private int cksum;

    static PrebindChecksumCommand createPrebindChecksumCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        PrebindChecksumCommand checksumCommand = (PrebindChecksumCommand)reader.getFactory().create(PrebindChecksumCommand.class, new Object[0]);
        checksumCommand.initPrebindChecksumCommand(reader);
        return checksumCommand;
    }

    private void initPrebindChecksumCommand(FactoryBundledWithBinaryReader reader) throws IOException {
        this.initLoadCommand(reader);
        this.cksum = reader.readNextInt();
    }

    public int getCheckSum() {
        return this.cksum;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(DWORD, "cksum", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "prebind_cksum_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address addr = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(addr, this.toDataType());
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }
}

