/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pef;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pef.ContainerHeader;
import ghidra.app.util.bin.format.pef.ImportStateCache;
import ghidra.app.util.bin.format.pef.Relocation;
import ghidra.app.util.bin.format.pef.RelocationState;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.listing.Program;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class RelocLgSetOrBySection
extends Relocation {
    private int subopcode;
    private int index;

    RelocLgSetOrBySection(BinaryReader reader) throws IOException {
        int value = reader.readNextShort() & 0xFFFF;
        this.opcode = (value & 0xFC00) >> 10;
        this.subopcode = (value & 0x330) >> 6;
        this.index = (value & 0x3F) << 16;
        this.index |= reader.readNextShort() & 0xFFFF;
    }

    @Override
    public boolean isMatch() {
        return this.opcode == 45;
    }

    @Override
    public int getSizeInBytes() {
        return 4;
    }

    public int getSubopcode() {
        return this.subopcode;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void apply(ImportStateCache importState, RelocationState relocState, ContainerHeader header, Program program, MessageLog log, TaskMonitor monitor) {
        throw new RuntimeException("Unhandled relocation: RelocLgSetOrBySection");
    }
}

