/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.html;

import ghidra.app.util.datatype.DataTypeIdUrl;
import ghidra.app.util.html.CompletelyDifferentHTMLDataTypeRepresentationWrapper;
import ghidra.app.util.html.EmptyVariableTextLine;
import ghidra.app.util.html.HTMLDataTypeRepresentation;
import ghidra.app.util.html.HTMLDataTypeRepresentationDiffInput;
import ghidra.app.util.html.PlaceHolderLine;
import ghidra.app.util.html.TextLine;
import ghidra.app.util.html.ValidatableLine;
import ghidra.app.util.html.VariableTextLine;
import ghidra.app.util.html.diff.DataTypeDiff;
import ghidra.app.util.html.diff.DataTypeDiffBuilder;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;

public class FunctionDataTypeHTMLRepresentation
extends HTMLDataTypeRepresentation {
    protected TextLine returnType;
    protected TextLine functionName;
    protected List<ValidatableLine> arguments;
    protected TextLine varArgs;
    protected TextLine voidArgs;

    private FunctionDataTypeHTMLRepresentation(TextLine returnType, TextLine functionName, List<ValidatableLine> arguments, TextLine varArgs, TextLine voidArgs) {
        this.returnType = returnType;
        this.functionName = functionName;
        this.arguments = arguments;
        this.varArgs = varArgs;
        this.voidArgs = voidArgs;
        this.originalHTMLData = FunctionDataTypeHTMLRepresentation.buildHTMLText(returnType, functionName, arguments, varArgs, voidArgs);
    }

    public FunctionDataTypeHTMLRepresentation(FunctionDefinition functionDefinition) {
        this.returnType = this.buildReturnType(functionDefinition);
        this.functionName = this.buildName(functionDefinition);
        this.arguments = this.buildArguments(functionDefinition);
        this.varArgs = this.buildVarArgs(functionDefinition);
        this.voidArgs = this.buildVoidArgs(functionDefinition);
        this.originalHTMLData = FunctionDataTypeHTMLRepresentation.buildHTMLText(this.returnType, this.functionName, this.arguments, this.varArgs, this.voidArgs);
    }

    @Override
    protected PlaceHolderLine createPlaceHolderLine(ValidatableLine oppositeLine) {
        if (!(oppositeLine instanceof VariableTextLine)) {
            throw new AssertException("I didn't know you could pass me other types of lines?!");
        }
        VariableTextLine variableTextLine = (VariableTextLine)oppositeLine;
        int stringLength = variableTextLine.getVariableType().length() + variableTextLine.getVariableName().length();
        return new EmptyVariableTextLine(stringLength);
    }

    private TextLine buildVarArgs(FunctionDefinition functionDefinition) {
        if (functionDefinition.hasVarArgs()) {
            return new TextLine("...");
        }
        return new TextLine("");
    }

    private TextLine buildVoidArgs(FunctionDefinition functionDefinition) {
        if (functionDefinition.getArguments().length == 0 && !functionDefinition.hasVarArgs()) {
            return new TextLine("void");
        }
        return new TextLine("");
    }

    private TextLine buildName(FunctionDefinition functionDefinition) {
        return new TextLine(HTMLUtilities.friendlyEncodeHTML((String)functionDefinition.getDisplayName()));
    }

    private TextLine buildReturnType(FunctionDefinition functionDefinition) {
        DataType returnDataType = functionDefinition.getReturnType();
        GenericCallingConvention genericCallingConvention = functionDefinition.getGenericCallingConvention();
        String modifier = genericCallingConvention != GenericCallingConvention.unknown ? " " + genericCallingConvention.name() : "";
        return new TextLine(HTMLUtilities.friendlyEncodeHTML((String)returnDataType.getDisplayName()) + modifier);
    }

    private List<ValidatableLine> buildArguments(FunctionDefinition functionDefinition) {
        ParameterDefinition[] vars = functionDefinition.getArguments();
        ArrayList<ValidatableLine> lines = new ArrayList<ValidatableLine>(vars.length);
        for (ParameterDefinition var : vars) {
            DataType dataType = var.getDataType();
            String displayName = dataType.getDisplayName();
            String name = var.getName();
            DataType locatableType = FunctionDataTypeHTMLRepresentation.getLocatableDataType(dataType);
            lines.add(new VariableTextLine(HTMLUtilities.friendlyEncodeHTML((String)displayName), name, locatableType));
        }
        return lines;
    }

    private static String buildHTMLText(TextLine returnType, TextLine functionName, List<ValidatableLine> arguments, TextLine varArgs, TextLine voidArgs) {
        StringBuffer sb = new StringBuffer();
        String returnTypeText = returnType.getText();
        returnTypeText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(returnTypeText, returnType.getTextColor());
        String functionNameText = functionName.getText();
        functionNameText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(functionNameText, functionName.getTextColor());
        sb.append(returnTypeText).append("&nbsp;").append(functionNameText).append("(");
        String varArgsText = varArgs.getText();
        varArgsText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(varArgsText, varArgs.getTextColor());
        boolean hasVarArgs = varArgsText.length() != 0;
        int size = arguments.size();
        for (int i = 0; i < size; ++i) {
            sb.append("<BR>");
            VariableTextLine variableLine = (VariableTextLine)arguments.get(i);
            String typeText = FunctionDataTypeHTMLRepresentation.generateTypeText(variableLine);
            String variableNameText = variableLine.getVariableName();
            variableNameText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(variableNameText, variableLine.getVariableNameColor());
            sb.append(TAB).append(typeText).append("&nbsp;").append(variableNameText);
            if (i + 1 < size - 1 || size > 0 && hasVarArgs) {
                sb.append(",");
            }
            if (i <= 50) continue;
            sb.append(TAB).append("...").append("<BR>");
            break;
        }
        if (hasVarArgs) {
            if (size > 0) {
                sb.append("<BR>").append(TAB);
            }
            sb.append(varArgsText);
        } else if (size == 0) {
            String voidArgsText = voidArgs.getText();
            if ((voidArgsText = FunctionDataTypeHTMLRepresentation.wrapStringInColor(voidArgsText, voidArgs.getTextColor())).length() != 0) {
                sb.append(voidArgsText);
            }
        }
        sb.append(")").append("<BR>");
        return sb.toString();
    }

    private static String generateTypeText(VariableTextLine line) {
        String type = line.getVariableType();
        type = FunctionDataTypeHTMLRepresentation.wrapStringInColor(type, line.getVariableTypeColor());
        if (!line.hasUniversalId()) {
            return type;
        }
        DataType dataType = line.getDataType();
        DataTypeIdUrl url = new DataTypeIdUrl(dataType);
        String wrapped = HTMLUtilities.wrapWithLinkPlaceholder((String)type, (String)url.toString());
        return wrapped;
    }

    @Override
    public HTMLDataTypeRepresentation[] diff(HTMLDataTypeRepresentation otherRepresentation) {
        if (this == otherRepresentation) {
            return new HTMLDataTypeRepresentation[]{this, this};
        }
        if (!(otherRepresentation instanceof FunctionDataTypeHTMLRepresentation)) {
            return new HTMLDataTypeRepresentation[]{new CompletelyDifferentHTMLDataTypeRepresentationWrapper(this), new CompletelyDifferentHTMLDataTypeRepresentationWrapper(otherRepresentation)};
        }
        FunctionDataTypeHTMLRepresentation functionRepresentation = (FunctionDataTypeHTMLRepresentation)otherRepresentation;
        TextLine diffReturnType = new TextLine(this.returnType.getText());
        TextLine diffFunctionName = new TextLine(this.functionName.getText());
        List<ValidatableLine> argumentLines = this.copyLines(this.arguments);
        TextLine diffVarArgs = new TextLine(this.varArgs.getText());
        TextLine diffVoidArgs = new TextLine(this.voidArgs.getText());
        TextLine otherDiffReturnType = new TextLine(functionRepresentation.returnType.getText());
        TextLine otherDiffFunctionName = new TextLine(functionRepresentation.functionName.getText());
        List<ValidatableLine> otherArgumentLines = this.copyLines(functionRepresentation.arguments);
        TextLine otherDiffVarArgs = new TextLine(functionRepresentation.varArgs.getText());
        TextLine otherDiffVoidArgs = new TextLine(functionRepresentation.voidArgs.getText());
        this.diffTextLine(diffReturnType, otherDiffReturnType);
        this.diffTextLine(diffFunctionName, otherDiffFunctionName);
        HTMLDataTypeRepresentationDiffInput diffInput = new HTMLDataTypeRepresentationDiffInput(this, argumentLines);
        HTMLDataTypeRepresentationDiffInput otherDiffInput = new HTMLDataTypeRepresentationDiffInput(otherRepresentation, otherArgumentLines);
        DataTypeDiff argumentsDiff = DataTypeDiffBuilder.diffBody(diffInput, otherDiffInput);
        this.diffTextLine(diffVarArgs, otherDiffVarArgs);
        this.diffTextLine(diffVoidArgs, otherDiffVoidArgs);
        return new HTMLDataTypeRepresentation[]{new FunctionDataTypeHTMLRepresentation(diffReturnType, diffFunctionName, argumentsDiff.getLeftLines(), diffVarArgs, diffVoidArgs), new FunctionDataTypeHTMLRepresentation(otherDiffReturnType, otherDiffFunctionName, argumentsDiff.getRightLines(), otherDiffVarArgs, otherDiffVoidArgs)};
    }
}

