/*
 * Decompiled with CFR 0.152.
 */
package docking.action;

import docking.KeyBindingPrecedence;
import docking.actions.KeyBindingUtils;
import javax.swing.KeyStroke;

public class KeyBindingData {
    private KeyStroke keyStroke;
    private KeyBindingPrecedence keyBindingPrecedence;

    public KeyBindingData(KeyStroke keyStroke) {
        this(keyStroke, KeyBindingPrecedence.DefaultLevel);
    }

    public KeyBindingData(char c, int modifiers) {
        this((int)Character.toUpperCase(c), modifiers);
    }

    public KeyBindingData(int keyCode, int modifiers) {
        this(KeyStroke.getKeyStroke(keyCode, modifiers));
    }

    public KeyBindingData(KeyStroke keyStroke, KeyBindingPrecedence precedence) {
        if (precedence == KeyBindingPrecedence.ReservedActionsLevel) {
            throw new IllegalArgumentException("Can't set precedence to Reserved KeyBindingPrecedence");
        }
        this.keyStroke = keyStroke;
        this.keyBindingPrecedence = precedence;
    }

    public KeyStroke getKeyBinding() {
        return this.keyStroke;
    }

    public KeyBindingPrecedence getKeyBindingPrecedence() {
        return this.keyBindingPrecedence;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[KeyStroke=" + this.keyStroke + ", precedence=" + this.keyBindingPrecedence + "]";
    }

    static KeyBindingData createReservedKeyBindingData(KeyStroke keyStroke) {
        KeyBindingData keyBindingData = new KeyBindingData(keyStroke);
        keyBindingData.keyBindingPrecedence = KeyBindingPrecedence.ReservedActionsLevel;
        return keyBindingData;
    }

    public static KeyBindingData validateKeyBindingData(KeyBindingData newKeyBindingData) {
        if (newKeyBindingData == null) {
            return null;
        }
        KeyStroke keyBinding = newKeyBindingData.getKeyBinding();
        if (keyBinding == null) {
            return newKeyBindingData;
        }
        KeyBindingPrecedence precedence = newKeyBindingData.getKeyBindingPrecedence();
        if (precedence == KeyBindingPrecedence.ReservedActionsLevel) {
            return KeyBindingData.createReservedKeyBindingData(KeyBindingUtils.validateKeyStroke(keyBinding));
        }
        return new KeyBindingData(KeyBindingUtils.validateKeyStroke(keyBinding), precedence);
    }
}

