/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.imagepanel;

import docking.widgets.label.GIconLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import resources.icons.EmptyIcon;

public class ImagePanel
extends JPanel {
    public static final float[] ZOOM_LEVELS = new float[]{0.05f, 0.1f, 0.25f, 0.5f, 0.75f, 1.0f, 1.5f, 2.0f, 2.5f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f};
    private static final int ZERO_MAGNIFICATION_INDEX = ImagePanel.findZeroMagnificationIndex();
    protected static final int ZOOM_FACTOR_INDEX_DEFAULT = ImagePanel.findZeroMagnificationIndex();
    protected int zoomLevelIndex = ZOOM_FACTOR_INDEX_DEFAULT;
    private Image image;
    private PanAndZoomComponent label;
    private JScrollPane imageScroller;
    private boolean zoomEnabled = true;
    private boolean translateEnabled = true;
    public static final float DEFAULT_ZOOM_FACTOR = 1.0f;
    private float defaultZoomFactor = 1.0f;
    public static final String IMAGE_PROPERTY = "image";
    public static final String ZOOM_PROPERTY = "zoom";
    public static final String DEFAULT_ZOOM_PROPERTY = "default_zoom";
    public static final String TRANSLATION_PROPERTY = "translation";
    private MouseAdapter zoomAndPanMouseAdapter = new MouseAdapter(){
        private int lastX;
        private int lastY;

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int steps = e.getWheelRotation();
            if (steps > 0) {
                ImagePanel.this.zoomOut(e.getPoint());
            } else {
                ImagePanel.this.zoomIn(e.getPoint());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            super.mouseDragged(e);
            if (e.getButton() == 1) {
                int newDx = e.getX() - this.lastX;
                int newDy = e.getY() - this.lastY;
                this.lastX += newDx;
                this.lastY += newDy;
                ImagePanel.this.translateImage(newDx, newDy);
            }
        }
    };
    private JPanel imagePanel;

    private static int findZeroMagnificationIndex() {
        for (int i = 0; i < ZOOM_LEVELS.length; ++i) {
            if (Float.compare(ZOOM_LEVELS[i], 1.0f) != 0) continue;
            return i;
        }
        throw new IllegalStateException("Magnification factor list must contain an entry for no magnification (1.0x)");
    }

    public ImagePanel() {
        this((Image)null);
    }

    public ImagePanel(Image image) {
        this.initUI();
        this.label.addMouseWheelListener(this.zoomAndPanMouseAdapter);
        this.label.addMouseListener(this.zoomAndPanMouseAdapter);
        this.label.addMouseMotionListener(this.zoomAndPanMouseAdapter);
        this.label.addPropertyChangeListener("translation-reset", evt -> SwingUtilities.invokeLater(() -> this.firePropertyChange(TRANSLATION_PROPERTY, evt.getOldValue(), evt.getNewValue())));
        this.setImage(image);
    }

    private void initUI() {
        this.label = new PanAndZoomComponent((Icon)new EmptyIcon(16, 16), 0);
        this.imagePanel = new JPanel(new BorderLayout());
        this.imagePanel.add((Component)this.label, "Center");
        this.imageScroller = new JScrollPane(this.imagePanel, 20, 30);
        this.setLayout(new BorderLayout());
        this.add((Component)this.imageScroller, "Center");
    }

    public void setImage(Image image) {
        Image oldImage = this.getImage();
        this.image = image;
        this.resetZoom();
        this.resetImageTranslation();
        this.firePropertyChange(IMAGE_PROPERTY, oldImage, this.image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImageBackgroundColor(Color color) {
        if (color == null) {
            color = UIManager.getColor("Panel.background");
        }
        this.imagePanel.setBackground(color);
    }

    public Color getImageBackgroundColor() {
        return this.imagePanel.getBackground();
    }

    public void setText(String text) {
        this.label.setText(text);
    }

    public String getText() {
        return this.label.getText();
    }

    public float getZoomFactor() {
        return ZOOM_LEVELS[this.zoomLevelIndex];
    }

    public void setZoomFactor(float zoom) {
        float currentZoom = this.getZoomFactor();
        this.zoomLevelIndex = ImagePanel.getIndexForLevel(ZOOM_LEVELS, zoom);
        zoom = ZOOM_LEVELS[this.zoomLevelIndex];
        this.doZoom(this.getImageComponentCenter(), zoom);
        this.firePropertyChange(ZOOM_PROPERTY, currentZoom, zoom);
    }

    private static int getIndexForLevel(float[] levels, float zoom) {
        int idx = Arrays.binarySearch(levels, zoom);
        if (idx >= 0) {
            return idx;
        }
        if ((idx = -(idx + 1)) == 0) {
            return 0;
        }
        if (idx == levels.length) {
            return levels.length - 1;
        }
        if (idx < ZERO_MAGNIFICATION_INDEX) {
            return idx - 1;
        }
        return idx;
    }

    public float getDefaultZoomFactor() {
        return this.defaultZoomFactor;
    }

    public void setDefaultZoomFactor(float zoom) {
        float oldDefaultZoom = this.getDefaultZoomFactor();
        if (zoom == oldDefaultZoom) {
            return;
        }
        int idx = ImagePanel.getIndexForLevel(ZOOM_LEVELS, zoom);
        this.defaultZoomFactor = ZOOM_LEVELS[idx];
        this.firePropertyChange(DEFAULT_ZOOM_PROPERTY, oldDefaultZoom, zoom);
    }

    public void resetZoom() {
        this.setZoomFactor(this.getDefaultZoomFactor());
    }

    private Point getImageComponentCenter() {
        Rectangle bounds = this.imageScroller.getBounds();
        double cx = bounds.getCenterX();
        double cy = bounds.getCenterY();
        Point p = new Point(bounds.x + (int)cx, bounds.y + (int)cy);
        return p;
    }

    public boolean canZoomIn() {
        return this.image != null && this.zoomLevelIndex < ZOOM_LEVELS.length - 1;
    }

    public void zoomIn() {
        this.zoomIn(this.getImageComponentCenter());
    }

    public void zoomIn(Point center) {
        if (!this.isImageZoomEnabled()) {
            return;
        }
        if (!this.canZoomIn()) {
            return;
        }
        float currentZoom = this.getZoomFactor();
        int idx = Math.min(ZOOM_LEVELS.length - 1, this.zoomLevelIndex + 1);
        if (this.zoomLevelIndex == idx) {
            return;
        }
        this.zoomLevelIndex = idx;
        float zoomFactor = ZOOM_LEVELS[idx];
        this.doZoom(center, zoomFactor);
        this.firePropertyChange(ZOOM_PROPERTY, currentZoom, this.getZoomFactor());
    }

    public boolean canZoomOut() {
        int realHeight = this.label.getIcon().getIconHeight();
        return this.image != null && this.zoomLevelIndex > 0 && realHeight > 1;
    }

    public void zoomOut() {
        this.zoomOut(this.getImageComponentCenter());
    }

    public void zoomOut(Point center) {
        if (!this.isImageZoomEnabled()) {
            return;
        }
        if (!this.canZoomOut()) {
            return;
        }
        float currentZoom = this.getZoomFactor();
        int idx = Math.max(0, this.zoomLevelIndex - 1);
        if (this.zoomLevelIndex == idx) {
            return;
        }
        int oldIndex = this.zoomLevelIndex;
        try {
            this.zoomLevelIndex = idx;
            float zoomFactor = ZOOM_LEVELS[idx];
            this.doZoom(center, zoomFactor);
        }
        catch (IllegalArgumentException iae) {
            idx = this.zoomLevelIndex = oldIndex;
            float zoomFactor = ZOOM_LEVELS[idx];
            this.doZoom(center, zoomFactor);
        }
        this.firePropertyChange(ZOOM_PROPERTY, currentZoom, this.getZoomFactor());
    }

    private void doZoom(Point center, float zoomFactor) {
        if (this.image == null) {
            this.label.setIcon(null);
            this.imageScroller.getViewport().setViewPosition(new Point(0, 0));
        } else {
            ImageIcon icon = new ImageIcon(this.image);
            int width = icon.getIconWidth();
            int height = icon.getIconHeight();
            Image scaled = this.image.getScaledInstance((int)((float)width * zoomFactor), (int)((float)height * zoomFactor), 2);
            this.label.setIcon(new ImageIcon(scaled));
            Point pos = this.imageScroller.getViewport().getViewPosition();
            int newX = (int)((float)center.x * (zoomFactor - 1.0f) + zoomFactor * (float)pos.x);
            int newY = (int)((float)center.y * (zoomFactor - 1.0f) + zoomFactor * (float)pos.y);
            this.imageScroller.getViewport().setViewPosition(new Point(newX, newY));
        }
        this.imageScroller.revalidate();
        this.imageScroller.repaint();
    }

    public boolean isImageZoomEnabled() {
        return this.zoomEnabled;
    }

    public void setImageZoomEnabled(boolean enabled) {
        this.zoomEnabled = enabled;
    }

    public void resetImageTranslation() {
        this.label.resetTranslation();
    }

    public boolean isTranslated() {
        return this.label.isTranslated();
    }

    public Point getTranslation() {
        return this.label.getTranslation();
    }

    private void translateImage(int dX, int dY) {
        if (!this.isImageTranslationEnabled()) {
            return;
        }
        if (dX == 0 && dY == 0) {
            return;
        }
        Point oldTranslation = this.label.getTranslation();
        this.label.translate(dX, dY);
        Point newTranslation = this.label.getTranslation();
        this.firePropertyChange(TRANSLATION_PROPERTY, oldTranslation, newTranslation);
    }

    public boolean isImageTranslationEnabled() {
        return this.translateEnabled;
    }

    public void setImageTranslationEnabled(boolean enabled) {
        this.translateEnabled = enabled;
    }

    private class PanAndZoomComponent
    extends GIconLabel {
        public static final String TRANSLATION_RESET_PROPERTY = "translation-reset";
        private int translateX;
        private int translateY;
        private boolean resetTranslation;

        public PanAndZoomComponent(Icon image, int horizontalAlignment) {
            super(image, horizontalAlignment);
            this.translateX = 0;
            this.translateY = 0;
            this.resetTranslation = false;
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    PanAndZoomComponent.this.repaint();
                }
            });
        }

        public void translate(int dX, int dY) {
            this.translateX += dX;
            this.translateY += dY;
            this.repaint();
        }

        public Point getTranslation() {
            return new Point(this.translateX, this.translateY);
        }

        public boolean isTranslated() {
            return this.translateX != 0 || this.translateY != 0 || this.resetTranslation;
        }

        public void resetTranslation() {
            this.translateX *= -1;
            this.translateY *= -1;
            this.resetTranslation = true;
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            AffineTransform tx = new AffineTransform();
            Point oldTranslation = this.getTranslation();
            tx.translate(this.translateX, this.translateY);
            Graphics2D g2 = (Graphics2D)g;
            g2.setTransform(tx);
            super.paint(g);
            if (this.resetTranslation) {
                this.translateY = 0;
                this.translateX = 0;
                this.resetTranslation = false;
                this.firePropertyChange(TRANSLATION_RESET_PROPERTY, oldTranslation, this.getTranslation());
            }
        }
    }
}

