/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.DockingWindowManager;
import docking.Node;
import docking.SplitPanel;
import docking.WindowNode;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.jdom.Content;
import org.jdom.Element;

class SplitNode
extends Node {
    private Node child1;
    private Node child2;
    private JComponent comp;
    private SplitPanel splitPane;
    private boolean isHorizontal;
    private float dividerPosition = 0.0f;
    private Dimension splitPaneSize;

    SplitNode(DockingWindowManager winMgr, Node child1, Node child2, boolean isHorizontal) {
        super(winMgr);
        this.isHorizontal = isHorizontal;
        this.child1 = child1;
        this.child2 = child2;
        child1.parent = this;
        child2.parent = this;
    }

    SplitNode(Element elem, DockingWindowManager mgr, Node parent, List<ComponentPlaceholder> restoredPlaceholders) {
        super(mgr);
        this.parent = parent;
        this.dividerPosition = (float)Integer.parseInt(elem.getAttributeValue("DIVIDER_LOCATION")) / 1000.0f;
        int width = Integer.parseInt(elem.getAttributeValue("WIDTH"));
        int height = Integer.parseInt(elem.getAttributeValue("HEIGHT"));
        this.splitPaneSize = new Dimension(width, height);
        String orient = elem.getAttributeValue("ORIENTATION");
        this.isHorizontal = orient.equals("HORIZONTAL");
        List list = elem.getChildren();
        this.child1 = this.processChildElement((Element)list.get(0), mgr, this, restoredPlaceholders);
        this.child2 = this.processChildElement((Element)list.get(1), mgr, this, restoredPlaceholders);
    }

    @Override
    void close() {
        this.child1.close();
        this.child2.close();
    }

    @Override
    JComponent getComponent() {
        if (this.invalid) {
            if (this.splitPane != null) {
                this.dividerPosition = ((SplitPanel)this.comp).getDividerPosition();
                this.splitPaneSize = this.comp.getSize();
            }
            this.splitPane = null;
            this.comp = null;
            JComponent comp1 = this.child1.getComponent();
            JComponent comp2 = this.child2.getComponent();
            if (comp1 != null && comp2 != null) {
                this.splitPane = new SplitPanel(this, comp1, comp2, this.isHorizontal);
                this.splitPane.setBorder(BorderFactory.createEmptyBorder());
                if (this.splitPaneSize != null) {
                    this.splitPane.setSize(this.splitPaneSize);
                    this.splitPane.setDividerPosition(this.dividerPosition);
                }
                this.comp = this.splitPane;
            } else {
                this.comp = comp1 != null ? comp1 : comp2;
            }
            this.invalid = false;
        }
        return this.comp;
    }

    @Override
    void removeNode(Node node) {
        if (node == this.child1) {
            this.parent.replaceNode(this, this.child2);
        } else if (node == this.child2) {
            this.parent.replaceNode(this, this.child1);
        }
    }

    @Override
    void replaceNode(Node oldNode, Node newNode) {
        if (oldNode != this.child1 && oldNode != this.child2) {
            throw new IllegalArgumentException();
        }
        if (oldNode == this.child1) {
            this.child1 = newNode;
        } else {
            this.child2 = newNode;
        }
        newNode.parent = this;
        this.invalidate();
        this.winMgr.scheduleUpdate();
    }

    @Override
    Element saveToXML() {
        Element root = new Element("SPLIT_NODE");
        if (this.splitPane != null) {
            this.dividerPosition = this.splitPane.getDividerPosition();
            this.splitPaneSize = this.splitPane.getSize();
        }
        if (this.splitPaneSize == null) {
            this.splitPaneSize = new Dimension(100, 100);
        }
        root.setAttribute("WIDTH", "" + this.splitPaneSize.width);
        root.setAttribute("HEIGHT", "" + this.splitPaneSize.height);
        root.setAttribute("DIVIDER_LOCATION", "" + Math.round(this.dividerPosition * 1000.0f));
        root.setAttribute("ORIENTATION", this.isHorizontal ? "HORIZONTAL" : "VERTICAL");
        root.addContent((Content)this.child1.saveToXML());
        root.addContent((Content)this.child2.saveToXML());
        return root;
    }

    @Override
    boolean contains(ComponentPlaceholder info) {
        if (this.child1 != null && this.child1.contains(info)) {
            return true;
        }
        return this.child2 != null && this.child2.contains(info);
    }

    @Override
    void populateActiveComponents(List<ComponentPlaceholder> list) {
        this.child1.populateActiveComponents(list);
        this.child2.populateActiveComponents(list);
    }

    @Override
    WindowNode getTopLevelNode() {
        if (this.parent != null) {
            return this.parent.getTopLevelNode();
        }
        return null;
    }

    @Override
    List<Node> getChildren() {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.child1 != null) {
            list.add(this.child1);
        }
        if (this.child2 != null) {
            list.add(this.child2);
        }
        return list;
    }

    public String toString() {
        return this.printTree();
    }

    @Override
    String getDescription() {
        return "Split Node";
    }
}

