/*
 * Decompiled with CFR 0.152.
 */
package docking.options.editor;

import docking.options.editor.SettableColorSwatchChooserPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class GhidraColorChooser
extends JColorChooser {
    private static final String DEFAULT_TITLE = "Please Choose a Color";
    private String title = "Please Choose a Color";
    private RecentColorCache recentColorCache = new RecentColorCache();

    public GhidraColorChooser() {
    }

    public GhidraColorChooser(Color initialColor) {
        super(initialColor);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setColorHistory(List<Color> colors) {
        for (Color color : colors) {
            this.recentColorCache.addColor(color);
        }
    }

    public List<Color> getColorHistory() {
        return this.recentColorCache.getMRUColorList();
    }

    public Color showDialog(Component centerOverComponent) {
        this.maybeInstallSettableColorSwatchChooserPanel();
        OKListener okListener = new OKListener();
        JDialog dialog = GhidraColorChooser.createDialog(centerOverComponent, this.title, true, this, okListener, null);
        dialog.show();
        Color color = okListener.getColor();
        if (color != null) {
            this.recentColorCache.addColor(color);
        }
        return color;
    }

    private void maybeInstallSettableColorSwatchChooserPanel() {
        AbstractColorChooserPanel panel;
        if (this.recentColorCache.size() == 0) {
            return;
        }
        List<Color> mruColorList = this.recentColorCache.getMRUColorList();
        AbstractColorChooserPanel[] chooserPanels = this.getChooserPanels();
        if (chooserPanels != null & chooserPanels.length > 1 && (panel = chooserPanels[0]) instanceof SettableColorSwatchChooserPanel) {
            ((SettableColorSwatchChooserPanel)panel).setRecentColors(mruColorList);
            return;
        }
        SettableColorSwatchChooserPanel newSwatchPanel = new SettableColorSwatchChooserPanel(mruColorList);
        AbstractColorChooserPanel[] newChooserPanels = new AbstractColorChooserPanel[]{newSwatchPanel, chooserPanels[1], chooserPanels[2]};
        this.setChooserPanels(newChooserPanels);
    }

    private class RecentColorCache
    extends LinkedHashMap<Color, Color>
    implements Iterable<Color> {
        private static final int MAX_SIZE = 15;

        public RecentColorCache() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Color, Color> eldest) {
            return this.size() > 15;
        }

        @Override
        public Iterator<Color> iterator() {
            return this.keySet().iterator();
        }

        public void addColor(Color color) {
            this.put(color, color);
        }

        public List<Color> getMRUColorList() {
            ArrayList<Color> list = new ArrayList<Color>(this.keySet());
            Collections.reverse(list);
            return list;
        }
    }

    private class OKListener
    implements ActionListener {
        private Color okColor;

        private OKListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.okColor = GhidraColorChooser.this.getColor();
        }

        Color getColor() {
            return this.okColor;
        }
    }
}

