/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.filechooser;

import java.io.File;
import java.io.IOException;

public class GhidraFile
extends File {
    private static final long serialVersionUID = 1L;
    private char nativeSeparator = separatorChar;

    public GhidraFile(String parent, String child, char separator) {
        super(parent, child);
        this.nativeSeparator = separator;
    }

    public GhidraFile(String path, char separator) {
        super(path);
        this.nativeSeparator = separator;
    }

    public GhidraFile(File parent, String name, char separator) {
        super(parent, name);
        this.nativeSeparator = separator;
    }

    @Override
    public File getAbsoluteFile() {
        if (this.nativeSeparator == separatorChar) {
            return super.getAbsoluteFile();
        }
        return this;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        if (this.nativeSeparator == separatorChar) {
            return super.getCanonicalFile();
        }
        return this;
    }

    @Override
    public String getAbsolutePath() {
        if (this.nativeSeparator == separatorChar) {
            return super.getAbsolutePath();
        }
        return this.getPath();
    }

    @Override
    public String getCanonicalPath() throws IOException {
        if (this.nativeSeparator == separatorChar) {
            return super.getCanonicalPath();
        }
        return this.getPath();
    }

    @Override
    public String getParent() {
        if (this.nativeSeparator == separatorChar) {
            return super.getParent();
        }
        String parent = super.getParent();
        if (parent == null) {
            return null;
        }
        return parent.replace(separatorChar, this.nativeSeparator);
    }

    @Override
    public File getParentFile() {
        if (this.nativeSeparator == separatorChar) {
            return super.getParentFile();
        }
        if (this.getParent() == null) {
            return null;
        }
        return new GhidraFile(this.getParent(), this.nativeSeparator);
    }

    @Override
    public String getPath() {
        if (this.nativeSeparator == separatorChar) {
            return super.getPath();
        }
        return super.getPath().replace(separatorChar, this.nativeSeparator);
    }
}

