/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.matchtable;

import ghidra.feature.vt.api.main.VTAssociationMarkupStatus;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;

public class VTMarkupStatusIcon
implements Icon {
    private int BORDER = 2;
    private int WIDTH = 44;
    private int KNOB_WIDTH = 4;
    private int HEIGHT = 16;
    private VTAssociationMarkupStatus status = new VTAssociationMarkupStatus(255);

    @Override
    public int getIconHeight() {
        return this.HEIGHT;
    }

    @Override
    public int getIconWidth() {
        return this.WIDTH + this.KNOB_WIDTH;
    }

    void setStatus(VTAssociationMarkupStatus status) {
        this.status = status;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        double size;
        List<Color> colors = this.getColors(this.status);
        int numColors = colors.size();
        double d = size = numColors == 0 ? 0.0 : ((double)this.WIDTH - (double)(2 * this.BORDER) - 1.0) / (double)numColors;
        if (this.status.hasUnexaminedMarkup()) {
            size /= 2.0;
        }
        for (int i = 0; i < numColors; ++i) {
            int startX = (int)((double)i * size);
            int endX = (int)((double)(i + 1) * size);
            int width = endX - startX;
            this.drawBar(g, x + startX + this.BORDER + 1, y + this.BORDER + 1, width, colors.get(i));
        }
        g.setColor(Color.BLACK);
        g.drawRect(x, y, this.WIDTH, this.HEIGHT);
        g.drawRect(x + this.WIDTH, y + this.HEIGHT / 2 - 3, this.KNOB_WIDTH, 6);
    }

    private void drawBar(Graphics g, int x, int y, int width, Color color) {
        g.setColor(color);
        g.fillRect(x, y, width, this.HEIGHT - 2 * this.BORDER - 1);
    }

    private List<Color> getColors(VTAssociationMarkupStatus status) {
        Color ORANGE = new Color(255, 150, 0);
        Color GREEN = new Color(0, 180, 0);
        Color BLUE = new Color(80, 80, 240);
        ArrayList<Color> list = new ArrayList<Color>(4);
        if (status.hasRejectedMarkup()) {
            list.add(Color.RED);
        }
        if (status.hasAppliedMarkup() || status.isFullyApplied()) {
            list.add(GREEN);
        }
        if (status.hasDontCareMarkup()) {
            list.add(BLUE);
        }
        if (status.hasDontKnowMarkup()) {
            list.add(ORANGE);
        }
        return list;
    }
}

