/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.vertex;

import ghidra.app.plugin.core.functiongraph.graph.FunctionGraph;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayout;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AddressHasher;
import ghidra.app.plugin.core.functiongraph.graph.vertex.AddressInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedVertexInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.PointInfo;
import ghidra.app.plugin.core.functiongraph.graph.vertex.VertexInfo;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGData;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;

public class GroupHistoryInfo {
    static final String GROUP_HISTORY_ELEMENT_NAME = "GROUP_HISTORY";
    private static final String GROUP_DESCRIPTION_ATTRIBUTE = "GROUP_DESCRIPTION";
    private final Set<FGVertex> groupVertices;
    private String groupDescription;
    private final AddressInfo addressInfo;
    private final PointInfo locationInfo;

    public GroupHistoryInfo(FunctionGraph functionGraph, GroupedFunctionGraphVertex groupVertex) {
        this.groupVertices = new HashSet<FGVertex>(groupVertex.getVertices());
        if (this.groupVertices.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a group history entry with no vertices!");
        }
        this.groupDescription = groupVertex.getUserText();
        if (this.groupDescription == null) {
            throw new IllegalArgumentException("Group description cannot be null");
        }
        FGLayout graphLayout = functionGraph.getLayout();
        Point2D location = (Point2D)graphLayout.apply(groupVertex);
        this.locationInfo = new PointInfo(location);
        this.addressInfo = new AddressInfo(groupVertex);
    }

    public GroupHistoryInfo(FGController controller, Element element) {
        FGVertex vertex;
        VertexInfo vertexInfo;
        Element vertexInfoElement2;
        FGData functionGraphData = controller.getFunctionGraphData();
        FunctionGraph functionGraph = functionGraphData.getFunctionGraph();
        Map<AddressHasher, FGVertex> vertexMap = GroupHistoryInfo.hashVerticesByStartAndEndAddress(functionGraph);
        this.groupVertices = new HashSet<FGVertex>();
        List children = element.getChildren("VERTEX_INFO");
        for (Element vertexInfoElement2 : children) {
            vertexInfo = new VertexInfo(vertexInfoElement2);
            vertex = vertexInfo.getVertex(controller, vertexMap);
            if (vertex != null) {
                this.groupVertices.add(vertex);
                continue;
            }
            Msg.debug((Object)this, (Object)("Unable to re-serialize vertex for info: " + vertexInfo));
        }
        children = element.getChildren("GROUPED_VERTEX_INFO");
        for (Element vertexInfoElement2 : children) {
            vertexInfo = new GroupedVertexInfo(vertexInfoElement2);
            vertex = ((GroupedVertexInfo)vertexInfo).locateVertex(controller, vertexMap);
            if (vertex != null) {
                this.groupVertices.add(vertex);
                continue;
            }
            Msg.debug((Object)this, (Object)("Unable to re-serialize vertex for info: " + (GroupedVertexInfo)vertexInfo));
        }
        String escpapedGroupDescription = element.getAttributeValue(GROUP_DESCRIPTION_ATTRIBUTE);
        this.groupDescription = XmlUtilities.unEscapeElementEntities((String)escpapedGroupDescription);
        vertexInfoElement2 = element.getChild("VERTEX_ADDRESS_INFO");
        this.addressInfo = new AddressInfo(vertexInfoElement2);
        Element locationElement = element.getChild("LOCATION_POINT_INFO");
        Element pointInfoElement = locationElement.getChild("POINT_INFO");
        this.locationInfo = new PointInfo(pointInfoElement);
    }

    public void setGroupDescription(String text) {
        this.groupDescription = text;
        for (FGVertex vertex : this.groupVertices) {
            vertex.updateGroupAssociationStatus(this);
        }
    }

    public boolean contains(FGVertex vertex) {
        for (FGVertex child : this.groupVertices) {
            if (!this.matchesOrContains(child, vertex)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesOrContains(FGVertex potentialMatch, FGVertex vertex) {
        if (potentialMatch.equals(vertex)) {
            return true;
        }
        if (potentialMatch instanceof GroupedFunctionGraphVertex) {
            Set<FGVertex> vertices = ((GroupedFunctionGraphVertex)potentialMatch).getVertices();
            for (FGVertex child : vertices) {
                if (!this.matchesOrContains(child, vertex)) continue;
                return true;
            }
        }
        return false;
    }

    public void removeVertex(FGVertex vertex) {
        this.updateGroupDescription(vertex);
        this.groupVertices.remove(vertex);
        this.removeFromGroups(vertex);
    }

    private void updateGroupDescription(FGVertex vertex) {
        String text = GroupedFunctionGraphVertex.getVertexDescription(vertex);
        int index = this.groupDescription.indexOf(text);
        if (index != -1) {
            StringBuffer buffy = new StringBuffer(this.groupDescription);
            buffy.delete(index, index + text.length());
            this.groupDescription = buffy.toString();
        }
    }

    private void removeFromGroups(FGVertex oldVertex) {
        HashSet<FGVertex> vertices = new HashSet<FGVertex>(this.groupVertices);
        for (FGVertex vertex : vertices) {
            GroupedFunctionGraphVertex oldGroup;
            GroupedFunctionGraphVertex newGroup;
            if (vertex.equals(oldVertex)) {
                this.groupVertices.remove(oldVertex);
                continue;
            }
            if (!(vertex instanceof GroupedFunctionGraphVertex) || (newGroup = this.removeFromGroup(oldVertex, oldGroup = (GroupedFunctionGraphVertex)vertex)) == null) continue;
            this.groupVertices.remove(oldGroup);
            this.groupVertices.add(newGroup);
        }
    }

    private GroupedFunctionGraphVertex removeFromGroup(FGVertex oldVertex, GroupedFunctionGraphVertex oldGroup) {
        HashSet<FGVertex> toRemove = new HashSet<FGVertex>();
        Set<FGVertex> vertices = oldGroup.getVertices();
        for (FGVertex vertex : vertices) {
            GroupedFunctionGraphVertex newGroup;
            if (vertex.equals(oldVertex)) {
                toRemove.add(vertex);
            }
            if (!(vertex instanceof GroupedFunctionGraphVertex) || (newGroup = this.removeFromGroup(oldVertex, (GroupedFunctionGraphVertex)vertex)) == null) continue;
            this.groupVertices.remove(oldGroup);
            this.groupVertices.add(newGroup);
        }
        return oldGroup.removeAll(toRemove);
    }

    public Point2D getGroupLocation() {
        return this.locationInfo.getPoint();
    }

    public Set<FGVertex> getVertices() {
        return Collections.unmodifiableSet(this.groupVertices);
    }

    public String getGroupDescription() {
        return this.groupDescription;
    }

    public Element toXML(FunctionGraph functionGraph) {
        Element element = new Element(GROUP_HISTORY_ELEMENT_NAME);
        for (FGVertex vertex : this.groupVertices) {
            VertexInfo vertexInfo;
            if (vertex instanceof GroupedFunctionGraphVertex) {
                vertexInfo = new GroupedVertexInfo((GroupedFunctionGraphVertex)vertex, functionGraph);
                element.addContent((Content)((GroupedVertexInfo)vertexInfo).toXML());
                continue;
            }
            vertexInfo = new VertexInfo(vertex, functionGraph);
            element.addContent((Content)vertexInfo.toXML());
        }
        String escapedText = XmlUtilities.escapeElementEntities((String)this.groupDescription);
        element.setAttribute(GROUP_DESCRIPTION_ATTRIBUTE, escapedText);
        this.addressInfo.write(element);
        Element locationElement = new Element("LOCATION_POINT_INFO");
        this.locationInfo.write(locationElement);
        element.addContent((Content)locationElement);
        return element;
    }

    public String toString() {
        return "text=\"" + this.groupDescription + "\", AddressInfo=" + this.addressInfo + ", location=" + this.locationInfo;
    }

    private static Map<AddressHasher, FGVertex> hashVerticesByStartAndEndAddress(FunctionGraph functionGraph) {
        HashMap<AddressHasher, FGVertex> map = new HashMap<AddressHasher, FGVertex>();
        FunctionGraph graph = functionGraph;
        Collection vertices = graph.getVertices();
        for (FGVertex vertex : vertices) {
            AddressSetView addresses = vertex.getAddresses();
            Address minAddress = addresses.getMinAddress();
            Address maxAddress = addresses.getMaxAddress();
            map.put(new AddressHasher(minAddress, maxAddress), vertex);
        }
        return map;
    }
}

