/*
 * Decompiled with CFR 0.152.
 */
package util.demangler;

import java.util.ArrayList;
import java.util.List;
import util.demangler.GenericDemangledDataType;
import util.demangler.ParameterReceiver;

public class GenericDemangledFunctionPointer
extends GenericDemangledDataType
implements ParameterReceiver {
    private static final String DEFAULT_NAME_PREFIX = "FuncDef";
    private static final String EMPTY_STRING = "";
    private static final Object NAMESPACE_DELIMITER = "::";
    private static int ID = 0;
    private GenericDemangledDataType returnType;
    protected String callingConvention;
    private List<GenericDemangledDataType> parameters = new ArrayList<GenericDemangledDataType>();
    private boolean isConstPointer;
    private String parentName;
    private boolean isTrailingPointer64;

    public GenericDemangledFunctionPointer() {
        super(DEFAULT_NAME_PREFIX + GenericDemangledFunctionPointer.nextID());
    }

    public GenericDemangledDataType getReturnType() {
        return this.returnType;
    }

    public void setReturnType(GenericDemangledDataType returnType) {
        this.returnType = returnType;
    }

    public String getCallingConvention() {
        return this.callingConvention;
    }

    public void setCallingConvention(String callingConvention) {
        this.callingConvention = callingConvention;
    }

    @Override
    public void addParameter(GenericDemangledDataType parameter) {
        this.parameters.add(parameter);
    }

    @Override
    public List<GenericDemangledDataType> getParameters() {
        return new ArrayList<GenericDemangledDataType>(this.parameters);
    }

    @Override
    public GenericDemangledDataType copy() {
        GenericDemangledFunctionPointer copy = new GenericDemangledFunctionPointer();
        this.copyInto(copy);
        return copy;
    }

    @Override
    public void copyInto(GenericDemangledDataType destination) {
        super.copyInto(destination);
        GenericDemangledFunctionPointer source = this;
        if (destination instanceof GenericDemangledFunctionPointer) {
            GenericDemangledFunctionPointer copySource = source;
            GenericDemangledFunctionPointer copyDestination = (GenericDemangledFunctionPointer)destination;
            if (copySource.returnType != null) {
                copyDestination.returnType = copySource.returnType.copy();
            }
            for (GenericDemangledDataType parameter : copySource.parameters) {
                copyDestination.parameters.add(parameter.copy());
            }
            copyDestination.callingConvention = copySource.callingConvention;
            copyDestination.isConstPointer |= copySource.isConstPointer;
        }
    }

    @Override
    public String toSignature() {
        return this.toSignature(null);
    }

    public String toSignature(String name) {
        String s;
        StringBuffer buffer = new StringBuffer();
        if (this.returnType != null) {
            buffer.append(this.returnType.toSignature()).append(' ');
        }
        if ((s = this.getConventionPointerNameString(name)).contains(" ") || s.isEmpty()) {
            buffer.append('(').append(s).append(')');
        } else {
            buffer.append(s);
        }
        buffer.append('(');
        for (int i = 0; i < this.parameters.size(); ++i) {
            buffer.append(this.parameters.get(i).toSignature());
            if (i >= this.parameters.size() - 1) continue;
            buffer.append(',');
        }
        buffer.append(')');
        if (this.isConst()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("const");
        }
        if (this.isVolatile()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("volatile");
        }
        if (this.isTrailingPointer64) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__ptr64");
        }
        return buffer.toString();
    }

    private String getConventionPointerNameString(String name) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.callingConvention == null ? EMPTY_STRING : this.callingConvention);
        int pointerLevels = this.getPointerLevels();
        if (pointerLevels > 0) {
            if (this.callingConvention != null) {
                buffer.append(' ');
            }
            this.addParentName(buffer);
            for (int i = 0; i < pointerLevels; ++i) {
                buffer.append('*');
            }
        }
        if (this.isConstPointer) {
            buffer.append("const");
        }
        if (this.isPointer64()) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append("__ptr64");
        }
        if (name != null) {
            if (buffer.length() > 2) {
                buffer.append(' ');
            }
            buffer.append(name);
        }
        return buffer.toString();
    }

    private void addParentName(StringBuilder buffer) {
        char lastChar;
        if (this.parentName == null) {
            return;
        }
        if (this.parentName.startsWith(DEFAULT_NAME_PREFIX)) {
            return;
        }
        if (buffer.length() > 2 && ' ' != (lastChar = buffer.charAt(buffer.length() - 1))) {
            buffer.append(' ');
        }
        buffer.append(this.parentName).append(NAMESPACE_DELIMITER);
    }

    public void setConstPointer() {
        this.isConstPointer = true;
    }

    public boolean isConstPointer() {
        return this.isConstPointer;
    }

    public void setParentName(String parentName) {
        this.parentName = parentName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setTrailingPointer64() {
        this.isTrailingPointer64 = true;
    }

    public boolean isTrailingPointer64() {
        return this.isTrailingPointer64;
    }

    public void clearPointer64() {
        this.isPointer64 = false;
    }

    private static synchronized int nextID() {
        return ID++;
    }

    public int getID() {
        return ID;
    }
}

