/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.DockingWindowManager;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.gui.plugin.SubToolContext;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.util.HelpLocation;
import java.util.ArrayList;
import javax.swing.Icon;

public class MatchActionWrapper
extends DockingAction {
    private final VTPlugin plugin;
    private final DockingAction wrappedAction;
    private SubToolContext subToolContext;
    private ActionContext wrappedContext;

    public MatchActionWrapper(VTPlugin plugin, DockingAction action) {
        super("Wrapped Match Action: " + action.getName(), VTPlugin.OWNER);
        this.plugin = plugin;
        this.wrappedAction = action;
        Icon icon = null;
        String menuGroup = null;
        MenuData popupMenuData = this.wrappedAction.getPopupMenuData();
        if (popupMenuData != null) {
            icon = popupMenuData.getMenuIcon();
            menuGroup = popupMenuData.getMenuGroup();
        }
        this.setPopupMenuData(new MenuData(new String[]{"Version Tracking Match", action.getName()}, icon, menuGroup));
        HelpLocation helpLocation = DockingWindowManager.getHelpService().getHelpLocation((Object)action);
        if (helpLocation != null) {
            this.setHelpLocation(helpLocation);
        }
    }

    public void actionPerformed(ActionContext context) {
        VTController controller = this.plugin.getController();
        if (this.wrappedAction.isEnabledForContext(this.wrappedContext)) {
            this.wrappedAction.actionPerformed(this.wrappedContext);
        }
        VTMatch match = this.subToolContext.getMatch();
        controller.setSelectedMatch(match);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        this.wrappedContext = this.createActionContext(context);
        if (this.wrappedContext == null) {
            return false;
        }
        return this.wrappedAction.isEnabledForContext(this.wrappedContext);
    }

    public ActionContext createActionContext(ActionContext originalContext) {
        this.getSubToolContext();
        VTController controller = this.plugin.getController();
        ArrayList<VTMatch> list = new ArrayList<VTMatch>();
        VTMatch match = this.subToolContext.getMatch();
        if (match == null) {
            return null;
        }
        list.add(match);
        return new VTMatchContext(this.plugin.getMatchesProvider(), list, controller.getSession());
    }

    public SubToolContext getSubToolContext() {
        this.subToolContext = new SubToolContext(this.plugin);
        return this.subToolContext;
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof CodeViewerActionContext)) {
            return false;
        }
        this.wrappedContext = this.createActionContext(context);
        VTMatch match = this.subToolContext.getMatch();
        return match != null;
    }
}

