/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.task.SaveTask;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import javax.swing.Icon;
import resources.ResourceManager;

public class SaveVersionTrackingSessionAction
extends DockingAction {
    static final Icon ICON = ResourceManager.loadImage((String)"images/disk.png");
    private final VTController controller;

    public SaveVersionTrackingSessionAction(VTController controller) {
        super("Save", VTPlugin.OWNER);
        this.controller = controller;
        this.setToolBarData(new ToolBarData(ICON, "AAA_VT_Main"));
        this.setMenuBarData(new MenuData(new String[]{"&File", "Save Session"}, ICON, "AAC"));
        this.setDescription("Save Version Tracking Changes");
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Version_Tracking_Tool"));
    }

    public void actionPerformed(ActionContext context) {
        VTSession session = this.controller.getSession();
        if (session == null) {
            return;
        }
        if (session instanceof VTSessionDB) {
            VTSessionDB sessionDB = (VTSessionDB)session;
            DomainFile vtDomainFile = sessionDB.getDomainFile();
            SaveTask saveVersionTrackingTask = new SaveTask(vtDomainFile);
            TaskLauncher.launch((Task)saveVersionTrackingTask);
            Program program = this.controller.getDestinationProgram();
            DomainFile destinationProgramFile = program.getDomainFile();
            if (destinationProgramFile.isChanged()) {
                SaveTask saveDestinationTask = new SaveTask(destinationProgramFile);
                TaskLauncher.launch((Task)saveDestinationTask);
            }
            this.controller.refresh();
        }
    }

    private boolean hasUnsavedVersionTrackingChanges() {
        VTSessionDB sessionDB;
        VTSession session = this.controller.getSession();
        if (session == null) {
            return false;
        }
        if (session instanceof VTSessionDB && (sessionDB = (VTSessionDB)session).isChanged()) {
            return true;
        }
        Program destinationProgram = this.controller.getDestinationProgram();
        return destinationProgram.isChanged();
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.hasUnsavedVersionTrackingChanges();
    }

    public boolean isAddToPopup(ActionContext context) {
        return true;
    }
}

