/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh;

import ghidra.app.plugin.assembler.AssemblerBuilder;
import ghidra.app.plugin.assembler.AssemblySelector;
import ghidra.app.plugin.assembler.sleigh.SleighAssembler;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblyGrammar;
import ghidra.app.plugin.assembler.sleigh.grammars.AssemblySentential;
import ghidra.app.plugin.assembler.sleigh.parse.AssemblyParser;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyContextGraph;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyDefaultContext;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNonTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericMapTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyNumericTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringMapTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblyStringTerminal;
import ghidra.app.plugin.assembler.sleigh.symbol.AssemblySymbol;
import ghidra.app.plugin.assembler.sleigh.util.DbgTimer;
import ghidra.app.plugin.languages.sleigh.SleighLanguages;
import ghidra.app.plugin.languages.sleigh.SubtableEntryVisitor;
import ghidra.app.plugin.processors.sleigh.Constructor;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.pattern.DisjointPattern;
import ghidra.app.plugin.processors.sleigh.symbol.EndSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.NameSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.OperandSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.StartSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.SubtableSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.Symbol;
import ghidra.app.plugin.processors.sleigh.symbol.TripleSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.UseropSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.ValueMapSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.ValueSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeListSymbol;
import ghidra.app.plugin.processors.sleigh.symbol.VarnodeSymbol;
import ghidra.app.plugin.processors.sleigh.template.ConstructTpl;
import ghidra.app.plugin.processors.sleigh.template.HandleTpl;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Program;
import ghidra.util.SystemUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;

public class SleighAssemblerBuilder
implements AssemblerBuilder {
    protected static final DbgTimer dbg = SystemUtilities.isInTestingBatchMode() ? DbgTimer.INACTIVE : DbgTimer.ACTIVE;
    protected SleighLanguage lang;
    protected AssemblyGrammar grammar;
    protected AssemblyDefaultContext defaultContext;
    protected AssemblyContextGraph ctxGraph;
    protected AssemblyParser parser;
    protected boolean generated = false;
    protected Map<String, AssemblySymbol> builtSymbols = new HashMap<String, AssemblySymbol>();

    public SleighAssemblerBuilder(SleighLanguage lang) {
        this.lang = lang;
    }

    protected void generateAssembler() throws SleighException {
        if (this.generated) {
            return;
        }
        this.generated = true;
        try {
            this.buildGrammar();
            this.grammar.verify();
            this.buildContext();
            this.buildContextGraph();
            this.buildParser();
        }
        catch (SleighException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public LanguageID getLanguageID() {
        return this.lang.getLanguageID();
    }

    @Override
    public SleighLanguage getLanguage() {
        return this.lang;
    }

    @Override
    public SleighAssembler getAssembler(AssemblySelector selector) {
        this.generateAssembler();
        SleighAssembler asm = new SleighAssembler(selector, this.lang, this.parser, this.defaultContext, this.ctxGraph);
        return asm;
    }

    @Override
    public SleighAssembler getAssembler(AssemblySelector selector, Program program) {
        this.generateAssembler();
        return new SleighAssembler(selector, program, this.parser, this.defaultContext, this.ctxGraph);
    }

    protected MultiValuedMap<String, Integer> invVarnodeList(VarnodeListSymbol vnlist) {
        HashSetValuedHashMap result = new HashSetValuedHashMap();
        int index = -1;
        for (VarnodeSymbol vnsym : vnlist.getVarnodeTable()) {
            ++index;
            if (vnsym == null) continue;
            result.put((Object)vnsym.getName(), (Object)index);
        }
        return result;
    }

    protected Map<Long, Integer> invValueMap(ValueMapSymbol vm) {
        HashMap<Long, Integer> result = new HashMap<Long, Integer>();
        List<Long> map = vm.getMap();
        for (int i = 0; i < map.size(); ++i) {
            long v = map.get(i);
            result.put(v, i);
        }
        return result;
    }

    protected MultiValuedMap<String, Integer> invNameSymbol(NameSymbol ns) {
        HashSetValuedHashMap result = new HashSetValuedHashMap();
        int index = -1;
        for (String name : ns.getNameTable()) {
            ++index;
            if (name == null) continue;
            result.put((Object)name, (Object)index);
        }
        return result;
    }

    protected AssemblySymbol getSymbolFor(Constructor cons, OperandSymbol opsym) {
        TripleSymbol defsym = opsym.getDefiningSymbol();
        Object name = defsym == null ? cons.getParent().getName() + ":" + opsym.getName() : opsym.getName();
        AssemblySymbol built = this.builtSymbols.get(name);
        if (built != null) {
            return built;
        }
        if (defsym == null) {
            built = new AssemblyNumericTerminal((String)name, this.getBitSize(cons, opsym));
        } else if (defsym instanceof SubtableSymbol) {
            built = new AssemblyNonTerminal((String)name);
        } else if (defsym instanceof VarnodeListSymbol) {
            built = new AssemblyStringMapTerminal((String)name, this.invVarnodeList((VarnodeListSymbol)defsym));
        } else if (defsym instanceof VarnodeSymbol) {
            built = new AssemblyStringTerminal((String)name);
        } else if (defsym instanceof ValueMapSymbol) {
            built = new AssemblyNumericMapTerminal((String)name, this.invValueMap((ValueMapSymbol)defsym));
        } else if (defsym instanceof NameSymbol) {
            built = new AssemblyStringMapTerminal((String)name, this.invNameSymbol((NameSymbol)defsym));
        } else {
            throw new RuntimeException("Unknown symbol for " + (String)name + ": " + defsym);
        }
        this.builtSymbols.put((String)name, built);
        return built;
    }

    protected int getBitSize(Constructor cons, OperandSymbol opsym) {
        ConstructTpl ctpl = cons.getTempl();
        if (null == ctpl) {
            return 0;
        }
        HandleTpl htpl = ctpl.getResult();
        if (null == htpl) {
            return 0;
        }
        if (opsym.getIndex() != htpl.getOffsetOperandIndex()) {
            return 0;
        }
        return htpl.getSize();
    }

    protected AssemblyGrammar buildSubGrammar(SubtableSymbol subtable) {
        final AssemblyGrammar subgrammar = new AssemblyGrammar();
        final AssemblyNonTerminal lhs = new AssemblyNonTerminal(subtable.getName());
        SleighLanguages.traverseConstructors(subtable, new SubtableEntryVisitor(){

            @Override
            public int visit(DisjointPattern pattern, Constructor cons) {
                AssemblySentential<AssemblyNonTerminal> rhs = new AssemblySentential<AssemblyNonTerminal>();
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (String str : cons.getPrintPieces()) {
                    if (str.length() == 0) continue;
                    if (str.charAt(0) == '\n') {
                        int index = str.charAt(1) - 65;
                        OperandSymbol opsym = cons.getOperand(index);
                        AssemblySymbol sym = SleighAssemblerBuilder.this.getSymbolFor(cons, opsym);
                        if (sym.takesOperandIndex()) {
                            indices.add(index);
                        }
                        rhs.add(sym);
                        continue;
                    }
                    String tstr = str.trim();
                    if (tstr.equals("")) {
                        rhs.addWS();
                        continue;
                    }
                    char first = tstr.charAt(0);
                    if (!str.startsWith(tstr)) {
                        rhs.addWS();
                    }
                    if (!Character.isLetterOrDigit(first)) {
                        rhs.addWS();
                    }
                    rhs.add(new AssemblyStringTerminal(str.trim()));
                    char last = tstr.charAt(tstr.length() - 1);
                    if (!str.endsWith(tstr)) {
                        rhs.addWS();
                    }
                    if (Character.isLetterOrDigit(last)) continue;
                    rhs.addWS();
                }
                subgrammar.addProduction(lhs, rhs, pattern, cons, indices);
                return 0;
            }
        });
        return subgrammar;
    }

    protected void buildGrammar() {
        try (DbgTimer.DbgCtx dc = dbg.start("Building grammar");){
            this.grammar = new AssemblyGrammar();
            for (Symbol sym : this.lang.getSymbolTable().getSymbolList()) {
                if (sym instanceof SubtableSymbol) {
                    SubtableSymbol subtable = (SubtableSymbol)sym;
                    this.grammar.combine(this.buildSubGrammar(subtable));
                    continue;
                }
                if (sym instanceof VarnodeSymbol || sym instanceof StartSymbol || sym instanceof EndSymbol || sym instanceof UseropSymbol || sym instanceof OperandSymbol || sym instanceof ValueSymbol) continue;
                throw new RuntimeException("Unexpected type: " + sym.getClass());
            }
            this.grammar.setStartName("instruction");
        }
    }

    protected void buildContext() {
        this.defaultContext = new AssemblyDefaultContext(this.lang);
    }

    protected void buildContextGraph() {
        try (DbgTimer.DbgCtx dc = dbg.start("Building context graph");){
            this.ctxGraph = new AssemblyContextGraph(this.lang, this.grammar);
        }
    }

    protected void buildParser() {
        try (DbgTimer.DbgCtx dc = dbg.start("Building parser");){
            this.parser = new AssemblyParser(this.grammar);
        }
    }

    protected AssemblyGrammar getGrammar() {
        return this.grammar;
    }

    protected AssemblyParser getParser() {
        return this.parser;
    }
}

