/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalReference;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.StackReference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.GhidraBigEndianDataConverter;
import ghidra.util.GhidraLittleEndianDataConverter;
import ghidra.util.Saveable;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.PropertyVisitor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

abstract class PseudoCodeUnit
implements CodeUnit {
    protected Address address;
    protected Address maxAddress;
    protected Program program;
    protected int length;
    protected static final Address[] emptyAddrArray = new Address[0];
    protected int hash;
    protected byte[] bytes;
    protected boolean isBigEndian;
    protected static final Reference[] emptyMemRefs = new Reference[0];
    protected Map<Integer, String> comments = new HashMap<Integer, String>();
    protected ReferenceManager refMgr;
    private boolean isValid = true;

    PseudoCodeUnit(Program program, Address addr, int length, MemBuffer memBuffer) throws AddressOverflowException {
        this(program, addr, length, length, memBuffer);
    }

    PseudoCodeUnit(Program program, Address addr, int length, int cacheLength, MemBuffer memBuffer) throws AddressOverflowException {
        this(addr, length, cacheLength, memBuffer);
        this.program = program;
        if (program != null) {
            this.refMgr = program.getReferenceManager();
        }
    }

    PseudoCodeUnit(Address addr, int length, MemBuffer memBuffer) throws AddressOverflowException {
        this(addr, length, length, memBuffer);
    }

    PseudoCodeUnit(Address addr, int length, int cacheLength, MemBuffer memBuffer) throws AddressOverflowException {
        this.address = addr;
        this.length = length;
        if (length <= 0) {
            throw new IllegalArgumentException("non-zero positive length required");
        }
        this.maxAddress = addr.addNoWrap(length - 1);
        this.isBigEndian = memBuffer.isBigEndian();
        this.bytes = new byte[cacheLength];
        memBuffer.getBytes(this.bytes, 0);
        this.hash = this.address.hashCode();
    }

    private void refresh() {
        this.bytes = new byte[this.bytes.length];
        try {
            this.program.getMemory().getBytes(this.address, this.bytes);
            this.isValid = true;
        }
        catch (MemoryAccessException e) {
            throw new RuntimeException("Not enough bytes in memory buffer to create code unit: " + e.getMessage());
        }
    }

    public void invalidate() {
        if (this.program == null) {
            throw new UnsupportedOperationException("Pseduo code unit has null program - refresh not supported");
        }
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public String getAddressString(boolean showBlockName, boolean pad) {
        MemoryBlock block;
        Address cuAddress = this.address;
        String addressString = cuAddress.toString(false, pad);
        if (showBlockName && this.program != null && (block = this.program.getMemory().getBlock(cuAddress)) != null) {
            return block.getName() + ":" + addressString;
        }
        return addressString;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    protected void refreshIfNeeded() {
        if (!this.isValid) {
            this.refresh();
        }
    }

    @Override
    public synchronized byte[] getBytes() throws MemoryAccessException {
        this.refreshIfNeeded();
        if (this.length == this.bytes.length) {
            return (byte[])this.bytes.clone();
        }
        byte[] byteArray = new byte[this.length];
        System.arraycopy(this.bytes, 0, byteArray, 0, this.length);
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(byte[] b, int offset) {
        if (this.program == null) {
            if (offset < 0 || offset >= this.bytes.length) {
                return 0;
            }
            int len = Math.min(b.length, this.bytes.length - offset);
            PseudoCodeUnit pseudoCodeUnit = this;
            synchronized (pseudoCodeUnit) {
                this.refreshIfNeeded();
                System.arraycopy(this.bytes, offset, b, 0, b.length);
            }
            return len;
        }
        if (offset < 0 || offset + b.length > this.bytes.length) {
            try {
                return this.program.getMemory().getBytes(this.address.add(offset), b);
            }
            catch (AddressOutOfBoundsException | MemoryAccessException e) {
                return 0;
            }
        }
        PseudoCodeUnit pseudoCodeUnit = this;
        synchronized (pseudoCodeUnit) {
            this.refreshIfNeeded();
            System.arraycopy(this.bytes, offset, b, 0, b.length);
            return b.length;
        }
    }

    @Override
    public synchronized void getBytesInCodeUnit(byte[] buffer, int bufferOffset) throws MemoryAccessException {
        this.refreshIfNeeded();
        System.arraycopy(this.bytes, 0, buffer, bufferOffset, Math.min(buffer.length, this.length));
    }

    @Override
    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        if (this.isBigEndian) {
            return GhidraBigEndianDataConverter.INSTANCE.getShort(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getShort(this, offset);
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        if (this.isBigEndian) {
            return GhidraBigEndianDataConverter.INSTANCE.getInt(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getInt(this, offset);
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        if (this.isBigEndian) {
            return GhidraBigEndianDataConverter.INSTANCE.getLong(this, offset);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getLong(this, offset);
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        if (this.isBigEndian) {
            return GhidraBigEndianDataConverter.INSTANCE.getBigInteger(this, offset, size, signed);
        }
        return GhidraLittleEndianDataConverter.INSTANCE.getBigInteger(this, offset, size, signed);
    }

    @Override
    public void setProperty(String name, Saveable value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String name, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String name, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Saveable getObjectProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getStringProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIntProperty(String name) throws NoValueException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasProperty(String name) {
        return false;
    }

    @Override
    public boolean getVoidProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> propertyNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeProperty(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitProperty(PropertyVisitor visitor, String propertyName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public String getLabel() {
        if (this.program == null) {
            return null;
        }
        SymbolTable st = this.program.getSymbolTable();
        Symbol symbol = st.getPrimarySymbol(this.address);
        if (symbol == null) {
            return null;
        }
        return symbol.getName();
    }

    @Override
    public Symbol[] getSymbols() {
        if (this.program == null) {
            return null;
        }
        SymbolTable st = this.program.getSymbolTable();
        return st.getSymbols(this.address);
    }

    @Override
    public Symbol getPrimarySymbol() {
        if (this.program == null) {
            return null;
        }
        SymbolTable st = this.program.getSymbolTable();
        return st.getPrimarySymbol(this.address);
    }

    @Override
    public Address getMinAddress() {
        return this.address;
    }

    @Override
    public Address getMaxAddress() {
        return this.maxAddress;
    }

    public CodeUnit getNextCodeUnit() {
        if (this.program == null) {
            return null;
        }
        return this.program.getListing().getCodeUnitAfter(this.address);
    }

    public CodeUnit getPreviousCodeUnit() {
        if (this.program == null) {
            return null;
        }
        return this.program.getListing().getCodeUnitBefore(this.address);
    }

    @Override
    public boolean isSuccessor(CodeUnit codeUnit) {
        Address min = codeUnit.getMinAddress();
        return this.getMaxAddress().isSuccessor(min);
    }

    @Override
    public String getComment(int commentType) {
        return this.comments.get(commentType);
    }

    @Override
    public String[] getCommentAsArray(int commentType) {
        String comment = this.comments.get(commentType);
        if (comment == null) {
            return new String[0];
        }
        String[] retvals = new String[]{comment};
        return retvals;
    }

    @Override
    public void setCommentAsArray(int commentType, String[] comment) {
        this.setComment(commentType, comment[0]);
    }

    @Override
    public void setComment(int commentType, String comment) {
        this.comments.put(commentType, comment);
        this.comments.put(commentType, comment);
    }

    @Override
    public boolean contains(Address testAddr) {
        Address endAddr = this.address.addWrap(this.getLength() - 1);
        return this.address.compareTo(testAddr) <= 0 && testAddr.compareTo(endAddr) <= 0;
    }

    @Override
    public int compareTo(Address a) {
        if (this.contains(a)) {
            return 0;
        }
        return this.address.compareTo(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        if (offset < 0 || offset >= this.bytes.length) {
            if (this.program == null) {
                throw new MemoryAccessException("Pseduo code unit has null program - memory request out of range");
            }
            Memory memory = this.program.getMemory();
            try {
                return memory.getByte(this.address.add(offset));
            }
            catch (AddressOutOfBoundsException e) {
                throw new MemoryAccessException(e.getMessage());
            }
        }
        PseudoCodeUnit pseudoCodeUnit = this;
        synchronized (pseudoCodeUnit) {
            this.refreshIfNeeded();
            return this.bytes[offset];
        }
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public Memory getMemory() {
        if (this.program == null) {
            return null;
        }
        return this.program.getMemory();
    }

    @Override
    public void addMnemonicReference(Address refAddr, RefType refType, SourceType sourceType) {
        if (this.refMgr == null) {
            throw new UnsupportedOperationException();
        }
        this.refMgr.addMemoryReference(this.address, refAddr, refType, sourceType, -1);
    }

    @Override
    public Reference[] getMnemonicReferences() {
        if (this.refMgr == null) {
            return emptyMemRefs;
        }
        return this.refMgr.getReferencesFrom(this.address, -1);
    }

    @Override
    public void removeMnemonicReference(Address refAddr) {
        if (this.refMgr == null) {
            throw new UnsupportedOperationException();
        }
        Reference ref = this.refMgr.getReference(this.address, refAddr, -1);
        if (ref != null) {
            this.refMgr.delete(ref);
        }
    }

    @Override
    public void addOperandReference(int opIndex, Address refAddr, RefType type, SourceType sourceType) {
        if (this.refMgr == null) {
            throw new UnsupportedOperationException();
        }
        this.refMgr.addMemoryReference(this.address, refAddr, type, sourceType, opIndex);
    }

    @Override
    public Reference[] getOperandReferences(int opIndex) {
        if (this.refMgr == null) {
            return emptyMemRefs;
        }
        return this.refMgr.getReferencesFrom(this.address, opIndex);
    }

    @Override
    public void removeOperandReference(int opIndex, Address refAddr) {
        if (this.refMgr == null) {
            throw new UnsupportedOperationException();
        }
        Reference ref = this.refMgr.getReference(this.address, refAddr, opIndex);
        if (ref != null) {
            this.refMgr.delete(ref);
        }
    }

    @Override
    public Reference[] getReferencesFrom() {
        if (this.refMgr != null) {
            return this.refMgr.getReferencesFrom(this.address);
        }
        ArrayList<Reference> list = new ArrayList<Reference>();
        for (int i = 0; i < this.getNumOperands(); ++i) {
            Reference[] refs = this.getOperandReferences(i);
            for (int j = 0; j < refs.length; ++j) {
                list.add(refs[j]);
            }
        }
        return list.toArray(emptyMemRefs);
    }

    public void setExternalReference(Reference ref) {
        throw new UnsupportedOperationException();
    }

    public void setMemoryReference(int opIndex, Address refAddr, RefType refType) {
        throw new UnsupportedOperationException();
    }

    private void validateOpIndex(int opIndex) {
        if (opIndex >= this.getNumOperands()) {
            throw new IllegalArgumentException("Invalid operand index [" + opIndex + "] specified");
        }
    }

    @Override
    public void setStackReference(int opIndex, int offset, SourceType sourceType, RefType refType) {
        if (this.refMgr == null) {
            throw new UnsupportedOperationException();
        }
        this.validateOpIndex(opIndex);
        this.refMgr.addStackReference(this.address, opIndex, offset, refType, sourceType);
    }

    @Override
    public void setRegisterReference(int opIndex, Register reg, SourceType sourceType, RefType refType) {
        if (this.refMgr == null) {
            throw new UnsupportedOperationException();
        }
        this.validateOpIndex(opIndex);
        this.refMgr.addRegisterReference(this.address, opIndex, reg, refType, sourceType);
    }

    @Override
    public Reference getPrimaryReference(int index) {
        if (this.refMgr == null) {
            return null;
        }
        return this.refMgr.getPrimaryReferenceFrom(this.address, index);
    }

    @Override
    public void setPrimaryMemoryReference(Reference ref) {
        if (this.refMgr == null) {
            throw new UnsupportedOperationException();
        }
        this.refMgr.setPrimary(ref, true);
    }

    public StackReference getStackReference(int opIndex) {
        return null;
    }

    public void removeStackReference(int opIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExternalReference getExternalReference(int opIndex) {
        Reference[] refs;
        if (this.refMgr == null) {
            return null;
        }
        for (Reference element : refs = this.refMgr.getReferencesFrom(this.address, opIndex)) {
            if (!element.isExternalReference()) continue;
            return (ExternalReference)element;
        }
        return null;
    }

    @Override
    public void removeExternalReference(int opIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceIterator getReferenceIteratorTo() {
        if (this.refMgr == null) {
            return null;
        }
        return this.refMgr.getReferencesTo(this.address);
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return this.address.hashCode();
    }
}

