/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.bookmark;

import db.Record;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.bookmark.BookmarkTypeDBAdapter;
import ghidra.program.database.bookmark.EmptyAddressIterator;
import ghidra.program.database.bookmark.OldBookmark;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.TypeMismatchException;
import ghidra.util.exception.DuplicateNameException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

class OldBookmarkManager {
    public static final String OLD_BOOKMARK_PROPERTY = "Bookmarks";
    private static final String BASE_PROPERTY_NAME = "Bookmarks";
    private static final EmptyAddressIterator emptyAddressIterator = new EmptyAddressIterator();
    private Program program;
    private PropertyMapManager propertyMgr;
    private HashMap<String, Record> bookmarkTypes = new HashMap();

    OldBookmarkManager(ProgramDB program) {
        this.program = program;
        this.propertyMgr = program.getUsrPropertyManager();
        String[] types = this.getTypes();
        for (int i = 0; i < types.length; ++i) {
            Record rec = BookmarkTypeDBAdapter.SCHEMA.createRecord((long)i);
            rec.setString(0, types[i]);
            this.bookmarkTypes.put(types[i], rec);
        }
    }

    private static String getBookmarkType(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        if (propertyName.startsWith("Bookmarks")) {
            int baseLen = "Bookmarks".length();
            if (propertyName.length() == baseLen) {
                return "Note";
            }
            return propertyName.substring(baseLen);
        }
        return null;
    }

    private static String getPropertyName(String bookmarkType) {
        if (bookmarkType == null) {
            return null;
        }
        if ("Note".equals(bookmarkType)) {
            return "Bookmarks";
        }
        return "Bookmarks" + bookmarkType;
    }

    private ObjectPropertyMap getMap(String type, boolean create) {
        String property = OldBookmarkManager.getPropertyName(type);
        ObjectPropertyMap map = null;
        map = this.propertyMgr.getObjectPropertyMap(property);
        if (map == null && create) {
            try {
                map = this.propertyMgr.createObjectPropertyMap(property, OldBookmark.class);
            }
            catch (DuplicateNameException e) {
                throw new RuntimeException("Unexpected Error");
            }
        }
        return map;
    }

    private String[] getTypes() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> iter = this.propertyMgr.propertyManagers();
        while (iter.hasNext()) {
            String property = iter.next();
            String type = OldBookmarkManager.getBookmarkType(property);
            if (type == null || list.contains(type)) continue;
            try {
                this.propertyMgr.getObjectPropertyMap(property);
                list.add(type);
            }
            catch (TypeMismatchException typeMismatchException) {}
        }
        String[] types = new String[list.size()];
        list.toArray(types);
        return types;
    }

    int getBookmarkCount(String type) {
        return this.propertyMgr.getObjectPropertyMap(OldBookmarkManager.getPropertyName(type)).getSize();
    }

    void removeAllBookmarks(String type) {
        this.propertyMgr.removePropertyMap(OldBookmarkManager.getPropertyName(type));
    }

    OldBookmark getBookmark(Address addr, String type) {
        OldBookmark bookmark = null;
        ObjectPropertyMap map = this.getMap(type, false);
        if (map != null && (bookmark = (OldBookmark)map.getObject(addr)) != null) {
            bookmark.setContext(this.program, type);
        }
        return bookmark;
    }

    AddressIterator getBookmarkAddresses(String type) {
        ObjectPropertyMap map = this.getMap(type, false);
        if (map != null) {
            return map.getPropertyIterator();
        }
        return emptyAddressIterator;
    }

    public Record[] getTypeRecords() {
        Collection<Record> c = this.bookmarkTypes.values();
        Record[] recs = new Record[c.size()];
        c.toArray(recs);
        return recs;
    }
}

