/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemoryBlock;

public class ByteSourceRange {
    protected final Address start;
    protected final long size;
    protected final long sourceId;
    protected final long byteSourceOffset;
    protected MemoryBlock block;

    public ByteSourceRange(MemoryBlock block, Address start, long size, long sourceId, long offset) {
        this.block = block;
        this.start = start;
        this.size = size;
        this.sourceId = sourceId;
        this.byteSourceOffset = offset;
    }

    public Address getStart() {
        return this.start;
    }

    public Address getEnd() {
        return this.start.add(this.size - 1L);
    }

    public long getSize() {
        return this.size;
    }

    public long getSourceId() {
        return this.sourceId;
    }

    public long getOffset() {
        return this.byteSourceOffset;
    }

    public ByteSourceRange intersect(ByteSourceRange range) {
        long minEndOffset;
        if (this.sourceId != range.sourceId) {
            return null;
        }
        long maxOffset = Math.max(this.byteSourceOffset, range.byteSourceOffset);
        if (maxOffset > (minEndOffset = Math.min(this.byteSourceOffset + this.size - 1L, range.byteSourceOffset + range.size - 1L))) {
            return null;
        }
        return new ByteSourceRange(this.block, this.start.add(maxOffset - this.byteSourceOffset), minEndOffset - maxOffset + 1L, this.sourceId, maxOffset);
    }

    public MemoryBlock getMemoryBlock() {
        return this.block;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.byteSourceOffset ^ this.byteSourceOffset >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (int)(this.sourceId ^ this.sourceId >>> 32);
        result = 31 * result + (this.start == null ? 0 : this.start.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ByteSourceRange other = (ByteSourceRange)obj;
        if (this.block == null ? other.block != null : !this.block.equals(other.block)) {
            return false;
        }
        if (this.byteSourceOffset != other.byteSourceOffset) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.sourceId != other.sourceId) {
            return false;
        }
        return !(this.start == null ? other.start != null : !this.start.equals(other.start));
    }
}

