/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.StringField;
import db.Table;
import ghidra.program.database.module.GroupDBAdapter;
import ghidra.program.database.module.TreeManager;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class GroupDBAdapterV0
implements GroupDBAdapter {
    private Table moduleTable;
    private Table fragmentTable;
    private Table parentChildTable;

    GroupDBAdapterV0(DBHandle handle, String moduleTableName, String fragTableName, String parentChildTableName) throws VersionException {
        this.moduleTable = handle.getTable(moduleTableName);
        this.fragmentTable = handle.getTable(fragTableName);
        this.parentChildTable = handle.getTable(parentChildTableName);
        this.testVersion(this.moduleTable, 0, moduleTableName);
        this.testVersion(this.fragmentTable, 0, fragTableName);
        this.testVersion(this.parentChildTable, 0, parentChildTableName);
    }

    @Override
    public Record createModule(long parentModuleID, String name) throws IOException, DuplicateNameException {
        if (this.getModuleRecord(name) != null || this.getFragmentRecord(name) != null) {
            throw new DuplicateNameException(name + " already exists");
        }
        Record record = TreeManager.MODULE_SCHEMA.createRecord(this.moduleTable.getKey());
        record.setString(0, name);
        this.moduleTable.putRecord(record);
        Record pcRec = TreeManager.PARENT_CHILD_SCHEMA.createRecord(this.parentChildTable.getKey());
        pcRec.setLongValue(0, parentModuleID);
        pcRec.setLongValue(1, record.getKey());
        this.parentChildTable.putRecord(pcRec);
        return record;
    }

    @Override
    public Record createFragment(long parentModuleID, String name) throws IOException, DuplicateNameException {
        if (this.getFragmentRecord(name) != null || this.getModuleRecord(name) != null) {
            throw new DuplicateNameException(name + " already exists");
        }
        long key = this.fragmentTable.getKey();
        if (key == 0L) {
            key = 1L;
        }
        Record record = TreeManager.FRAGMENT_SCHEMA.createRecord(key);
        record.setString(0, name);
        this.fragmentTable.putRecord(record);
        Record pcRec = TreeManager.PARENT_CHILD_SCHEMA.createRecord(this.parentChildTable.getKey());
        pcRec.setLongValue(0, parentModuleID);
        pcRec.setLongValue(1, -key);
        this.parentChildTable.putRecord(pcRec);
        return record;
    }

    @Override
    public Record getFragmentRecord(long key) throws IOException {
        return this.fragmentTable.getRecord(key);
    }

    @Override
    public Record getModuleRecord(long key) throws IOException {
        return this.moduleTable.getRecord(key);
    }

    @Override
    public Record getParentChildRecord(long parentID, long childID) throws IOException {
        long[] keys = this.parentChildTable.findRecords((Field)new LongField(parentID), 0);
        for (int i = 0; i < keys.length; ++i) {
            Record pcRec = this.parentChildTable.getRecord(keys[i]);
            if (pcRec.getLongValue(1) != childID) continue;
            return pcRec;
        }
        return null;
    }

    @Override
    public Record addParentChildRecord(long moduleID, long childID) throws IOException {
        Record pcRec = TreeManager.PARENT_CHILD_SCHEMA.createRecord(this.parentChildTable.getKey());
        pcRec.setLongValue(0, moduleID);
        pcRec.setLongValue(1, childID);
        this.parentChildTable.putRecord(pcRec);
        return pcRec;
    }

    @Override
    public boolean removeParentChildRecord(long key) throws IOException {
        return this.parentChildTable.deleteRecord(key);
    }

    @Override
    public long[] getParentChildKeys(long parentID, int indexedCol) throws IOException {
        return this.parentChildTable.findRecords((Field)new LongField(parentID), indexedCol);
    }

    @Override
    public Record getFragmentRecord(String name) throws IOException {
        long[] keys = this.fragmentTable.findRecords((Field)new StringField(name), 0);
        if (keys.length == 0) {
            return null;
        }
        if (keys.length > 1) {
            throw new AssertException("Found " + keys.length + " fragments named " + name);
        }
        return this.fragmentTable.getRecord(keys[0]);
    }

    @Override
    public Record getModuleRecord(String name) throws IOException {
        long[] keys = this.moduleTable.findRecords((Field)new StringField(name), 0);
        if (keys.length == 0) {
            return null;
        }
        if (keys.length > 1) {
            throw new AssertException("Found " + keys.length + " modules named " + name);
        }
        return this.moduleTable.getRecord(keys[0]);
    }

    @Override
    public Record getParentChildRecord(long key) throws IOException {
        return this.parentChildTable.getRecord(key);
    }

    @Override
    public void updateModuleRecord(Record record) throws IOException {
        this.moduleTable.putRecord(record);
    }

    @Override
    public void updateFragmentRecord(Record record) throws IOException {
        this.fragmentTable.putRecord(record);
    }

    @Override
    public void updateParentChildRecord(Record record) throws IOException {
        this.parentChildTable.putRecord(record);
    }

    @Override
    public Record createRootModule(String name) throws IOException {
        Record record = TreeManager.MODULE_SCHEMA.createRecord(0L);
        record.setString(0, name);
        this.moduleTable.putRecord(record);
        return record;
    }

    @Override
    public boolean removeFragmentRecord(long childID) throws IOException {
        return this.fragmentTable.deleteRecord(childID);
    }

    @Override
    public boolean removeModuleRecord(long childID) throws IOException {
        return this.moduleTable.deleteRecord(childID);
    }

    private void testVersion(Table table, int expectedVersion, String name) throws VersionException {
        if (table == null) {
            throw new VersionException(name + " not found");
        }
        int versionNumber = table.getSchema().getVersion();
        if (versionNumber != expectedVersion) {
            throw new VersionException(name + ": Expected Version " + expectedVersion + ", got " + versionNumber);
        }
    }
}

