/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.ByteField;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.Table;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.EntryPointReferenceDB;
import ghidra.program.database.references.ExternalReferenceDB;
import ghidra.program.database.references.MemReferenceDB;
import ghidra.program.database.references.OffsetReferenceDB;
import ghidra.program.database.references.RecordAdapter;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.RefListFlagsV0;
import ghidra.program.database.references.ReferenceDB;
import ghidra.program.database.references.ShiftedReferenceDB;
import ghidra.program.database.references.StackReferenceDB;
import ghidra.program.database.references.ToAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import java.io.IOException;
import java.util.Iterator;

class BigRefListV0
extends RefList {
    private static final String BASE_TABLE_NAME = "BigRefList_";
    private static final Schema BIG_REFS_SCHEMA = new Schema(1, "RefID", new Class[]{LongField.class, ByteField.class, ByteField.class, ByteField.class, LongField.class, LongField.class}, new String[]{"Address", "Flags", "Type", "OpIndex", "SymbolID", "Offset"});
    private static int ADDRESS_COL = 0;
    private static int FLAGS_COL = 1;
    private static int TYPE_COL = 2;
    private static int OPINDEX_COL = 3;
    private static int SYMBOL_ID_COL = 4;
    private static int OFFSET_COL = 5;
    private byte refLevel = (byte)-1;
    private Table table;
    private Record record;

    BigRefListV0(Address address, RecordAdapter adapter, AddressMap addrMap, ProgramDB program, DBObjectCache<RefList> cache, boolean isFrom) throws IOException {
        super(addrMap.getKey(address, true), address, adapter, addrMap, program, cache, isFrom);
        this.record = ToAdapter.TO_REFS_SCHEMA.createRecord(this.key);
        this.table = program.getDBHandle().createTable(BASE_TABLE_NAME + Long.toHexString(this.key), BIG_REFS_SCHEMA, new int[]{ADDRESS_COL});
    }

    BigRefListV0(Record rec, RecordAdapter adapter, AddressMap addrMap, ProgramDB program, DBObjectCache<RefList> cache, boolean isFrom) throws IOException {
        super(rec.getKey(), addrMap.decodeAddress(rec.getKey()), adapter, addrMap, program, cache, isFrom);
        if (rec.getBinaryData(1) != null) {
            throw new IllegalArgumentException("Invalid reference record");
        }
        String tableName = BASE_TABLE_NAME + Long.toHexString(rec.getKey());
        this.table = program.getDBHandle().getTable(tableName);
        if (this.table == null) {
            throw new IOException("BigRefList table not found for " + this.address + " (" + tableName + ")");
        }
        if (!isFrom) {
            this.refLevel = rec.getByteValue(2);
        }
        this.record = rec;
    }

    @Override
    public RefList checkRefListSize(DBObjectCache<RefList> cache, int newSpaceRequired) {
        return this;
    }

    @Override
    protected boolean refresh() {
        return false;
    }

    @Override
    void addRef(Address fromAddr, Address toAddr, RefType refType, int opIndex, long symbolID, boolean isPrimary, SourceType source, boolean isOffset, boolean isShift, long offsetOrShift) throws IOException {
        this.appendRef(fromAddr, toAddr, opIndex, refType, source, isPrimary, symbolID, isOffset, isShift, offsetOrShift);
        this.updateRecord();
    }

    synchronized void addRefs(ReferenceIterator refIter) throws IOException {
        while (refIter.hasNext()) {
            Reference ref = refIter.next();
            boolean isPrimary = ref.isPrimary();
            long symbolID = ref.getSymbolID();
            boolean isOffset = false;
            boolean isShifted = false;
            long offsetOrShift = 0L;
            if (ref instanceof MemReferenceDB) {
                MemReferenceDB memRef = (MemReferenceDB)ref;
                isOffset = memRef.isOffset();
                isShifted = memRef.isShifted();
                offsetOrShift = memRef.getOffsetOrShift();
            }
            this.appendRef(ref.getFromAddress(), ref.getToAddress(), ref.getOperandIndex(), ref.getReferenceType(), ref.getSource(), isPrimary, symbolID, isOffset, isShifted, offsetOrShift);
        }
        this.updateRecord();
    }

    synchronized void addRefs(Reference[] refs) throws IOException {
        for (Reference ref : refs) {
            boolean isPrimary = ref.isPrimary();
            long symbolID = ref.getSymbolID();
            boolean isOffset = false;
            boolean isShifted = false;
            long offsetOrShift = 0L;
            if (ref instanceof MemReferenceDB) {
                MemReferenceDB memRef = (MemReferenceDB)ref;
                isOffset = memRef.isOffset();
                isShifted = memRef.isShifted();
                offsetOrShift = memRef.getOffsetOrShift();
            }
            this.appendRef(ref.getFromAddress(), ref.getToAddress(), ref.getOperandIndex(), ref.getReferenceType(), ref.getSource(), isPrimary, symbolID, isOffset, isShifted, offsetOrShift);
        }
        this.updateRecord();
    }

    private void appendRef(Address fromAddr, Address toAddr, int opIndex, RefType refType, SourceType source, boolean isPrimary, long symbolID, boolean isOffset, boolean isShifted, long offsetOrShift) throws IOException {
        long id;
        byte level;
        if (!this.isFrom && (level = BigRefListV0.getRefLevel(refType)) > this.refLevel) {
            this.refLevel = level;
        }
        if ((id = this.table.getMaxKey() + 1L) < 0L) {
            id = 0L;
        }
        Record refRec = BIG_REFS_SCHEMA.createRecord(id);
        refRec.setLongValue(ADDRESS_COL, this.addrMap.getKey(this.isFrom ? toAddr : fromAddr, true));
        RefListFlagsV0 flags = new RefListFlagsV0(isPrimary, isOffset, symbolID >= 0L, isShifted, source);
        refRec.setByteValue(FLAGS_COL, flags.getValue());
        refRec.setByteValue(TYPE_COL, refType.getValue());
        refRec.setByteValue(OPINDEX_COL, (byte)opIndex);
        refRec.setLongValue(SYMBOL_ID_COL, symbolID);
        refRec.setLongValue(OFFSET_COL, offsetOrShift);
        this.table.putRecord(refRec);
    }

    private ReferenceDB getRef(Record rec) {
        Address to;
        long symbolID = -1L;
        long addr = rec.getLongValue(ADDRESS_COL);
        RefListFlagsV0 flags = new RefListFlagsV0(rec.getByteValue(FLAGS_COL));
        RefType refType = RefTypeFactory.get(rec.getByteValue(TYPE_COL));
        byte opIndex = rec.getByteValue(OPINDEX_COL);
        SourceType source = flags.getSource();
        long offsetOrShift = 0L;
        if (flags.hasSymbolID()) {
            symbolID = rec.getLongValue(SYMBOL_ID_COL);
        }
        Address from = this.isFrom ? this.address : this.addrMap.decodeAddress(addr);
        Address address = to = this.isFrom ? this.addrMap.decodeAddress(addr) : this.address;
        if (flags.isOffsetRef() || flags.isShiftRef()) {
            offsetOrShift = rec.getLongValue(OFFSET_COL);
            if (flags.isShiftRef()) {
                return new ShiftedReferenceDB(this.program, from, to, refType, opIndex, source, flags.isPrimary(), symbolID, (int)offsetOrShift);
            }
            return new OffsetReferenceDB(this.program, from, to, refType, opIndex, source, flags.isPrimary(), symbolID, offsetOrShift);
        }
        if (to.isExternalAddress()) {
            return new ExternalReferenceDB(this.program, from, to, refType, opIndex, source);
        }
        if (from.equals(Address.EXT_FROM_ADDRESS)) {
            return new EntryPointReferenceDB(from, to, refType, opIndex, source, flags.isPrimary(), symbolID);
        }
        if (to.isStackAddress()) {
            return new StackReferenceDB(this.program, from, to, refType, opIndex, source, flags.isPrimary(), symbolID);
        }
        return new MemReferenceDB(this.program, from, to, refType, opIndex, source, flags.isPrimary(), symbolID);
    }

    @Override
    synchronized Reference[] getAllRefs() throws IOException {
        Reference[] refs = new Reference[this.getNumRefs()];
        ReferenceIterator it = this.getRefs();
        for (int i = 0; i < refs.length; ++i) {
            refs[i] = it.next();
        }
        return refs;
    }

    @Override
    int getNumRefs() {
        return this.table.getRecordCount();
    }

    @Override
    boolean hasReference(int opIndex) throws IOException {
        if (!this.isFrom) {
            return false;
        }
        ReferenceIterator it = this.getRefs();
        while (it.hasNext()) {
            Reference ref = it.next();
            if (ref.getOperandIndex() != opIndex) continue;
            return true;
        }
        return false;
    }

    @Override
    synchronized Reference getPrimaryRef(int opIndex) throws IOException {
        if (!this.isFrom) {
            return null;
        }
        for (Record rec : this.table) {
            RefListFlagsV0 flags;
            if (rec.getByteValue(OPINDEX_COL) != opIndex || !(flags = new RefListFlagsV0(rec.getByteValue(FLAGS_COL))).isPrimary()) continue;
            return this.getRef(rec);
        }
        return null;
    }

    @Override
    synchronized ReferenceDB getRef(Address refAddress, int opIndex) throws IOException {
        LongField addrField = new LongField(this.addrMap.getKey(refAddress, false));
        for (long id : this.table.findRecords((Field)addrField, ADDRESS_COL)) {
            Record rec = this.table.getRecord(id);
            if (rec.getByteValue(OPINDEX_COL) != (byte)opIndex) continue;
            return this.getRef(rec);
        }
        return null;
    }

    @Override
    synchronized ReferenceIterator getRefs() throws IOException {
        return new RefIterator();
    }

    @Override
    boolean isEmpty() {
        return this.table == null || this.table.getRecordCount() == 0;
    }

    @Override
    byte getReferenceLevel() {
        return this.refLevel;
    }

    @Override
    synchronized void removeAll() throws IOException {
        this.table.deleteAll();
        this.program.getDBHandle().deleteTable(this.table.getName());
        this.table = null;
        this.adapter.removeRecord(this.key);
        this.refLevel = (byte)-1;
        this.setInvalid();
    }

    @Override
    synchronized boolean removeRef(Address deleteAddr, int opIndex) throws IOException {
        LongField addrField = new LongField(this.addrMap.getKey(deleteAddr, false));
        for (long id : this.table.findRecords((Field)addrField, ADDRESS_COL)) {
            Record rec = this.table.getRecord(id);
            if (rec.getByteValue(OPINDEX_COL) != (byte)opIndex) continue;
            this.table.deleteRecord(id);
            if (this.table.getRecordCount() == 0) {
                this.removeAll();
            } else {
                byte level;
                if (!this.isFrom && this.refLevel <= (level = BigRefListV0.getRefLevel(RefTypeFactory.get(rec.getByteValue(TYPE_COL))))) {
                    this.refLevel = this.findHighestRefLevel(this.refLevel);
                }
                this.updateRecord();
            }
            return true;
        }
        return false;
    }

    private byte findHighestRefLevel(byte currentRefLevel) throws IOException {
        byte maxLevel = -1;
        ReferenceIterator it = this.getRefs();
        while (it.hasNext()) {
            Reference ref = it.next();
            byte level = BigRefListV0.getRefLevel(ref.getReferenceType());
            if (maxLevel < level) {
                maxLevel = level;
            }
            if (level < currentRefLevel) continue;
            return level;
        }
        return maxLevel;
    }

    @Override
    synchronized boolean setPrimary(Reference ref, boolean isPrimary) throws IOException {
        int opIndex = ref.getOperandIndex();
        Address changeAddr = this.isFrom ? ref.getToAddress() : ref.getFromAddress();
        LongField addrField = new LongField(this.addrMap.getKey(changeAddr, false));
        for (long id : this.table.findRecords((Field)addrField, ADDRESS_COL)) {
            Record rec = this.table.getRecord(id);
            if (rec.getByteValue(OPINDEX_COL) != (byte)opIndex) continue;
            RefListFlagsV0 flags = new RefListFlagsV0(rec.getByteValue(FLAGS_COL));
            if (flags.isPrimary() == isPrimary) {
                return false;
            }
            flags.setPrimary(isPrimary);
            rec.setByteValue(FLAGS_COL, flags.getValue());
            this.table.putRecord(rec);
            return true;
        }
        return false;
    }

    @Override
    synchronized boolean setSymbolID(Reference ref, long symbolID) throws IOException {
        boolean hasSymbolID = symbolID >= 0L;
        int opIndex = ref.getOperandIndex();
        Address changeAddr = this.isFrom ? ref.getToAddress() : ref.getFromAddress();
        LongField addrField = new LongField(this.addrMap.getKey(changeAddr, false));
        for (long id : this.table.findRecords((Field)addrField, ADDRESS_COL)) {
            Record rec = this.table.getRecord(id);
            if (rec.getByteValue(OPINDEX_COL) != (byte)opIndex) continue;
            RefListFlagsV0 flags = new RefListFlagsV0(rec.getByteValue(FLAGS_COL));
            if (flags.hasSymbolID() == hasSymbolID && symbolID == rec.getLongValue(SYMBOL_ID_COL)) {
                return false;
            }
            flags.setHasSymbolID(hasSymbolID);
            rec.setLongValue(SYMBOL_ID_COL, symbolID);
            this.table.putRecord(rec);
            return true;
        }
        return false;
    }

    @Override
    synchronized void updateRefType(Address changeAddr, int opIndex, RefType refType) throws IOException {
        boolean updateRefLevel = false;
        byte newLevel = BigRefListV0.getRefLevel(refType);
        if (!this.isFrom) {
            updateRefLevel = newLevel != this.refLevel;
        }
        LongField addrField = new LongField(this.addrMap.getKey(changeAddr, false));
        for (long id : this.table.findRecords((Field)addrField, ADDRESS_COL)) {
            Record rec = this.table.getRecord(id);
            if (rec.getByteValue(OPINDEX_COL) != (byte)opIndex) continue;
            if (refType.getValue() == rec.getByteValue(TYPE_COL)) {
                return;
            }
            rec.setByteValue(TYPE_COL, refType.getValue());
            this.table.putRecord(rec);
            if (!updateRefLevel) break;
            this.refLevel = newLevel > this.refLevel ? newLevel : this.findHighestRefLevel((byte)-1);
            this.updateRecord();
            break;
        }
    }

    private void updateRecord() throws IOException {
        this.record.setIntValue(0, this.table.getRecordCount());
        this.record.setBinaryData(1, null);
        if (!this.isFrom) {
            this.record.setByteValue(2, this.refLevel);
        }
        this.adapter.putRecord(this.record);
    }

    static byte getRefLevel(RefType rt) {
        if (rt == RefType.EXTERNAL_REF) {
            return 5;
        }
        if (rt.isCall()) {
            return 3;
        }
        if (rt.isData() || rt.isIndirect()) {
            return 1;
        }
        if (rt.isFlow()) {
            return 2;
        }
        return 0;
    }

    class RefIterator
    implements ReferenceIterator {
        private RecordIterator recIter;

        RefIterator() throws IOException {
            this.recIter = BigRefListV0.this.table.iterator();
        }

        @Override
        public boolean hasNext() {
            try {
                return this.recIter.hasNext();
            }
            catch (IOException e) {
                BigRefListV0.this.program.dbError(e);
                return false;
            }
        }

        @Override
        public Reference next() {
            try {
                if (this.hasNext()) {
                    return BigRefListV0.this.getRef(this.recIter.next());
                }
            }
            catch (IOException e) {
                BigRefListV0.this.program.dbError(e);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Reference> iterator() {
            return this;
        }
    }
}

