/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import db.BinaryField;
import db.DBHandle;
import db.IntField;
import db.Schema;
import db.util.ErrorHandler;
import ghidra.program.database.DBObjectCache;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.references.FromAdapterSharedTable;
import ghidra.program.database.references.FromAdapterV0;
import ghidra.program.database.references.RecordAdapter;
import ghidra.program.database.references.RefList;
import ghidra.program.database.references.RefListV0;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.symbol.Reference;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

abstract class FromAdapter
implements RecordAdapter {
    static final String FROM_REFS_TABLE_NAME = "FROM REFS";
    static final Schema FROM_REFS_SCHEMA = new Schema(0, "From Address", new Class[]{IntField.class, BinaryField.class}, new String[]{"Number of Refs", "Ref Data"});
    static final int REF_COUNT_COL = 0;
    static final int REF_DATA_COL = 1;

    FromAdapter() {
    }

    static FromAdapter getAdapter(DBHandle dbHandle, int openMode, AddressMap addrMap, ErrorHandler errHandler, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        if (openMode == 0) {
            return new FromAdapterV0(dbHandle, true, addrMap, errHandler);
        }
        try {
            FromAdapterV0 adapter = new FromAdapterV0(dbHandle, false, addrMap, errHandler);
            if (addrMap.isUpgraded()) {
                throw new VersionException(true);
            }
            return adapter;
        }
        catch (VersionException e) {
            if (!e.isUpgradable() || openMode == 1) {
                throw e;
            }
            FromAdapter adapter = FromAdapter.findReadOnlyAdapter(dbHandle, addrMap, errHandler);
            if (openMode == 3) {
                adapter = FromAdapter.upgrade(dbHandle, addrMap, adapter, errHandler, monitor);
            }
            return adapter;
        }
    }

    private static FromAdapter findReadOnlyAdapter(DBHandle dbHandle, AddressMap addrMap, ErrorHandler errHandler) throws VersionException, IOException {
        try {
            return new FromAdapterV0(dbHandle, false, addrMap.getOldAddressMap(), errHandler);
        }
        catch (VersionException versionException) {
            return new FromAdapterSharedTable(dbHandle, addrMap, errHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FromAdapter upgrade(DBHandle dbHandle, AddressMap addrMap, FromAdapter oldAdapter, ErrorHandler errHandler, TaskMonitor monitor) throws VersionException, IOException, CancelledException {
        AddressMap oldAddrMap = addrMap.getOldAddressMap();
        try (DBHandle tmpHandle = new DBHandle();){
            tmpHandle.startTransaction();
            monitor.setMessage("Upgrading Memory References...");
            monitor.initialize((long)(oldAdapter.getRecordCount() * 2));
            int count = 0;
            FromAdapterV0 tmpAdapter = new FromAdapterV0(tmpHandle, true, addrMap, errHandler);
            AddressIterator addrIter = oldAdapter.getFromIterator(true);
            while (addrIter.hasNext()) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                Address from = addrIter.next();
                RefListV0 refList = (RefListV0)oldAdapter.getRefList(null, null, from, oldAddrMap.getKey(from, false));
                Reference[] refs = refList.getAllRefs();
                RefListV0 newRefList = new RefListV0(from, (RecordAdapter)tmpAdapter, addrMap, null, null, true);
                newRefList.addRefs(refs);
                monitor.setProgress((long)(++count));
            }
            dbHandle.deleteTable(FROM_REFS_TABLE_NAME);
            FromAdapterV0 newAdapter = new FromAdapterV0(dbHandle, true, addrMap, errHandler);
            addrIter = ((FromAdapter)tmpAdapter).getFromIterator(true);
            while (addrIter.hasNext()) {
                long fromAddr;
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                Address from = addrIter.next();
                RefListV0 refList = (RefListV0)((FromAdapter)tmpAdapter).getRefList(null, null, from, fromAddr = addrMap.getKey(from, true));
                newAdapter.createRecord(fromAddr, refList != null ? refList.getNumRefs() : 0, (byte)-1, refList != null ? refList.getData() : null);
                monitor.setProgress((long)(++count));
            }
            FromAdapterV0 fromAdapterV0 = newAdapter;
            return fromAdapterV0;
        }
    }

    abstract int getRecordCount();

    abstract RefList createRefList(ProgramDB var1, DBObjectCache<RefList> var2, Address var3) throws IOException;

    abstract RefList getRefList(ProgramDB var1, DBObjectCache<RefList> var2, Address var3, long var4) throws IOException;

    abstract boolean hasRefFrom(long var1) throws IOException;

    abstract AddressIterator getFromIterator(boolean var1) throws IOException;

    abstract AddressIterator getFromIterator(Address var1, boolean var2) throws IOException;

    abstract AddressIterator getFromIterator(AddressSetView var1, boolean var2) throws IOException;
}

