/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.DynamicSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class EquateSymbol
extends DynamicSymbol {
    public static final int FORMAT_DEFAULT = 0;
    public static final int FORMAT_HEX = 1;
    public static final int FORMAT_DEC = 2;
    public static final int FORMAT_OCT = 3;
    public static final int FORMAT_BIN = 4;
    public static final int FORMAT_CHAR = 5;
    private long value;
    private int convert;

    public EquateSymbol() {
    }

    public EquateSymbol(String nm, long val, HighFunction func, Address addr, long hash, int format) {
        super(nm, DataType.DEFAULT, 1, func, addr, hash, format);
        this.value = val;
        this.convert = 0;
    }

    public EquateSymbol(int conv, long val, HighFunction func, Address addr, long hash, int format) {
        super("", DataType.DEFAULT, 1, func, addr, hash, format);
        this.value = val;
        this.convert = conv;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public int restoreXML(XmlPullParser parser, HighFunction func) throws PcodeXMLException {
        XmlElement symel = parser.start(new String[]{"equatesymbol"});
        int symbolId = this.restoreSymbolXML(symel, func);
        this.type = DataType.DEFAULT;
        this.size = 1;
        this.convert = 0;
        String formString = symel.getAttribute("format");
        if (formString != null) {
            if (formString.equals("hex")) {
                this.convert = 1;
            } else if (formString.equals("dec")) {
                this.convert = 2;
            } else if (formString.equals("char")) {
                this.convert = 5;
            } else if (formString.equals("oct")) {
                this.convert = 3;
            } else if (formString.equals("bin")) {
                this.convert = 4;
            }
        }
        parser.start(new String[]{"value"});
        this.value = SpecXmlUtils.decodeLong((String)parser.end().getText());
        parser.end(symel);
        if (this.size == 0) {
            throw new PcodeXMLException("Invalid symbol 0-sized data-type: " + this.type.getName());
        }
        while (parser.peek().isStart()) {
            long hash = 0L;
            int format = 0;
            XmlElement addrel = parser.start(new String[]{"hash"});
            hash = SpecXmlUtils.decodeLong((String)addrel.getAttribute("val"));
            format = SpecXmlUtils.decodeInt((String)addrel.getAttribute("format"));
            parser.end(addrel);
            Address addr = this.parseRangeList(parser);
            this.addReference(addr, hash, format);
        }
        return symbolId;
    }

    @Override
    public String buildXML() {
        String sym = EquateSymbol.buildSymbolXML(this.function.getDataTypeManager(), this.name, this.value, this.isNameLocked(), false, this.convert);
        StringBuilder res = new StringBuilder();
        res.append("<mapsym type=\"equate\">\n");
        res.append(sym);
        this.buildHashXML(res);
        res.append("</mapsym>\n");
        return res.toString();
    }

    public static String buildSymbolXML(PcodeDataTypeManager dtmanage, String nm, long value, boolean nl, boolean isVolatile, int convert) {
        StringBuilder res = new StringBuilder();
        res.append("<equatesymbol");
        if (nm != null) {
            SpecXmlUtils.xmlEscapeAttribute((StringBuilder)res, (String)"name", (String)nm);
        }
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"typelock", (boolean)true);
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"namelock", (boolean)nl);
        SpecXmlUtils.encodeSignedIntegerAttribute((StringBuilder)res, (String)"cat", (long)1L);
        if (isVolatile) {
            SpecXmlUtils.encodeBooleanAttribute((StringBuilder)res, (String)"volatile", (boolean)true);
        }
        if (convert != 0) {
            String formString = "hex";
            if (convert != 1) {
                if (convert == 2) {
                    formString = "dec";
                } else if (convert == 3) {
                    formString = "oct";
                } else if (convert == 4) {
                    formString = "bin";
                } else if (convert == 5) {
                    formString = "char";
                }
            }
            SpecXmlUtils.encodeStringAttribute((StringBuilder)res, (String)"format", (String)formString);
        }
        res.append(">\n");
        res.append("  <value>0x");
        res.append(Long.toHexString(value));
        res.append("</value>\n");
        res.append("</equatesymbol>\n");
        return res.toString();
    }

    public static int convertName(String nm, long val) {
        char firstChar;
        int pos = 0;
        if ((firstChar = nm.charAt(pos++)) == '-') {
            if (nm.length() > pos) {
                firstChar = nm.charAt(pos++);
            } else {
                return 0;
            }
        }
        if (firstChar == '\'') {
            return 5;
        }
        if (firstChar == '\"') {
            return 2;
        }
        if (firstChar < '0' || firstChar > '9') {
            return -1;
        }
        char lastChar = nm.charAt(nm.length() - 1);
        if (lastChar == 'b') {
            return 4;
        }
        if (lastChar == 'o') {
            return 3;
        }
        int format = 2;
        if (firstChar == '0') {
            char c;
            format = 2;
            if (nm.length() >= pos + 1 && (c = nm.charAt(pos)) == 'x') {
                format = 1;
            }
        }
        return format;
    }
}

