/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.client;

import com.caucho.hessian4.io.AbstractHessianInput;
import com.caucho.hessian4.io.AbstractHessianOutput;
import com.caucho.hessian4.io.HessianRemoteObject;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.rpc.client.AsyncHessianProxy;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFuture;
import org.rzo.netty.ahessian.rpc.client.SyncHessianProxy;
import org.rzo.netty.ahessian.rpc.io.Hessian2Input;
import org.rzo.netty.ahessian.rpc.io.Hessian2Output;
import org.rzo.netty.ahessian.rpc.message.HessianRPCCallMessage;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;
import org.rzo.netty.ahessian.rpc.stream.ClientStreamManager;
import org.rzo.netty.ahessian.rpc.stream.InputStreamReplyMessage;
import org.rzo.netty.ahessian.session.ClientSessionFilter;
import org.rzo.netty.ahessian.utils.MyBlockingQueue;
import org.rzo.netty.ahessian.utils.MyLinkedBlockingQueue;
import org.rzo.netty.ahessian.utils.MyReentrantLock;
import org.rzo.netty.ahessian.utils.TimedBlockingPriorityQueue;

@ChannelHandler.Sharable
public class HessianProxyFactory
extends ChannelInboundHandlerAdapter
implements Constants {
    private static final int MAX_OPEN_CALLS = 50000;
    private volatile Map<Long, Future<Object>> _openCalls = Collections.synchronizedMap(new HashMap());
    private volatile int _id = 0;
    private volatile Channel _channel = null;
    private volatile com.caucho.hessian4.client.HessianProxyFactory _factory = null;
    private volatile MyBlockingQueue<HessianRPCCallMessage> _pendingCalls;
    Runnable _doneListener;
    Executor _executor;
    private Lock _lock = new MyReentrantLock();
    private Condition _connected = this._lock.newCondition();
    boolean _stop = false;
    private String _name;
    private boolean _sessionListenerAdded = false;
    private volatile Runnable _closedSessionListener;
    private volatile Runnable _newSessionListener;
    private volatile Runnable _disconnectedListener;
    private volatile Runnable _connectedListener;
    Map<Object, InvocationHandler> _proxies = Collections.synchronizedMap(new HashMap());
    Timer _timer = new HashedWheelTimer();
    private volatile boolean _blocked = false;
    ClientStreamManager _clientStreamManager;

    public HessianProxyFactory(Executor executor, String name) {
        this(executor, name, null, new HashMap());
    }

    public HessianProxyFactory(Executor executor, String name, Map options) {
        this(executor, name, null, options);
    }

    public HessianProxyFactory(Executor executor, String name, ClassLoader loader, Map options) {
        this._executor = executor;
        this._name = name;
        this._pendingCalls = options != null ? new TimedBlockingPriorityQueue<HessianRPCCallMessage>(options, null, "HessianProxyFactory-PendingCalls") : new MyLinkedBlockingQueue<HessianRPCCallMessage>();
        this._factory = loader == null ? new com.caucho.hessian4.client.HessianProxyFactory() : new com.caucho.hessian4.client.HessianProxyFactory(loader);
    }

    public AbstractHessianInput getHessian2Input(InputStream is) {
        return new Hessian2Input(is);
    }

    public AbstractHessianOutput getHessian2Output(OutputStream out) {
        Hessian2Output out2 = new Hessian2Output(out);
        out2.setSerializerFactory(this._factory.getSerializerFactory());
        return out2;
    }

    public boolean isOverloadEnabled() {
        return this._factory.isOverloadEnabled();
    }

    synchronized Future<Object> sendRequest(String methodName, Object[] args, Map options) throws InterruptedException {
        long t = System.currentTimeMillis();
        if (this._blocked) {
            throw new RuntimeException("send blocked");
        }
        if (this._stop) {
            return null;
        }
        Map headers = options;
        final Long id = new Long(this._id);
        ++this._id;
        headers.put(CALL_ID_HEADER_KEY, id);
        final HessianProxyFuture future = new HessianProxyFuture();
        future.handleCallbacks(args);
        HessianRPCCallMessage message = new HessianRPCCallMessage(methodName, args, headers, null);
        boolean i = false;
        while (this._openCalls.size() > 50000 && this.getChannel() != null) {
            Thread.sleep(10L);
        }
        this._openCalls.put(id, future);
        Integer g = (Integer)options.get("group");
        Integer group = g == null ? 0 : g;
        long timeout = this._pendingCalls.getTimeout(group);
        if (timeout > 0L) {
            TimerTask task = new TimerTask(){

                public void run(Timeout arg0) throws Exception {
                    HessianProxyFactory.this._openCalls.remove(id);
                    future.timedOut();
                }
            };
            future.setTimeout(this._timer.newTimeout(task, timeout, TimeUnit.MILLISECONDS));
        }
        Channel channel = null;
        channel = this.getChannel();
        if (channel == null) {
            throw new RuntimeException("channel closed");
        }
        while (!channel.isWritable() && channel.isActive()) {
            Thread.sleep(100L);
        }
        channel.write((Object)message);
        return future;
    }

    public void channelRead(final ChannelHandlerContext ctx, Object e) throws Exception {
        if (e instanceof HessianRPCReplyMessage) {
            final HessianRPCReplyMessage message = (HessianRPCReplyMessage)e;
            final Long id = message.getCallId();
            if (id != null) {
                final HessianProxyFuture future = (HessianProxyFuture)this._openCalls.get(id);
                if (future == null) {
                    ahessianLogger.warn("no future found for call-id " + id);
                    return;
                }
                if ((message.getCompleted() == null || Boolean.TRUE.equals(message.getCompleted())) && !future.hasCallbacks()) {
                    this._openCalls.remove(id);
                }
                if (this._doneListener != null && this._openCalls.isEmpty()) {
                    this._doneListener.run();
                }
                if (future != null) {
                    this._executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (message.getValue() instanceof InputStreamReplyMessage) {
                                    InputStream stream = HessianProxyFactory.this._clientStreamManager.newInputStream(((InputStreamReplyMessage)message.getValue()).getId());
                                    message.setValue(stream);
                                }
                                future.set(message, ctx);
                                if (future.isDone() && !future.hasCallbacks()) {
                                    HessianProxyFactory.this._openCalls.remove(id);
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                } else {
                    ahessianLogger.warn("no future for call reply " + id + " " + message.getValue());
                }
            } else {
                ahessianLogger.warn("message missing id " + message);
            }
        } else if (e instanceof InputStreamReplyMessage) {
            this._clientStreamManager.messageReceived((InputStreamReplyMessage)e);
        }
        ctx.fireChannelReadComplete();
    }

    public Object create(Class api, ClassLoader loader, Map options) {
        if (api == null) {
            throw new NullPointerException("api must not be null for HessianProxyFactory.create()");
        }
        InvocationHandler handler = null;
        if (options == null) {
            options = new HashMap();
        }
        handler = new AsyncHessianProxy(this, api, options);
        if (options.get("sync") != null) {
            handler = new SyncHessianProxy(handler);
        }
        Object result = Proxy.newProxyInstance(loader, new Class[]{api, HessianRemoteObject.class}, handler);
        this._proxies.put(result, handler);
        return result;
    }

    public void returnProxy(Object proxy) {
        InvocationHandler handler = this._proxies.remove(proxy);
        if (handler != null && handler instanceof SyncHessianProxy) {
            handler = ((SyncHessianProxy)handler)._handler;
        }
        ((AsyncHessianProxy)handler).invalidate();
    }

    public Channel getChannel() {
        if (this._channel == null || !this._channel.isActive() || !this._channel.isWritable()) {
            return null;
        }
        return this._channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this._channel = ctx.channel();
        if (this._connectedListener != null) {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        HessianProxyFactory.this._connectedListener.run();
                    }
                    catch (Throwable ex) {
                        Constants.ahessianLogger.warn("", ex);
                    }
                }
            });
        }
        this._lock.lock();
        try {
            if (!this._sessionListenerAdded && ctx.pipeline().get(ClientSessionFilter.class) != null) {
                ClientSessionFilter sessionHandler = (ClientSessionFilter)ctx.pipeline().get(ClientSessionFilter.class);
                sessionHandler.addSessionClosedListener(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        HessianProxyFactory.this._lock.lock();
                        try {
                            HessianProxyFactory.this.invalidateProxies();
                            HessianProxyFactory.this._openCalls.clear();
                            HessianProxyFactory.this._pendingCalls.clear();
                        }
                        finally {
                            HessianProxyFactory.this._lock.unlock();
                        }
                        if (HessianProxyFactory.this._closedSessionListener != null) {
                            try {
                                HessianProxyFactory.this._closedSessionListener.run();
                            }
                            catch (Throwable ex) {
                                Constants.ahessianLogger.warn("", ex);
                            }
                        }
                    }
                });
                sessionHandler.addSessionNewListener(new Runnable(){

                    @Override
                    public void run() {
                        if (HessianProxyFactory.this._newSessionListener != null) {
                            try {
                                HessianProxyFactory.this._newSessionListener.run();
                            }
                            catch (Throwable ex) {
                                Constants.ahessianLogger.warn("", ex);
                            }
                        }
                    }
                });
                this._sessionListenerAdded = true;
            }
        }
        finally {
            this._connected.signal();
            this._lock.unlock();
            super.channelActive(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this._channel = null;
        this._lock.lock();
        try {
            this._connected.signal();
        }
        finally {
            this._lock.unlock();
        }
        this._pendingCalls.offer(new HessianRPCCallMessage(null, null, null, null));
        if (this._disconnectedListener != null) {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        HessianProxyFactory.this._disconnectedListener.run();
                    }
                    catch (Throwable ex) {
                        Constants.ahessianLogger.warn("", ex);
                    }
                }
            });
        }
        super.channelInactive(ctx);
    }

    public void setDoneListener(Runnable listener) {
        this._doneListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        ahessianLogger.warn("error accessing service " + this._name + " Exception " + e.getClass() + " " + e.getCause().getMessage());
        ctx.channel().disconnect();
        ctx.channel().close();
        if (!this._stop) {
            this._channel = null;
            this._lock.lock();
            try {
                this._connected.signal();
            }
            finally {
                this._lock.unlock();
            }
            this._pendingCalls.offer(new HessianRPCCallMessage(null, null, null, null));
        }
    }

    public void invalidateProxies() {
        for (Object proxy : new HashSet<Object>(this._proxies.keySet())) {
            this.returnProxy(proxy);
        }
    }

    public void setClosedSessionListener(Runnable listener) {
        this._closedSessionListener = listener;
    }

    public void setDisconnectedListener(Runnable listener) {
        this._disconnectedListener = listener;
    }

    public void setConnectedListener(Runnable listener) {
        this._connectedListener = listener;
    }

    public void setNewSessionListener(Runnable listener) {
        this._newSessionListener = listener;
    }

    public void invalidateAllPendingCalls() {
        HessianRPCReplyMessage message = new HessianRPCReplyMessage(null, new RuntimeException("connection closed"), null);
        for (Future<Object> future : new ArrayList<Future<Object>>(this._openCalls.values())) {
            ((HessianProxyFuture)future).set(message);
        }
        this._openCalls.clear();
        this._pendingCalls.clear();
    }

    public void setBlocked(boolean blocked) {
        this._blocked = blocked;
    }
}

