/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.configuration.ProjectsPreparer;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.buildsrc.BuildSourceBuilder;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.classpath.ClassPath;

public class BuildTreePreparingProjectsPreparer
implements ProjectsPreparer {
    private final ProjectsPreparer delegate;
    private final BuildStateRegistry buildStateRegistry;
    private final BuildSourceBuilder buildSourceBuilder;
    private final BuildLoader buildLoader;

    public BuildTreePreparingProjectsPreparer(ProjectsPreparer delegate, BuildLoader buildLoader, BuildStateRegistry buildStateRegistry, BuildSourceBuilder buildSourceBuilder) {
        this.delegate = delegate;
        this.buildLoader = buildLoader;
        this.buildStateRegistry = buildStateRegistry;
        this.buildSourceBuilder = buildSourceBuilder;
    }

    @Override
    public void prepareProjects(GradleInternal gradle) {
        SettingsInternal settings = gradle.getSettings();
        ClassLoaderScope parentClassLoaderScope = settings.getClassLoaderScope();
        ClassLoaderScope baseProjectClassLoaderScope = parentClassLoaderScope.createChild(settings.getBuildSrcDir().getAbsolutePath());
        gradle.setBaseProjectClassLoaderScope(baseProjectClassLoaderScope);
        this.buildLoader.load(gradle.getSettings(), gradle);
        if (gradle.isRootBuild()) {
            this.buildStateRegistry.beforeConfigureRootBuild();
        }
        this.buildBuildSrcAndLockClassloader(gradle, baseProjectClassLoaderScope);
        this.delegate.prepareProjects(gradle);
    }

    private void buildBuildSrcAndLockClassloader(GradleInternal gradle, ClassLoaderScope baseProjectClassLoaderScope) {
        ClassPath buildSrcClassPath = this.buildSourceBuilder.buildAndGetClassPath(gradle);
        baseProjectClassLoaderScope.export(buildSrcClassPath).lock();
    }
}

