/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.sharing;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class SharedObjectManager<T> {
    private final AtomicBoolean invalidated = new AtomicBoolean(false);
    private final Queue<T> objects = new ConcurrentLinkedQueue<T>();

    protected abstract void cleanup(T var1);

    private void cleanupAll() {
        T current;
        while ((current = this.objects.poll()) != null) {
            this.cleanup(current);
        }
    }

    public void register(T object) {
        if (this.invalidated.get()) {
            this.cleanup(object);
            return;
        }
        this.objects.add(object);
        if (this.invalidated.get()) {
            this.cleanupAll();
        }
    }

    public void invalidate() {
        if (!this.invalidated.compareAndSet(false, true)) {
            return;
        }
        this.cleanupAll();
    }
}

