/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.base.ChildObjectModel;
import org.apache.guacamole.auth.jdbc.base.ModeledChildDirectoryObject;
import org.apache.guacamole.auth.jdbc.base.ModeledDirectoryObjectService;
import org.apache.guacamole.auth.jdbc.base.ObjectModel;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;

public abstract class ModeledChildDirectoryObjectService<InternalType extends ModeledChildDirectoryObject<ModelType>, ExternalType extends Identifiable, ModelType extends ChildObjectModel>
extends ModeledDirectoryObjectService<InternalType, ExternalType, ModelType> {
    protected abstract ObjectPermissionSet getParentEffectivePermissionSet(ModeledAuthenticatedUser var1) throws GuacamoleException;

    protected Collection<String> getModifiedParents(ModeledAuthenticatedUser user, String identifier, ModelType model) throws GuacamoleException {
        String oldParentIdentifier = null;
        if (identifier != null) {
            ChildObjectModel current = (ChildObjectModel)((ModeledChildDirectoryObject)this.retrieveObject(user, identifier)).getModel();
            oldParentIdentifier = current.getParentIdentifier();
        }
        String parentIdentifier = null;
        if (model != null && (parentIdentifier = ((ChildObjectModel)model).getParentIdentifier()) != null && parentIdentifier.equals(oldParentIdentifier)) {
            return Collections.emptyList();
        }
        ArrayList<String> parents = new ArrayList<String>(2);
        if (oldParentIdentifier != null) {
            parents.add(oldParentIdentifier);
        }
        if (parentIdentifier != null) {
            parents.add(parentIdentifier);
        }
        return parents;
    }

    protected boolean canUpdateModifiedParents(ModeledAuthenticatedUser user, String identifier, ModelType model) throws GuacamoleException {
        if (user.isPrivileged()) {
            return true;
        }
        Collection<String> modifiedParents = this.getModifiedParents(user, identifier, model);
        if (!modifiedParents.isEmpty()) {
            ObjectPermissionSet permissionSet = this.getParentEffectivePermissionSet(user);
            Collection updateableParents = permissionSet.getAccessibleObjects(Collections.singleton(ObjectPermission.Type.UPDATE), modifiedParents);
            return updateableParents.size() == modifiedParents.size();
        }
        return true;
    }

    @Override
    protected void beforeCreate(ModeledAuthenticatedUser user, ExternalType object, ModelType model) throws GuacamoleException {
        super.beforeCreate(user, object, model);
        if (!this.canUpdateModifiedParents(user, null, model)) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
    }

    @Override
    protected void beforeUpdate(ModeledAuthenticatedUser user, InternalType object, ModelType model) throws GuacamoleException {
        super.beforeUpdate(user, object, model);
        if (!this.canUpdateModifiedParents(user, ((ObjectModel)model).getIdentifier(), model)) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
    }

    @Override
    protected void beforeDelete(ModeledAuthenticatedUser user, String identifier) throws GuacamoleException {
        super.beforeDelete(user, identifier);
        if (!this.canUpdateModifiedParents(user, identifier, null)) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
    }
}

