/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.connectiongroup;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.connectiongroup.ConnectionGroupService;
import org.apache.guacamole.auth.jdbc.connectiongroup.ModeledConnectionGroup;
import org.apache.guacamole.net.auth.ConnectionGroup;
import org.apache.guacamole.net.auth.Directory;
import org.mybatis.guice.transactional.Transactional;

public class ConnectionGroupDirectory
extends RestrictedObject
implements Directory<ConnectionGroup> {
    @Inject
    private ConnectionGroupService connectionGroupService;

    public ConnectionGroup get(String identifier) throws GuacamoleException {
        return (ConnectionGroup)this.connectionGroupService.retrieveObject(this.getCurrentUser(), identifier);
    }

    @Transactional
    public Collection<ConnectionGroup> getAll(Collection<String> identifiers) throws GuacamoleException {
        Collection objects = this.connectionGroupService.retrieveObjects(this.getCurrentUser(), identifiers);
        return Collections.unmodifiableCollection(objects);
    }

    @Transactional
    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.connectionGroupService.getIdentifiers(this.getCurrentUser());
    }

    @Transactional
    public void add(ConnectionGroup object) throws GuacamoleException {
        this.connectionGroupService.createObject(this.getCurrentUser(), object);
    }

    @Transactional
    public void update(ConnectionGroup object) throws GuacamoleException {
        ModeledConnectionGroup connectionGroup = (ModeledConnectionGroup)object;
        this.connectionGroupService.updateObject(this.getCurrentUser(), connectionGroup);
    }

    @Transactional
    public void remove(String identifier) throws GuacamoleException {
        this.connectionGroupService.deleteObject(this.getCurrentUser(), identifier);
    }
}

