/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.connection;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.guacamole.auth.jdbc.connection.ConnectionModel;
import org.apache.guacamole.auth.jdbc.connection.ConnectionService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.protocol.GuacamoleConfiguration;

public class ModeledGuacamoleConfiguration
extends GuacamoleConfiguration {
    private ModeledAuthenticatedUser currentUser;
    private ConnectionModel connectionModel;
    @Inject
    private ConnectionService connectionService;
    private Map<String, String> parameters = null;

    public void init(ModeledAuthenticatedUser currentUser, ConnectionModel connectionModel) {
        this.currentUser = currentUser;
        this.connectionModel = connectionModel;
    }

    public String getProtocol() {
        return this.connectionModel.getProtocol();
    }

    public void setProtocol(String protocol) {
        super.setProtocol(protocol);
        this.connectionModel.setProtocol(protocol);
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
        super.setParameters(parameters);
    }

    public Map<String, String> getParameters() {
        if (this.parameters == null) {
            Map<String, String> visibleParameters = this.connectionService.retrieveParameters(this.currentUser, this.connectionModel.getIdentifier());
            super.setParameters(visibleParameters);
        }
        return super.getParameters();
    }
}

