/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.permission.ModeledPermissionService;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionMapper;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionModel;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;

public abstract class ModeledObjectPermissionService
extends ModeledPermissionService<ObjectPermissionSet, ObjectPermission, ObjectPermissionModel>
implements ObjectPermissionService {
    protected abstract ObjectPermissionMapper getPermissionMapper();

    @Override
    protected ObjectPermission getPermissionInstance(ObjectPermissionModel model) {
        return new ObjectPermission((ObjectPermission.Type)model.getType(), model.getObjectIdentifier());
    }

    @Override
    protected ObjectPermissionModel getModelInstance(ModeledPermissions<? extends EntityModel> targetEntity, ObjectPermission permission) {
        ObjectPermissionModel model = new ObjectPermissionModel();
        model.setEntityID(((EntityModel)targetEntity.getModel()).getEntityID());
        model.setType(permission.getType());
        model.setObjectIdentifier(permission.getObjectIdentifier());
        return model;
    }

    protected boolean canAlterPermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<ObjectPermission> permissions) throws GuacamoleException {
        if (user.isPrivileged()) {
            return true;
        }
        ObjectPermissionSet permissionSet = this.getRelevantPermissionSet(user.getUser(), targetEntity);
        if (!permissionSet.hasPermission(ObjectPermission.Type.UPDATE, targetEntity.getIdentifier())) {
            return false;
        }
        HashSet<String> affectedIdentifiers = new HashSet<String>(permissions.size());
        for (ObjectPermission permission : permissions) {
            affectedIdentifiers.add(permission.getObjectIdentifier());
        }
        ObjectPermissionSet affectedPermissionSet = (ObjectPermissionSet)this.getPermissionSet(user, user.getUser(), user.getEffectiveUserGroups());
        Collection allowedSubset = affectedPermissionSet.getAccessibleObjects(Collections.singleton(ObjectPermission.Type.ADMINISTER), affectedIdentifiers);
        return affectedIdentifiers.size() == allowedSubset.size();
    }

    @Override
    public void createPermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<ObjectPermission> permissions) throws GuacamoleException {
        if (this.canAlterPermissions(user, targetEntity, permissions)) {
            Collection models = this.getModelInstances(targetEntity, permissions);
            this.getPermissionMapper().insert(models);
            return;
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public void deletePermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<ObjectPermission> permissions) throws GuacamoleException {
        if (this.canAlterPermissions(user, targetEntity, permissions)) {
            Collection models = this.getModelInstances(targetEntity, permissions);
            this.getPermissionMapper().delete(models);
            return;
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public boolean hasPermission(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, ObjectPermission.Type type, String identifier, Set<String> effectiveGroups) throws GuacamoleException {
        if (this.canReadPermissions(user, targetEntity)) {
            return this.getPermissionMapper().selectOne((EntityModel)targetEntity.getModel(), type, identifier, effectiveGroups) != null;
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }

    @Override
    public Collection<String> retrieveAccessibleIdentifiers(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity, Collection<ObjectPermission.Type> permissions, Collection<String> identifiers, Set<String> effectiveGroups) throws GuacamoleException {
        if (identifiers.isEmpty()) {
            return identifiers;
        }
        if (user.isPrivileged()) {
            return identifiers;
        }
        if (this.canReadPermissions(user, targetEntity)) {
            return this.getPermissionMapper().selectAccessibleIdentifiers((EntityModel)targetEntity.getModel(), permissions, identifiers, effectiveGroups);
        }
        throw new GuacamoleSecurityException("Permission denied.");
    }
}

