/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.deobf;

import jadx.core.deobf.Deobfuscator;
import jadx.core.deobf.PackageNode;
import jadx.core.dex.nodes.ClassNode;

class DeobfClsInfo {
    private final Deobfuscator deobfuscator;
    private final ClassNode cls;
    private final PackageNode pkg;
    private final String alias;

    public DeobfClsInfo(Deobfuscator deobfuscator, ClassNode cls, PackageNode pkg, String alias) {
        this.deobfuscator = deobfuscator;
        this.cls = cls;
        this.pkg = pkg;
        this.alias = alias;
    }

    public String makeNameWithoutPkg() {
        String prefix;
        ClassNode parentClass = this.cls.getParentClass();
        if (parentClass != this.cls) {
            DeobfClsInfo parentDeobfClsInfo = this.deobfuscator.getClsMap().get(parentClass.getClassInfo());
            prefix = parentDeobfClsInfo != null ? parentDeobfClsInfo.makeNameWithoutPkg() : this.deobfuscator.getNameWithoutPackage(parentClass.getClassInfo());
            prefix = prefix + "$";
        } else {
            prefix = "";
        }
        return prefix + (this.alias != null ? this.alias : this.cls.getShortName());
    }

    public String getFullName() {
        return this.pkg.getFullAlias() + "." + this.makeNameWithoutPkg();
    }

    public ClassNode getCls() {
        return this.cls;
    }

    public PackageNode getPkg() {
        return this.pkg;
    }

    public String getAlias() {
        return this.alias;
    }
}

