/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.management.ManagementFactory;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHolder;
import org.glassfish.jersey.servlet.ServletContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.XmppProvider;
import org.jitsi.impl.protocol.xmpp.XmppProviderImpl;
import org.jitsi.jicofo.ConferenceStore;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.auth.AbstractAuthAuthority;
import org.jitsi.jicofo.auth.AuthConfig;
import org.jitsi.jicofo.auth.ExternalJWTAuthority;
import org.jitsi.jicofo.auth.ShibbolethAuthAuthority;
import org.jitsi.jicofo.auth.XMPPDomainAuthAuthority;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.BridgeMucDetector;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.bridge.JvbDoctor;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.health.HealthConfig;
import org.jitsi.jicofo.health.JicofoHealthChecker;
import org.jitsi.jicofo.jibri.JibriConfig;
import org.jitsi.jicofo.jibri.JibriDetector;
import org.jitsi.jicofo.jigasi.JigasiDetector;
import org.jitsi.jicofo.rest.Application;
import org.jitsi.jicofo.version.CurrentVersionImpl;
import org.jitsi.jicofo.xmpp.BaseBrewery;
import org.jitsi.jicofo.xmpp.SmackKt;
import org.jitsi.jicofo.xmpp.XmppConnectionConfig;
import org.jitsi.jicofo.xmpp.XmppProviderFactory;
import org.jitsi.jicofo.xmpp.XmppServices;
import org.jitsi.protocol.xmpp.AbstractOperationSetJingle;
import org.jitsi.rest.JettyBundleActivatorConfig;
import org.jitsi.rest.JettyHelpers;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.json.simple.JSONObject;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010%\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010&\u001a\u00020 H\u0016J\u000e\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020/J\u0006\u00100\u001a\u000201R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0018R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00063"}, d2={"Lorg/jitsi/jicofo/JicofoServices;", "", "()V", "authenticationAuthority", "Lorg/jitsi/jicofo/auth/AbstractAuthAuthority;", "getAuthenticationAuthority", "()Lorg/jitsi/jicofo/auth/AbstractAuthAuthority;", "bridgeDetector", "Lorg/jitsi/jicofo/bridge/BridgeMucDetector;", "bridgeSelector", "Lorg/jitsi/jicofo/bridge/BridgeSelector;", "getBridgeSelector", "()Lorg/jitsi/jicofo/bridge/BridgeSelector;", "focusManager", "Lorg/jitsi/jicofo/FocusManager;", "getFocusManager", "()Lorg/jitsi/jicofo/FocusManager;", "healthChecker", "Lorg/jitsi/jicofo/health/JicofoHealthChecker;", "jettyServer", "Lorg/eclipse/jetty/server/Server;", "jibriDetector", "Lorg/jitsi/jicofo/jibri/JibriDetector;", "getJibriDetector", "()Lorg/jitsi/jicofo/jibri/JibriDetector;", "jvbDoctor", "Lorg/jitsi/jicofo/bridge/JvbDoctor;", "logger", "Lorg/jitsi/utils/logging2/Logger;", "sipJibriDetector", "getSipJibriDetector", "xmppProviderFactory", "Lorg/jitsi/jicofo/xmpp/XmppProviderFactory;", "xmppServices", "Lorg/jitsi/jicofo/xmpp/XmppServices;", "getXmppServices", "()Lorg/jitsi/jicofo/xmpp/XmppServices;", "createAuthenticationAuthority", "createXmppProviderFactory", "getConferenceDebugState", "Lorg/jitsi/utils/OrderedJsonObject;", "conferenceId", "", "getDebugState", "full", "", "getStats", "Lorg/json/simple/JSONObject;", "shutdown", "", "Companion", "jicofo"})
@SuppressFBWarnings(value={"MS_CANNOT_BE_FINAL"})
public class JicofoServices {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
    @NotNull
    private final XmppProviderFactory xmppProviderFactory = this.createXmppProviderFactory();
    @NotNull
    private final FocusManager focusManager;
    @Nullable
    private final AbstractAuthAuthority authenticationAuthority;
    @NotNull
    private final XmppServices xmppServices;
    @NotNull
    private final BridgeSelector bridgeSelector;
    @Nullable
    private final JvbDoctor jvbDoctor;
    @Nullable
    private final BridgeMucDetector bridgeDetector;
    @Nullable
    private final JibriDetector jibriDetector;
    @Nullable
    private final JibriDetector sipJibriDetector;
    @Nullable
    private final JicofoHealthChecker healthChecker;
    @Nullable
    private final Server jettyServer;
    @JvmField
    @Nullable
    public static JicofoServices jicofoServicesSingleton;

    /*
     * WARNING - void declaration
     */
    public JicofoServices() {
        Object object;
        Object object2;
        Object $this$sipJibriDetector_u24lambda_u2d11;
        JicofoServices jicofoServices;
        BaseBrewery baseBrewery;
        EntityBareJid $this$jibriDetector_u24lambda_u2d8;
        JicofoServices jicofoServices2;
        BaseBrewery baseBrewery2;
        EntityBareJid $this$bridgeDetector_u24lambda_u2d5;
        JicofoServices jicofoServices3;
        BridgeMucDetector bridgeMucDetector;
        BaseBrewery baseBrewery3;
        JicofoServices breweryJid2;
        Object object3;
        Object $this$jvbDoctor_u24lambda_u2d2;
        Object object4;
        Object $this$focusManager_u24lambda_u2d0;
        Object object5 = new FocusManager();
        FocusManager focusManager = object5;
        JicofoServices jicofoServices4 = this;
        boolean bl2 = false;
        ((FocusManager)$this$focusManager_u24lambda_u2d0).start();
        jicofoServices4.focusManager = object5;
        JicofoServices jicofoServices5 = this;
        AbstractAuthAuthority abstractAuthAuthority = this.createAuthenticationAuthority();
        if (abstractAuthAuthority != null) {
            void $this$authenticationAuthority_u24lambda_u2d1;
            $this$focusManager_u24lambda_u2d0 = abstractAuthAuthority;
            AbstractAuthAuthority bl2 = $this$focusManager_u24lambda_u2d0;
            jicofoServices4 = jicofoServices5;
            boolean bl3 = false;
            $this$authenticationAuthority_u24lambda_u2d1.start();
            this.focusManager.addListener((ConferenceStore.Listener)$this$authenticationAuthority_u24lambda_u2d1);
            jicofoServices5 = jicofoServices4;
            object4 = $this$focusManager_u24lambda_u2d0;
        } else {
            object4 = null;
        }
        jicofoServices5.authenticationAuthority = object4;
        object5 = this.xmppProviderFactory;
        $this$focusManager_u24lambda_u2d0 = this.focusManager;
        FocusManager $this$authenticationAuthority_u24lambda_u2d1 = this.focusManager;
        Object bl3 = this.authenticationAuthority;
        this.xmppServices = new XmppServices((XmppProviderFactory)object5, (ConferenceStore)$this$focusManager_u24lambda_u2d0, (AbstractAuthAuthority)bl3, $this$authenticationAuthority_u24lambda_u2d1);
        this.bridgeSelector = new BridgeSelector(null, 1, null);
        JicofoServices jicofoServices6 = this;
        if (BridgeConfig.config.getHealthChecksEnabled()) {
            $this$focusManager_u24lambda_u2d0 = object5 = new JvbDoctor(this.bridgeSelector);
            jicofoServices4 = jicofoServices6;
            boolean bl4 = false;
            this.bridgeSelector.addHandler((BridgeSelector.EventHandler)$this$jvbDoctor_u24lambda_u2d2);
            jicofoServices6 = jicofoServices4;
            object3 = object5;
        } else {
            this.logger.warn("JVB health-checks disabled");
            object3 = null;
        }
        jicofoServices6.jvbDoctor = object3;
        JicofoServices jicofoServices7 = this;
        EntityBareJid entityBareJid = BridgeConfig.config.getBreweryJid();
        if (entityBareJid != null) {
            bl3 = entityBareJid;
            jicofoServices4 = jicofoServices7;
            boolean bl5 = false;
            baseBrewery3 = new BridgeMucDetector(this.xmppServices.getXmppConnectionByName(BridgeConfig.config.getXmppConnectionName()), this.bridgeSelector, (EntityBareJid)((Object)breweryJid2));
            BridgeMucDetector $this$bridgeDetector_u24lambda_u2d4_u24lambda_u2d3 = baseBrewery3;
            boolean bl6 = false;
            $this$bridgeDetector_u24lambda_u2d4_u24lambda_u2d3.init();
            bridgeMucDetector = baseBrewery3;
            jicofoServices3 = jicofoServices4;
        } else {
            breweryJid2 = this;
            jicofoServices4 = jicofoServices7;
            boolean bl7 = false;
            ((JicofoServices)((Object)$this$bridgeDetector_u24lambda_u2d5)).logger.error("No bridge detector configured.");
            jicofoServices3 = jicofoServices4;
            bridgeMucDetector = null;
        }
        jicofoServices3.bridgeDetector = bridgeMucDetector;
        JicofoServices jicofoServices8 = this;
        EntityBareJid entityBareJid2 = JibriConfig.config.getBreweryJid();
        if (entityBareJid2 != null) {
            $this$bridgeDetector_u24lambda_u2d5 = entityBareJid2;
            jicofoServices4 = jicofoServices8;
            boolean bl8 = false;
            BaseBrewery $this$jibriDetector_u24lambda_u2d7_u24lambda_u2d6 = baseBrewery3 = new JibriDetector(this.xmppServices.getXmppConnectionByName(JibriConfig.config.getXmppConnectionName()), (EntityBareJid)((Object)breweryJid2), false, null, 8, null);
            boolean bl9 = false;
            $this$jibriDetector_u24lambda_u2d7_u24lambda_u2d6.init();
            baseBrewery2 = baseBrewery3;
            jicofoServices2 = jicofoServices4;
        } else {
            breweryJid2 = this;
            jicofoServices4 = jicofoServices8;
            boolean bl10 = false;
            ((JicofoServices)((Object)$this$jibriDetector_u24lambda_u2d8)).logger.info("No Jibri detector configured.");
            jicofoServices2 = jicofoServices4;
            baseBrewery2 = null;
        }
        jicofoServices2.jibriDetector = baseBrewery2;
        JicofoServices jicofoServices9 = this;
        EntityBareJid entityBareJid3 = JibriConfig.config.getSipBreweryJid();
        if (entityBareJid3 != null) {
            $this$jibriDetector_u24lambda_u2d8 = entityBareJid3;
            jicofoServices4 = jicofoServices9;
            boolean bl11 = false;
            BaseBrewery $this$sipJibriDetector_u24lambda_u2d10_u24lambda_u2d9 = baseBrewery3 = new JibriDetector(this.xmppServices.getClientConnection(), (EntityBareJid)((Object)breweryJid2), true, null, 8, null);
            boolean bl12 = false;
            $this$sipJibriDetector_u24lambda_u2d10_u24lambda_u2d9.init();
            baseBrewery = baseBrewery3;
            jicofoServices = jicofoServices4;
        } else {
            breweryJid2 = this;
            jicofoServices4 = jicofoServices9;
            boolean bl13 = false;
            ((JicofoServices)$this$sipJibriDetector_u24lambda_u2d11).logger.info("No SIP Jibri detector configured.");
            jicofoServices = jicofoServices4;
            baseBrewery = null;
        }
        jicofoServices.sipJibriDetector = baseBrewery;
        JicofoServices jicofoServices10 = this;
        if (HealthConfig.config.getEnabled()) {
            void $this$healthChecker_u24lambda_u2d12;
            $this$jvbDoctor_u24lambda_u2d2 = object5 = new JicofoHealthChecker(HealthConfig.config, this.focusManager);
            jicofoServices4 = jicofoServices10;
            boolean bl14 = false;
            $this$healthChecker_u24lambda_u2d12.start();
            jicofoServices10 = jicofoServices4;
            object2 = object5;
        } else {
            object2 = null;
        }
        jicofoServices10.healthChecker = object2;
        JettyBundleActivatorConfig httpServerConfig = new JettyBundleActivatorConfig("org.jitsi.jicofo.auth", "jicofo.rest");
        JicofoServices jicofoServices11 = this;
        if (JettyHelpers.isEnabled(httpServerConfig)) {
            void it;
            this.logger.info("Starting HTTP server with config: " + httpServerConfig + ".");
            Object object6 = this.authenticationAuthority;
            Application restApp = new Application(object6 instanceof ShibbolethAuthAuthority ? (ShibbolethAuthAuthority)object6 : null, CurrentVersionImpl.VERSION, this.healthChecker);
            $this$sipJibriDetector_u24lambda_u2d11 = object6 = JettyHelpers.createServer(httpServerConfig);
            jicofoServices4 = jicofoServices11;
            boolean bl15 = false;
            JettyHelpers.getServletContextHandler((Server)it).addServlet(new ServletHolder(new ServletContainer(restApp)), "/*");
            it.start();
            jicofoServices11 = jicofoServices4;
            object = object6;
        } else {
            object = null;
        }
        jicofoServices11.jettyServer = object;
    }

    @NotNull
    public XmppProviderFactory createXmppProviderFactory() {
        SmackKt.initializeSmack();
        return new XmppProviderFactory(){

            @NotNull
            public XmppProvider createXmppProvider(@NotNull XmppConnectionConfig config, @NotNull Logger parentLogger) {
                Intrinsics.checkNotNullParameter(config, "config");
                Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
                return new XmppProviderImpl(config, parentLogger);
            }
        };
    }

    @NotNull
    public final FocusManager getFocusManager() {
        return this.focusManager;
    }

    @Nullable
    public final AbstractAuthAuthority getAuthenticationAuthority() {
        return this.authenticationAuthority;
    }

    @NotNull
    public final XmppServices getXmppServices() {
        return this.xmppServices;
    }

    @NotNull
    public final BridgeSelector getBridgeSelector() {
        return this.bridgeSelector;
    }

    @Nullable
    public final JibriDetector getJibriDetector() {
        return this.jibriDetector;
    }

    @Nullable
    public final JibriDetector getSipJibriDetector() {
        return this.sipJibriDetector;
    }

    public final void shutdown() {
        Object it;
        AbstractAuthAuthority abstractAuthAuthority = this.authenticationAuthority;
        if (abstractAuthAuthority != null) {
            it = abstractAuthAuthority;
            boolean bl = false;
            this.focusManager.removeListener((ConferenceStore.Listener)it);
            ((AbstractAuthAuthority)it).shutdown();
        }
        JicofoHealthChecker jicofoHealthChecker = this.healthChecker;
        if (jicofoHealthChecker != null) {
            jicofoHealthChecker.shutdown();
        }
        Server server = this.jettyServer;
        if (server != null) {
            server.stop();
        }
        JvbDoctor jvbDoctor = this.jvbDoctor;
        if (jvbDoctor != null) {
            it = jvbDoctor;
            boolean bl = false;
            this.bridgeSelector.removeHandler((BridgeSelector.EventHandler)it);
            ((JvbDoctor)it).shutdown();
        }
        BridgeMucDetector bridgeMucDetector = this.bridgeDetector;
        if (bridgeMucDetector != null) {
            bridgeMucDetector.shutdown();
        }
        JibriDetector jibriDetector = this.jibriDetector;
        if (jibriDetector != null) {
            jibriDetector.shutdown();
        }
        JibriDetector jibriDetector2 = this.sipJibriDetector;
        if (jibriDetector2 != null) {
            jibriDetector2.shutdown();
        }
        this.xmppServices.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private final AbstractAuthAuthority createAuthenticationAuthority() {
        AbstractAuthAuthority abstractAuthAuthority;
        if (AuthConfig.config.getEnabled()) {
            void var1_1;
            AbstractAuthAuthority abstractAuthAuthority2;
            this.logger.info("Starting authentication service with config=" + AuthConfig.config + ".");
            switch (WhenMappings.$EnumSwitchMapping$0[AuthConfig.config.getType().ordinal()]) {
                case 1: {
                    abstractAuthAuthority2 = new XMPPDomainAuthAuthority(AuthConfig.config.getEnableAutoLogin(), AuthConfig.config.getAuthenticationLifetime(), JidCreate.domainBareFrom(AuthConfig.config.getLoginUrl()));
                    break;
                }
                case 2: {
                    abstractAuthAuthority2 = new ExternalJWTAuthority(JidCreate.domainBareFrom(AuthConfig.config.getLoginUrl()));
                    break;
                }
                case 3: {
                    abstractAuthAuthority2 = new ShibbolethAuthAuthority(AuthConfig.config.getEnableAutoLogin(), AuthConfig.config.getAuthenticationLifetime(), AuthConfig.config.getLoginUrl(), AuthConfig.config.getLogoutUrl());
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            AbstractAuthAuthority authAuthority = abstractAuthAuthority2;
            abstractAuthAuthority = var1_1;
        } else {
            this.logger.info("Authentication service disabled.");
            abstractAuthAuthority = null;
        }
        return abstractAuthAuthority;
    }

    @NotNull
    public final JSONObject getStats() {
        JSONObject jSONObject;
        block3: {
            Object it;
            JSONObject $this$getStats_u24lambda_u2d20 = jSONObject = new JSONObject();
            boolean bl = false;
            $this$getStats_u24lambda_u2d20.putAll(this.focusManager.getStats());
            $this$getStats_u24lambda_u2d20.put("bridge_selector", this.bridgeSelector.getStats());
            JibriDetector jibriDetector = this.jibriDetector;
            if (jibriDetector != null) {
                it = jibriDetector;
                boolean bl2 = false;
                $this$getStats_u24lambda_u2d20.put("jibri_detector", ((JibriDetector)it).getStats());
            }
            JibriDetector jibriDetector2 = this.sipJibriDetector;
            if (jibriDetector2 != null) {
                it = jibriDetector2;
                boolean bl3 = false;
                $this$getStats_u24lambda_u2d20.put("sip_jibri_detector", ((JibriDetector)it).getStats());
            }
            JigasiDetector jigasiDetector = this.xmppServices.getJigasiDetector();
            if (jigasiDetector != null) {
                it = jigasiDetector;
                boolean bl4 = false;
                $this$getStats_u24lambda_u2d20.put("jigasi_detector", ((JigasiDetector)it).getStats());
            }
            $this$getStats_u24lambda_u2d20.put("jigasi", this.xmppServices.getJigasiStats());
            $this$getStats_u24lambda_u2d20.put("threads", ManagementFactory.getThreadMXBean().getThreadCount());
            $this$getStats_u24lambda_u2d20.put("jingle", AbstractOperationSetJingle.getStats());
            JicofoHealthChecker jicofoHealthChecker = this.healthChecker;
            if (jicofoHealthChecker == null) break block3;
            it = jicofoHealthChecker;
            boolean bl5 = false;
            $this$getStats_u24lambda_u2d20.put("slow_health_check", ((JicofoHealthChecker)it).getTotalSlowHealthChecks());
            $this$getStats_u24lambda_u2d20.put("healthy", ((JicofoHealthChecker)it).getResult() == null);
        }
        return jSONObject;
    }

    @NotNull
    public final OrderedJsonObject getDebugState(boolean full) {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$getDebugState_u24lambda_u2d21 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        OrderedJsonObject orderedJsonObject2 = this.focusManager.getDebugState(full);
        Intrinsics.checkNotNullExpressionValue(orderedJsonObject2, "focusManager.getDebugState(full)");
        $this$getDebugState_u24lambda_u2d21.put("focus_manager", orderedJsonObject2);
        $this$getDebugState_u24lambda_u2d21.put("bridge_selector", this.bridgeSelector.getDebugState());
        Object object = this.jibriDetector;
        if (object == null || (object = ((JibriDetector)object).getDebugState()) == null) {
            object = "null";
        }
        $this$getDebugState_u24lambda_u2d21.put("jibri_detector", object);
        Object object2 = this.sipJibriDetector;
        if (object2 == null || (object2 = ((JibriDetector)object2).getDebugState()) == null) {
            object2 = "null";
        }
        $this$getDebugState_u24lambda_u2d21.put("sip_jibri_detector", object2);
        Object object3 = this.xmppServices.getJigasiDetector();
        if (object3 == null || (object3 = ((JigasiDetector)object3).getDebugState()) == null) {
            object3 = "null";
        }
        $this$getDebugState_u24lambda_u2d21.put("jigasi_detector", object3);
        return orderedJsonObject;
    }

    @NotNull
    public final OrderedJsonObject getConferenceDebugState(@NotNull String conferenceId) {
        Intrinsics.checkNotNullParameter(conferenceId, "conferenceId");
        OrderedJsonObject $this$getConferenceDebugState_u24lambda_u2d22 = new OrderedJsonObject();
        boolean bl = false;
        JitsiMeetConferenceImpl conference = this.focusManager.getConference(JidCreate.entityBareFrom(conferenceId));
        Object object = conference;
        if (object == null || (object = ((JitsiMeetConferenceImpl)object).getDebugState()) == null) {
            object = new OrderedJsonObject();
        }
        Intrinsics.checkNotNullExpressionValue(object, "conference?.debugState ?: OrderedJsonObject()");
        return object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/jicofo/JicofoServices$Companion;", "", "()V", "jicofoServicesSingleton", "Lorg/jitsi/jicofo/JicofoServices;", "jicofo"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AuthConfig.Type.values().length];
            nArray[AuthConfig.Type.XMPP.ordinal()] = 1;
            nArray[AuthConfig.Type.JWT.ordinal()] = 2;
            nArray[AuthConfig.Type.SHIBBOLETH.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

