/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.ConferenceConfig;
import org.jitsi.jicofo.JitsiMeetConfig;
import org.jitsi.jicofo.Offer;
import org.jitsi.jicofo.codec.JingleOfferFactory;
import org.jitsi.jicofo.codec.OfferOptions;
import org.jitsi.jicofo.codec.OfferOptionsKt;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.conference.Participant;
import org.jitsi.jicofo.conference.UnsupportedFeatureConfigurationException;
import org.jitsi.jicofo.conference.colibri.BridgeSelectionFailedException;
import org.jitsi.jicofo.conference.colibri.ColibriAllocation;
import org.jitsi.jicofo.conference.colibri.ColibriAllocationFailedException;
import org.jitsi.jicofo.conference.colibri.ColibriSessionManager;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.util.Cancelable;
import org.jitsi.protocol.xmpp.JingleSession;
import org.jitsi.protocol.xmpp.OperationSetJingle;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleRtcpmuxPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleUtils;
import org.jitsi.xmpp.extensions.jingle.RtpDescriptionPacketExtension;
import org.jitsi.xmpp.extensions.jingle.SctpMapExtension;
import org.jitsi.xmpp.extensions.jitsimeet.BridgeSessionPacketExtension;
import org.jitsi.xmpp.extensions.jitsimeet.StartMutedPacketExtension;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public class ParticipantInviteRunnable
implements Runnable,
Cancelable {
    public static final Jid SSRC_OWNER_JVB;
    private final Logger logger;
    private final JitsiMeetConferenceImpl meetConference;
    @NotNull
    private final ColibriSessionManager colibriSessionManager;
    private volatile boolean canceled = false;
    private final boolean startAudioMuted;
    private final boolean startVideoMuted;
    private final boolean forceMuteAudio;
    private final boolean forceMuteVideo;
    private final boolean reInvite;
    @NotNull
    private final Participant participant;

    public ParticipantInviteRunnable(JitsiMeetConferenceImpl meetConference, @NotNull ColibriSessionManager colibriSessionManager, @NotNull Participant participant, boolean startAudioMuted, boolean startVideoMuted, boolean reInvite, Logger parentLogger) {
        this.meetConference = meetConference;
        this.colibriSessionManager = colibriSessionManager;
        boolean forceMuteAudio = false;
        boolean forceMuteVideo = false;
        ChatRoom chatRoom = meetConference.getChatRoom();
        if (chatRoom != null && !participant.hasModeratorRights() && !participant.shouldSuppressForceMute()) {
            if (chatRoom.isAvModerationEnabled(MediaType.AUDIO)) {
                forceMuteAudio = true;
            }
            if (chatRoom.isAvModerationEnabled(MediaType.VIDEO)) {
                forceMuteVideo = true;
            }
        }
        this.forceMuteAudio = forceMuteAudio;
        this.forceMuteVideo = forceMuteVideo;
        this.startAudioMuted = startAudioMuted || forceMuteAudio;
        this.startVideoMuted = startVideoMuted || forceMuteVideo;
        this.reInvite = reInvite;
        this.participant = participant;
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.logger.addContext("participant", participant.getChatMember().getName());
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        catch (Throwable e) {
            this.logger.error("Channel allocator failed: ", e);
            this.cancel();
        }
        finally {
            this.participant.inviteRunnableCompleted(this);
        }
    }

    private void doRun() {
        ColibriAllocation colibriAllocation;
        Offer offer;
        try {
            offer = this.createOffer();
        }
        catch (UnsupportedFeatureConfigurationException e) {
            this.logger.error("Error creating offer", e);
            return;
        }
        if (this.canceled) {
            return;
        }
        try {
            colibriAllocation = this.colibriSessionManager.allocate(this.participant, offer.getContents(), this.forceMuteAudio, this.forceMuteVideo);
        }
        catch (BridgeSelectionFailedException e) {
            this.logger.error("Can not invite participant, no bridge available.");
            this.cancel();
            return;
        }
        catch (ColibriAllocationFailedException e) {
            this.logger.error("Failed to allocate colibri channels", e);
            this.cancel();
            return;
        }
        if (this.canceled) {
            return;
        }
        offer = this.updateOffer(offer, colibriAllocation);
        if (this.canceled) {
            return;
        }
        try {
            this.invite(offer, colibriAllocation);
        }
        catch (SmackException.NotConnectedException e) {
            this.logger.error("Failed to invite participant: ", e);
            this.colibriSessionManager.removeParticipant(this.participant);
            this.cancel();
        }
    }

    @Override
    public void cancel() {
        this.canceled = true;
    }

    public String toString() {
        return String.format("%s[%s]@%d", this.getClass().getSimpleName(), this.participant, this.hashCode());
    }

    private Offer createOffer() throws UnsupportedFeatureConfigurationException {
        JitsiMeetConfig config = this.meetConference.getConfig();
        OfferOptions offerOptions = new OfferOptions();
        OfferOptionsKt.applyConstraints(offerOptions, config);
        OfferOptionsKt.applyConstraints(offerOptions, this.participant);
        if (!offerOptions.getTcc() && this.participant.hasRembSupport()) {
            offerOptions.setRemb(true);
        }
        return new Offer(new ConferenceSourceMap(), JingleOfferFactory.INSTANCE.createOffer(offerOptions));
    }

    private void invite(Offer offer, ColibriAllocation colibriAllocation) throws SmackException.NotConnectedException {
        boolean expireChannels = false;
        EntityFullJid address = this.participant.getMucJid();
        ChatRoom chatRoom = this.meetConference.getChatRoom();
        if (chatRoom == null) {
            this.logger.info("Expiring " + address + " channels - conference disposed");
            expireChannels = true;
        } else if (!this.meetConference.hasMember(address)) {
            this.logger.info("Expiring " + address + " channels - participant has left");
            expireChannels = true;
        } else if (!this.canceled && !this.doInviteOrReinvite(address, offer, colibriAllocation)) {
            expireChannels = true;
        }
        if (expireChannels || this.canceled) {
            this.meetConference.onInviteFailed(this);
        }
    }

    private boolean doInviteOrReinvite(Jid address, Offer offer, ColibriAllocation colibriAllocation) throws SmackException.NotConnectedException {
        boolean ack;
        OperationSetJingle jingle = this.meetConference.getJingle();
        JingleSession jingleSession = this.participant.getJingleSession();
        boolean initiateSession = !this.reInvite || jingleSession == null;
        ArrayList<ExtensionElement> additionalExtensions = new ArrayList<ExtensionElement>();
        if (this.startAudioMuted || this.startVideoMuted) {
            StartMutedPacketExtension startMutedExt = new StartMutedPacketExtension();
            startMutedExt.setAudioMute(this.startAudioMuted);
            startMutedExt.setVideoMute(this.startVideoMuted);
            additionalExtensions.add(startMutedExt);
        }
        additionalExtensions.add(new BridgeSessionPacketExtension(colibriAllocation.getBridgeSessionId(), colibriAllocation.getRegion()));
        ConferenceSourceMap sources = this.participant.resetSignaledSources(offer.getSources());
        if (initiateSession) {
            this.logger.info("Sending session-initiate to: " + address + " sources=" + offer.getSources());
            ack = jingle.initiateSession(address, offer.getContents(), additionalExtensions, this.meetConference, sources, ConferenceConfig.config.getUseJsonEncodedSources() && this.participant.supportsJsonEncodedSources());
        } else {
            this.logger.info("Sending transport-replace to: " + address + " sources=" + offer.getSources());
            ack = jingle.replaceTransport(jingleSession, offer.getContents(), additionalExtensions, sources, ConferenceConfig.config.getUseJsonEncodedSources() && this.participant.supportsJsonEncodedSources());
        }
        if (!ack) {
            this.logger.info("Expiring " + address + " channels - no RESULT for " + (initiateSession ? "session-initiate" : "transport-replace"));
            return false;
        }
        return true;
    }

    @NotNull
    private Offer updateOffer(Offer offer, ColibriAllocation colibriAllocation) {
        ConferenceSourceMap conferenceSources = this.meetConference.getSources().copy();
        conferenceSources.add(colibriAllocation.getSources());
        conferenceSources.remove(this.participant.getMucJid());
        for (ContentPacketExtension cpe : offer.getContents()) {
            RtpDescriptionPacketExtension rtpDescPe;
            try {
                IceUdpTransportPacketExtension empty2 = cpe.getFirstChildOfType(IceUdpTransportPacketExtension.class);
                cpe.getChildExtensions().remove(empty2);
                IceUdpTransportPacketExtension copy2 = IceUdpTransportPacketExtension.cloneTransportAndCandidates(colibriAllocation.getTransport(), true);
                if ("data".equalsIgnoreCase(cpe.getName())) {
                    SctpMapExtension sctpMap = new SctpMapExtension();
                    Integer sctpPort = colibriAllocation.getSctpPort();
                    if (sctpPort == null) {
                        throw new IllegalStateException("SCTP port must not be null");
                    }
                    sctpMap.setPort(sctpPort);
                    sctpMap.setProtocol(SctpMapExtension.Protocol.WEBRTC_CHANNEL);
                    sctpMap.setStreams(1024);
                    copy2.addChildExtension(sctpMap);
                }
                cpe.addChildExtension(copy2);
            }
            catch (Exception e) {
                this.logger.error(e, e);
            }
            if ((rtpDescPe = JingleUtils.getRtpDescription(cpe)) == null) continue;
            rtpDescPe.addChildExtension(new JingleRtcpmuxPacketExtension());
        }
        return new Offer(conferenceSources, offer.getContents());
    }

    @NotNull
    public Participant getParticipant() {
        return this.participant;
    }

    static {
        try {
            SSRC_OWNER_JVB = JidCreate.from("jvb");
        }
        catch (XmppStringprepException e) {
            throw new RuntimeException(e);
        }
    }
}

