/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.conference.colibri.v2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.jicofo.OctoConfig;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.conference.Participant;
import org.jitsi.jicofo.conference.colibri.BridgeSelectionFailedException;
import org.jitsi.jicofo.conference.colibri.ColibriAllocation;
import org.jitsi.jicofo.conference.colibri.ColibriAllocationFailedException;
import org.jitsi.jicofo.conference.colibri.ColibriSessionManager;
import org.jitsi.jicofo.conference.colibri.v2.Colibri2Session;
import org.jitsi.jicofo.conference.colibri.v2.ColibriV2SessionManager;
import org.jitsi.jicofo.conference.colibri.v2.ExtensionsKt;
import org.jitsi.jicofo.conference.colibri.v2.ParticipantInfo;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.event.AsyncEventEmitter;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.colibri2.Colibri2Error;
import org.jitsi.xmpp.extensions.colibri2.ConferenceModifiedIQ;
import org.jitsi.xmpp.extensions.colibri2.Sctp;
import org.jitsi.xmpp.extensions.colibri2.Transport;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.IceUdpTransportPacketExtension;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.json.simple.JSONArray;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00c6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020)H\u0002J\u0010\u00108\u001a\u0002062\u0006\u00109\u001a\u00020!H\u0016J.\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010A\u001a\u00020\u00152\u0006\u0010B\u001a\u00020\u0015H\u0016J\b\u0010C\u001a\u000206H\u0002J\b\u0010D\u001a\u000206H\u0016J\u0012\u0010E\u001a\u0004\u0018\u00010\u00112\u0006\u0010<\u001a\u00020=H\u0016J\u0014\u0010F\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\f0GH\u0002J\u001c\u0010H\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u00150I2\u0006\u0010J\u001a\u000200H\u0002J\u0016\u0010K\u001a\b\u0012\u0004\u0012\u00020)0?2\u0006\u0010L\u001a\u00020+H\u0002J2\u0010M\u001a\u00020;2\b\u0010N\u001a\u0004\u0018\u00010O2\u0006\u0010L\u001a\u00020+2\u0006\u0010P\u001a\u00020\u00152\u0006\u00107\u001a\u00020)2\u0006\u0010Q\u001a\u00020\u0015H\u0002J&\u0010R\u001a\u00020\u00152\f\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010T\u001a\u00020\u00152\u0006\u0010U\u001a\u00020VH\u0016J\u0010\u0010W\u001a\u0002062\u0006\u00107\u001a\u00020)H\u0002J\u0016\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00110?2\u0006\u0010J\u001a\u000200H\u0016J\u0010\u0010Y\u001a\u0002062\u0006\u00109\u001a\u00020!H\u0016J\u0010\u0010Z\u001a\u0002062\u0006\u0010<\u001a\u00020=H\u0016J(\u0010[\u001a\b\u0012\u0004\u0012\u00020)0\u00102\u0018\u0010\\\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0?0GH\u0002J\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020)0\u00102\u0006\u0010L\u001a\u00020+H\u0002J\u0015\u0010^\u001a\u0002062\u0006\u0010L\u001a\u00020+H\u0000\u00a2\u0006\u0002\b_J%\u0010`\u001a\u0002062\u0006\u0010L\u001a\u00020+2\u0006\u0010a\u001a\u00020b2\u0006\u0010c\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\bdJ,\u0010e\u001a\u0002062\u0006\u0010<\u001a\u00020=2\b\u0010a\u001a\u0004\u0018\u00010b2\b\u0010f\u001a\u0004\u0018\u00010g2\u0006\u0010h\u001a\u00020\u0015H\u0016R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020\u00118@X\u0080\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b$\u0010\u001aR\u001a\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020)0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010*\u001a\u0014\u0012\u0004\u0012\u00020+\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0,0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0017R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020+0(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006i"}, d2={"Lorg/jitsi/jicofo/conference/colibri/v2/ColibriV2SessionManager;", "Lorg/jitsi/jicofo/conference/colibri/ColibriSessionManager;", "xmppConnection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "bridgeSelector", "Lorg/jitsi/jicofo/bridge/BridgeSelector;", "conference", "Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "(Lorg/jivesoftware/smack/AbstractXMPPConnection;Lorg/jitsi/jicofo/bridge/BridgeSelector;Lorg/jitsi/jicofo/conference/JitsiMeetConferenceImpl;Lorg/jitsi/utils/logging2/Logger;)V", "bridgeCount", "", "getBridgeCount", "()I", "bridgeRegions", "", "", "getBridgeRegions", "()Ljava/util/Set;", "callstatsEnabled", "", "getCallstatsEnabled$jicofo", "()Z", "conferenceName", "getConferenceName$jicofo", "()Ljava/lang/String;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "getDebugState", "()Lorg/jitsi/utils/OrderedJsonObject;", "eventEmitter", "Lorg/jitsi/utils/event/AsyncEventEmitter;", "Lorg/jitsi/jicofo/conference/colibri/ColibriSessionManager$Listener;", "logger", "meetingId", "getMeetingId$jicofo", "meetingId$delegate", "Lkotlin/Lazy;", "participants", "", "Lorg/jitsi/jicofo/conference/colibri/v2/ParticipantInfo;", "participantsBySession", "Lorg/jitsi/jicofo/conference/colibri/v2/Colibri2Session;", "", "rtcStatsEnabled", "getRtcStatsEnabled$jicofo", "sessions", "Lorg/jitsi/jicofo/bridge/Bridge;", "syncRoot", "", "getXmppConnection$jicofo", "()Lorg/jivesoftware/smack/AbstractXMPPConnection;", "add", "", "participantInfo", "addListener", "listener", "allocate", "Lorg/jitsi/jicofo/conference/colibri/ColibriAllocation;", "participant", "Lorg/jitsi/jicofo/conference/Participant;", "contents", "", "Lorg/jitsi/xmpp/extensions/jingle/ContentPacketExtension;", "forceMuteAudio", "forceMuteVideo", "clear", "expire", "getBridgeSessionId", "getBridges", "", "getOrCreateSession", "Lkotlin/Pair;", "bridge", "getSessionParticipants", "session", "handleResponse", "response", "Lorg/jivesoftware/smack/packet/IQ;", "created", "useSctp", "mute", "participantIds", "doMute", "mediaType", "Lorg/jitsi/utils/MediaType;", "remove", "removeBridge", "removeListener", "removeParticipant", "removeParticipantInfosBySession", "bySession", "removeSession", "sessionFailed", "sessionFailed$jicofo", "setRelayTransport", "transport", "Lorg/jitsi/xmpp/extensions/jingle/IceUdpTransportPacketExtension;", "relayId", "setRelayTransport$jicofo", "updateParticipant", "sources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "suppressLocalBridgeUpdate", "jicofo"})
@SuppressFBWarnings(value={"BC_IMPOSSIBLE_INSTANCEOF"})
public final class ColibriV2SessionManager
implements ColibriSessionManager {
    @NotNull
    private final AbstractXMPPConnection xmppConnection;
    @NotNull
    private final BridgeSelector bridgeSelector;
    @NotNull
    private final JitsiMeetConferenceImpl conference;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AsyncEventEmitter<ColibriSessionManager.Listener> eventEmitter;
    @NotNull
    private final Map<Bridge, Colibri2Session> sessions;
    @NotNull
    private final Map<String, ParticipantInfo> participants;
    @NotNull
    private final Map<Colibri2Session, List<ParticipantInfo>> participantsBySession;
    @NotNull
    private final Object syncRoot;
    @NotNull
    private final Lazy meetingId$delegate;
    @NotNull
    private final String conferenceName;
    private final boolean callstatsEnabled;
    private final boolean rtcStatsEnabled;

    public ColibriV2SessionManager(@NotNull AbstractXMPPConnection xmppConnection, @NotNull BridgeSelector bridgeSelector, @NotNull JitsiMeetConferenceImpl conference, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(xmppConnection, "xmppConnection");
        Intrinsics.checkNotNullParameter(bridgeSelector, "bridgeSelector");
        Intrinsics.checkNotNullParameter(conference, "conference");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.xmppConnection = xmppConnection;
        this.bridgeSelector = bridgeSelector;
        this.conference = conference;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.eventEmitter = new AsyncEventEmitter(TaskPools.Companion.getIoPool());
        this.sessions = new LinkedHashMap();
        this.participants = new LinkedHashMap();
        this.participantsBySession = new LinkedHashMap();
        this.syncRoot = new Object();
        this.meetingId$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ ColibriV2SessionManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string;
                String chatRoomMeetingId;
                ChatRoom chatRoom = ColibriV2SessionManager.access$getConference$p(this.this$0).getChatRoom();
                String string2 = chatRoomMeetingId = chatRoom != null ? chatRoom.getMeetingId() : null;
                if (chatRoomMeetingId == null) {
                    ColibriV2SessionManager.access$getLogger$p(this.this$0).warn("No meetingId set for the MUC. Generating one locally.");
                    string = UUID.randomUUID().toString();
                } else {
                    string = chatRoomMeetingId;
                }
                Intrinsics.checkNotNullExpressionValue(string, "if (chatRoomMeetingId ==\u2026 } else chatRoomMeetingId");
                return string;
            }
        });
        this.conferenceName = this.conference.getRoomName().toString();
        this.callstatsEnabled = this.conference.getConfig().getCallStatsEnabled();
        this.rtcStatsEnabled = this.conference.getConfig().getRtcStatsEnabled();
    }

    @NotNull
    public final AbstractXMPPConnection getXmppConnection$jicofo() {
        return this.xmppConnection;
    }

    @Override
    public void addListener(@NotNull ColibriSessionManager.Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.eventEmitter.addHandler(listener);
    }

    @Override
    public void removeListener(@NotNull ColibriSessionManager.Listener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.eventEmitter.removeHandler(listener);
    }

    @NotNull
    public final String getMeetingId$jicofo() {
        Lazy lazy = this.meetingId$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getConferenceName$jicofo() {
        return this.conferenceName;
    }

    public final boolean getCallstatsEnabled$jicofo() {
        return this.callstatsEnabled;
    }

    public final boolean getRtcStatsEnabled$jicofo() {
        return this.rtcStatsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expire() {
        Object object = this.syncRoot;
        synchronized (object) {
            boolean bl = false;
            this.logger.info("Expiring.");
            Iterable $this$forEach$iv = this.sessions.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Colibri2Session session = (Colibri2Session)element$iv;
                boolean bl2 = false;
                this.logger.debug(() -> ColibriV2SessionManager.expire$lambda-2$lambda-1$lambda-0(session));
                session.expire$jicofo();
            }
            this.sessions.clear();
            this.eventEmitter.fireEvent(expire.1.2.INSTANCE);
            this.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParticipant(@NotNull Participant participant) {
        Intrinsics.checkNotNullParameter(participant, "participant");
        Object object = this.syncRoot;
        synchronized (object) {
            block6: {
                Object object2;
                block5: {
                    boolean bl = false;
                    this.logger.debug(() -> ColibriV2SessionManager.removeParticipant$lambda-5$lambda-3(participant));
                    object2 = this.participants.get(participant.getEndpointId());
                    if (object2 == null) break block5;
                    ParticipantInfo it = object2;
                    boolean bl2 = false;
                    this.logger.info("Removing " + it.getId());
                    Set<ParticipantInfo> set = this.removeParticipantInfosBySession(MapsKt.mapOf(TuplesKt.to(it.getSession(), Collections.singletonList(it))));
                    object2 = set;
                    if (set != null) break block6;
                }
                this.logger.warn("Can not remove " + participant.getEndpointId() + ", no participantInfo");
                object2 = Unit.INSTANCE;
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Set<ParticipantInfo> removeSession(Colibri2Session session) {
        List<ParticipantInfo> participants;
        block2: {
            participants = this.getSessionParticipants(session);
            session.expire$jicofo();
            this.sessions.remove(session.getBridge());
            this.participantsBySession.remove(session);
            Iterable $this$forEach$iv = participants;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParticipantInfo it = (ParticipantInfo)element$iv;
                boolean bl = false;
                this.remove(it);
            }
            String string = session.getRelayId();
            if (string == null) break block2;
            String removedRelayId = string;
            boolean bl = false;
            Iterable $this$forEach$iv2 = this.sessions.values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                Colibri2Session otherSession = (Colibri2Session)element$iv;
                boolean bl2 = false;
                otherSession.expireRelay$jicofo(removedRelayId);
            }
        }
        return CollectionsKt.toSet((Iterable)participants);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<ParticipantInfo> removeParticipantInfosBySession(Map<Colibri2Session, ? extends List<ParticipantInfo>> bySession) {
        boolean sessionRemoved = false;
        Set participantsRemoved = new LinkedHashSet();
        Map<Colibri2Session, ? extends List<ParticipantInfo>> $this$forEach$iv = bySession;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Colibri2Session, ? extends List<ParticipantInfo>>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv;
            Map.Entry<Colibri2Session, ? extends List<ParticipantInfo>> element$iv;
            Map.Entry<Colibri2Session, ? extends List<ParticipantInfo>> entry = element$iv = iterator2.next();
            boolean bl = false;
            Colibri2Session session = entry.getKey();
            List<ParticipantInfo> sessionParticipantsToRemove = entry.getValue();
            this.logger.debug(() -> ColibriV2SessionManager.removeParticipantInfosBySession$lambda-15$lambda-10(session, sessionParticipantsToRemove));
            List remaining = CollectionsKt.minus((Iterable)this.getSessionParticipants(session), CollectionsKt.toSet((Iterable)sessionParticipantsToRemove));
            boolean removeSession = remaining.isEmpty();
            if (removeSession) {
                this.logger.info("Removing session with no remaining participants: " + session);
                Set<ParticipantInfo> sessionParticipantsRemoved = this.removeSession(session);
                participantsRemoved.addAll((Collection)sessionParticipantsRemoved);
                sessionRemoved = true;
                continue;
            }
            session.expire$jicofo(sessionParticipantsToRemove);
            Iterable $this$forEach$iv2 = sessionParticipantsToRemove;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ParticipantInfo it = (ParticipantInfo)element$iv2;
                boolean bl2 = false;
                this.remove(it);
            }
            participantsRemoved.addAll((Collection)sessionParticipantsToRemove);
            Iterable $this$filter$iv = this.sessions.values();
            boolean $i$f$filter = false;
            Iterator iterator3 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Colibri2Session it = (Colibri2Session)element$iv$iv;
                boolean bl3 = false;
                if (!(!Intrinsics.areEqual(it, session))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it;
                Colibri2Session otherSession = (Colibri2Session)element$iv2;
                boolean bl4 = false;
                if (session.getRelayId() == null) continue;
                boolean bl5 = false;
                otherSession.expireRemoteParticipants$jicofo(sessionParticipantsToRemove, it);
            }
        }
        if (sessionRemoved) {
            this.eventEmitter.fireEvent(new Function1<ColibriSessionManager.Listener, Unit>(this){
                final /* synthetic */ ColibriV2SessionManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ColibriSessionManager.Listener $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.bridgeCountChanged(ColibriV2SessionManager.access$getSessions$p(this.this$0).size());
                }
            });
        }
        return participantsRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mute(@NotNull Set<String> participantIds, boolean doMute, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter(participantIds, "participantIds");
        Intrinsics.checkNotNullParameter((Object)mediaType, "mediaType");
        Object object = this.syncRoot;
        synchronized (object) {
            Object element$iv;
            boolean bl = false;
            Map participantsToMuteBySession = new LinkedHashMap();
            Object $this$forEach$iv = participantIds;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                String it = (String)element$iv;
                boolean bl2 = false;
                ParticipantInfo participantInfo = this.participants.get(it);
                if (participantInfo == null) {
                    this.logger.error("No ParticipantInfo for " + it + ", can not force mute.");
                    continue;
                }
                if (mediaType == MediaType.AUDIO && participantInfo.getAudioMuted() == doMute || mediaType == MediaType.VIDEO && participantInfo.getVideoMuted() == doMute) continue;
                if (mediaType == MediaType.AUDIO) {
                    participantInfo.setAudioMuted(doMute);
                }
                if (mediaType == MediaType.VIDEO) {
                    participantInfo.setVideoMuted(doMute);
                }
                participantsToMuteBySession.computeIfAbsent(participantInfo.getSession(), ColibriV2SessionManager::mute$lambda-19$lambda-17$lambda-16).add(participantInfo);
            }
            $this$forEach$iv = participantsToMuteBySession;
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Object object2 = element$iv = (Map.Entry)iterator2.next();
                boolean bl3 = false;
                Colibri2Session session = (Colibri2Session)object2.getKey();
                Set participantsToMute = (Set)object2.getValue();
                session.updateForceMute$jicofo(participantsToMute);
            }
            Unit unit = Unit.INSTANCE;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBridgeCount() {
        int n;
        Object object = this.syncRoot;
        synchronized (object) {
            boolean bl = false;
            n = this.sessions.size();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<String> getBridgeRegions() {
        Set<String> set;
        Object object = this.syncRoot;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = this.sessions.keySet();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Bridge bridge2 = (Bridge)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getRegion());
            }
            set = CollectionsKt.toSet(CollectionsKt.filterNotNull((List)destination$iv$iv));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Colibri2Session, Boolean> getOrCreateSession(Bridge bridge2) {
        Object object = this.syncRoot;
        synchronized (object) {
            Colibri2Session session;
            block4: {
                boolean bl = false;
                session = this.sessions.get(bridge2);
                if (session == null) break block4;
                Pair<Colibri2Session, Boolean> pair = new Pair<Colibri2Session, Boolean>(session, false);
                return pair;
            }
            session = new Colibri2Session(this, bridge2, this.logger);
            this.sessions.put(bridge2, session);
            Pair<Colibri2Session, Boolean> pair = new Pair<Colibri2Session, Boolean>(session, true);
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Map<Bridge, Integer> getBridges() {
        Object object = this.syncRoot;
        synchronized (object) {
            void $this$associateTo$iv$iv;
            void $this$filterTo$iv$iv;
            boolean bl = false;
            Iterable $this$filter$iv = this.participantsBySession.entrySet();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl2 = false;
                if (!((Colibri2Session)it.getKey()).getBridge().isOperational()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl3 = false;
                Pair<Bridge, Integer> pair = new Pair<Bridge, Integer>(((Colibri2Session)it.getKey()).getBridge(), ((List)it.getValue()).size());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map map = destination$iv$iv2;
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ColibriAllocation allocate(@NotNull Participant participant, @NotNull List<? extends ContentPacketExtension> contents, boolean forceMuteAudio, boolean forceMuteVideo) throws ColibriAllocationFailedException, BridgeSelectionFailedException {
        Object object;
        boolean bl;
        Ref.ObjectRef participantInfo;
        boolean created;
        Ref.ObjectRef<Colibri2Session> session;
        StanzaCollector stanzaCollector;
        block37: {
            Intrinsics.checkNotNullParameter(participant, "participant");
            Intrinsics.checkNotNullParameter(contents, "contents");
            this.logger.info("Allocating for " + participant.getEndpointId());
            stanzaCollector = null;
            session = new Ref.ObjectRef<Colibri2Session>();
            created = false;
            participantInfo = new Ref.ObjectRef();
            Iterable $this$any$iv = contents;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ContentPacketExtension it = (ContentPacketExtension)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getName(), "data")) continue;
                    bl = true;
                    break block37;
                }
                bl = false;
            }
        }
        boolean useSctp = bl;
        Object object2 = this.syncRoot;
        synchronized (object2) {
            void $this$forEach$iv;
            Iterator $this$filterTo$iv$iv;
            Collection destination$iv$iv;
            Iterable $this$filter$iv;
            Object $this$any$iv;
            Iterator<Map.Entry<Bridge, Colibri2Session>> $this$allocate_u24lambda_u2d38_u24lambda_u2d28;
            boolean bl3 = false;
            if (this.participants.containsKey(participant.getEndpointId())) {
                throw new IllegalStateException("participant already exists");
            }
            String version = this.conference.getBridgeVersion();
            if (version != null) {
                this.logger.info("Selecting bridge. Conference is pinned to version \"" + version + "\"");
            }
            Bridge bridge2 = this.bridgeSelector.selectBridge(this.getBridges(), participant.getChatMember().getRegion(), version);
            if (bridge2 == null) {
                $this$allocate_u24lambda_u2d38_u24lambda_u2d28 = this;
                boolean bl4 = false;
                ((ColibriV2SessionManager)((Object)$this$allocate_u24lambda_u2d38_u24lambda_u2d28)).eventEmitter.fireEvent(allocate.1.bridge.1.1.INSTANCE);
                throw new BridgeSelectionFailedException();
            }
            Bridge bridge3 = bridge2;
            this.eventEmitter.fireEvent(allocate.1.1.INSTANCE);
            if (!this.sessions.isEmpty()) {
                Map.Entry<Bridge, Colibri2Session> it;
                boolean bl5;
                block38: {
                    Map<Bridge, Colibri2Session> $this$none$iv = this.sessions;
                    boolean $i$f$none = false;
                    if ($this$none$iv.isEmpty()) {
                        bl5 = true;
                    } else {
                        $this$allocate_u24lambda_u2d38_u24lambda_u2d28 = $this$none$iv.entrySet().iterator();
                        while ($this$allocate_u24lambda_u2d38_u24lambda_u2d28.hasNext()) {
                            Map.Entry<Bridge, Colibri2Session> element$iv;
                            it = element$iv = (Map.Entry<Bridge, Colibri2Session>)$this$allocate_u24lambda_u2d38_u24lambda_u2d28.next();
                            boolean bl6 = false;
                            if (!Intrinsics.areEqual(it.getKey(), bridge3)) continue;
                            bl5 = false;
                            break block38;
                        }
                        bl5 = true;
                    }
                }
                if (bl5) {
                    boolean bl7;
                    block39: {
                        if (!OctoConfig.config.getEnabled()) {
                            this.logger.error("A new bridge was selected, but Octo is disabled");
                            throw new BridgeSelectionFailedException();
                        }
                        $this$any$iv = this.sessions;
                        boolean $i$f$any = false;
                        if ($this$any$iv.isEmpty()) {
                            bl7 = false;
                        } else {
                            $this$allocate_u24lambda_u2d38_u24lambda_u2d28 = $this$any$iv.entrySet().iterator();
                            while ($this$allocate_u24lambda_u2d38_u24lambda_u2d28.hasNext()) {
                                Map.Entry<Bridge, Colibri2Session> element$iv;
                                it = element$iv = $this$allocate_u24lambda_u2d38_u24lambda_u2d28.next();
                                boolean bl8 = false;
                                if (!(it.getValue().getRelayId() == null)) continue;
                                bl7 = true;
                                break block39;
                            }
                            bl7 = false;
                        }
                    }
                    if (bl7 || bridge3.getRelayId() == null) {
                        this.logger.error("Can not enable Octo: one of the selected bridges does not support Octo.");
                        throw new BridgeSelectionFailedException();
                    }
                }
            }
            Object it = this.getOrCreateSession(bridge3);
            boolean $i$a$-let-ColibriV2SessionManager$allocate$1$52 = false;
            session.element = ((Pair)it).getFirst();
            created = ((Pair)it).getSecond();
            this.logger.info("Selected " + bridge3.getJid().getResourceOrNull() + ", session exists: " + !created);
            $this$any$iv = participant.getEndpointId();
            it = participant.getStatId();
            Object $i$a$-let-ColibriV2SessionManager$allocate$1$52 = participant.getSources();
            boolean element$iv = participant.hasSourceNameSupport();
            Intrinsics.checkNotNullExpressionValue($this$any$iv, "endpointId");
            Intrinsics.checkNotNullExpressionValue($i$a$-let-ColibriV2SessionManager$allocate$1$52, "sources");
            participantInfo.element = new ParticipantInfo((String)$this$any$iv, (String)it, (ConferenceSourceMap)$i$a$-let-ColibriV2SessionManager$allocate$1$52, (Colibri2Session)session.element, forceMuteAudio, forceMuteVideo, element$iv);
            stanzaCollector = ((Colibri2Session)session.element).sendAllocationRequest$jicofo((ParticipantInfo)participantInfo.element, contents, useSctp);
            this.add((ParticipantInfo)participantInfo.element);
            if (created) {
                $this$filter$iv = this.sessions.values();
                boolean $i$f$filter = false;
                $i$a$-let-ColibriV2SessionManager$allocate$1$52 = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator bl8 = $this$filterTo$iv$iv.iterator();
                while (bl8.hasNext()) {
                    Object element$iv$iv = bl8.next();
                    Colibri2Session it2 = (Colibri2Session)element$iv$iv;
                    boolean bl9 = false;
                    if (!(!Intrinsics.areEqual(it2, session.element))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Colibri2Session it3 = (Colibri2Session)element$iv2;
                    boolean bl10 = false;
                    this.logger.debug(() -> ColibriV2SessionManager.allocate$lambda-38$lambda-34$lambda-33(session, it3));
                    String string = ((Colibri2Session)session.element).getRelayId();
                    Intrinsics.checkNotNull(string);
                    it3.createRelay$jicofo(string, this.getSessionParticipants((Colibri2Session)session.element), true);
                    Colibri2Session colibri2Session = (Colibri2Session)session.element;
                    String string2 = it3.getRelayId();
                    Intrinsics.checkNotNull(string2);
                    colibri2Session.createRelay$jicofo(string2, this.getSessionParticipants(it3), false);
                }
            } else {
                $this$filter$iv = this.sessions.values();
                boolean $i$f$filter = false;
                $this$filterTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator bl10 = $this$filterTo$iv$iv.iterator();
                while (bl10.hasNext()) {
                    Object element$iv$iv = bl10.next();
                    Colibri2Session it4 = (Colibri2Session)element$iv$iv;
                    boolean bl11 = false;
                    if (!(!Intrinsics.areEqual(it4, session.element))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Colibri2Session it5 = (Colibri2Session)element$iv2;
                    boolean bl12 = false;
                    this.logger.debug(() -> ColibriV2SessionManager.allocate$lambda-38$lambda-37$lambda-36(it5, participantInfo));
                    ParticipantInfo participantInfo2 = (ParticipantInfo)participantInfo.element;
                    String string = ((Colibri2Session)session.element).getRelayId();
                    Intrinsics.checkNotNull(string);
                    it5.updateRemoteParticipant$jicofo(participantInfo2, string, true);
                }
            }
            object = Unit.INSTANCE;
        }
        if (created) {
            this.eventEmitter.fireEvent(new Function1<ColibriSessionManager.Listener, Unit>(this){
                final /* synthetic */ ColibriV2SessionManager this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ColibriSessionManager.Listener $this$fireEvent) {
                    Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                    $this$fireEvent.bridgeCountChanged(ColibriV2SessionManager.access$getSessions$p(this.this$0).size());
                }
            });
        }
        IQ response = null;
        try {
            response = (IQ)stanzaCollector.nextResult();
            this.logger.trace(() -> ColibriV2SessionManager.allocate$lambda-39(response));
        }
        finally {
            stanzaCollector.cancel();
        }
        object = this.syncRoot;
        synchronized (object) {
            boolean bl13 = false;
            try {
                ColibriAllocation colibriAllocation = this.handleResponse(response, (Colibri2Session)session.element, created, (ParticipantInfo)participantInfo.element, useSctp);
                return colibriAllocation;
            }
            catch (Exception e) {
                this.logger.error("Failed to allocate a colibri2 endpoint for " + ((ParticipantInfo)participantInfo.element).getId() + ": " + e.getMessage());
                if (e instanceof ColibriAllocationFailedException && ((ColibriAllocationFailedException)e).getRemoveBridge()) {
                    Set<ParticipantInfo> removedParticipants = SetsKt.plus(this.removeSession((Colibri2Session)session.element), participantInfo.element);
                    this.remove((ParticipantInfo)participantInfo.element);
                    this.eventEmitter.fireEvent(new Function1<ColibriSessionManager.Listener, Unit>(session, removedParticipants){
                        final /* synthetic */ Ref.ObjectRef<Colibri2Session> $session;
                        final /* synthetic */ Set<ParticipantInfo> $removedParticipants;
                        {
                            this.$session = $session;
                            this.$removedParticipants = $removedParticipants;
                            super(1);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull ColibriSessionManager.Listener $this$fireEvent) {
                            Collection<String> collection;
                            void $this$mapTo$iv$iv;
                            void $this$map$iv;
                            Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                            Iterable iterable = this.$removedParticipants;
                            Bridge bridge2 = ((Colibri2Session)this.$session.element).getBridge();
                            ColibriSessionManager.Listener listener = $this$fireEvent;
                            boolean $i$f$map = false;
                            void var4_6 = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
                                collection = destination$iv$iv;
                                boolean bl = false;
                                collection.add(it.getId());
                            }
                            collection = (List)destination$iv$iv;
                            listener.bridgeRemoved(bridge2, CollectionsKt.toList((Iterable)collection));
                        }
                    });
                } else {
                    this.remove((ParticipantInfo)participantInfo.element);
                }
                throw e;
            }
        }
    }

    private final ColibriAllocation handleResponse(IQ response, Colibri2Session session, boolean created, ParticipantInfo participantInfo, boolean useSctp) {
        Integer sctpPort;
        if (!this.sessions.containsKey(session.getBridge())) {
            this.logger.warn("The session was removed, ignoring allocation response.");
            throw new ColibriAllocationFailedException("Session already removed", false);
        }
        if (response == null) {
            session.getBridge().setOperational(false);
            throw new ColibriAllocationFailedException("Timeout", true);
        }
        if (response instanceof ErrorIQ) {
            Colibri2Error colibri2Error;
            StanzaError stanzaError = ((ErrorIQ)response).getError();
            Colibri2Error.Reason reason = stanzaError != null && (colibri2Error = (Colibri2Error)stanzaError.getExtension("error", "jitsi:colibri2")) != null ? colibri2Error.getReason() : null;
            this.logger.info("Received error response: " + ((ErrorIQ)response).toXML());
            StanzaError stanzaError2 = ((ErrorIQ)response).getError();
            StanzaError.Condition condition = stanzaError2 != null ? stanzaError2.getCondition() : null;
            switch (condition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[condition.ordinal()]) {
                case 1: {
                    Object object = ((ErrorIQ)response).getError();
                    throw new ColibriAllocationFailedException("Bad request: " + (object != null && (object = object.toXML()) != null ? object.toString() : null), false);
                }
                case 2: {
                    if (reason == Colibri2Error.Reason.CONFERENCE_NOT_FOUND) {
                        throw new ColibriAllocationFailedException("Conference not found", true);
                    }
                    throw new ColibriAllocationFailedException("Item not found, bridge unavailable?", false);
                }
                case 3: {
                    if (reason == null) {
                        StanzaError stanzaError3 = ((ErrorIQ)response).getError();
                        throw new ColibriAllocationFailedException("XMPP error: " + (stanzaError3 != null ? stanzaError3.toXML() : null), true);
                    }
                    StanzaError stanzaError4 = ((ErrorIQ)response).getError();
                    throw new ColibriAllocationFailedException("Colibri error: " + (stanzaError4 != null ? stanzaError4.toXML() : null), true);
                }
                case 4: {
                    throw new ColibriAllocationFailedException("Bridge in graceful shutdown", true);
                }
            }
            session.getBridge().setOperational(false);
            StanzaError stanzaError5 = ((ErrorIQ)response).getError();
            throw new ColibriAllocationFailedException("Error: " + (stanzaError5 != null ? stanzaError5.toXML() : null), true);
        }
        if (!(response instanceof ConferenceModifiedIQ)) {
            session.getBridge().setOperational(false);
            throw new ColibriAllocationFailedException("Response of wrong type: " + response.getClass().getName(), false);
        }
        if (created) {
            session.setFeedbackSources$jicofo(ExtensionsKt.parseSources((ConferenceModifiedIQ)response));
        }
        Transport transport = ExtensionsKt.parseTransport((ConferenceModifiedIQ)response, participantInfo.getId());
        if (transport == null) {
            throw new ColibriAllocationFailedException("failed to parse transport", false);
        }
        Transport transport2 = transport;
        Sctp sctp = transport2.getSctp();
        Integer n = sctpPort = sctp != null ? sctp.getPort() : null;
        if (useSctp && sctpPort == null) {
            this.logger.error("Requested SCTP, but the response had no SCTP.");
            throw new ColibriAllocationFailedException("Requested SCTP, but the response had no SCTP", false);
        }
        IceUdpTransportPacketExtension iceUdpTransportPacketExtension = transport2.getIceUdpTransport();
        if (iceUdpTransportPacketExtension == null) {
            throw new ColibriAllocationFailedException("failed to parse transport", false);
        }
        return new ColibriAllocation(session.getFeedbackSources$jicofo(), iceUdpTransportPacketExtension, session.getBridge().getRegion(), session.getId(), sctpPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void sessionFailed$jicofo(@NotNull Colibri2Session session) {
        Intrinsics.checkNotNullParameter(session, "session");
        Object object = this.syncRoot;
        synchronized (object) {
            boolean bl = false;
            if (this.sessions.values().contains(session)) {
                Set<ParticipantInfo> removedParticipants = this.removeSession(session);
                this.eventEmitter.fireEvent(new Function1<ColibriSessionManager.Listener, Unit>(session, removedParticipants){
                    final /* synthetic */ Colibri2Session $session;
                    final /* synthetic */ Set<ParticipantInfo> $removedParticipants;
                    {
                        this.$session = $session;
                        this.$removedParticipants = $removedParticipants;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull ColibriSessionManager.Listener $this$fireEvent) {
                        Collection<String> collection;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Intrinsics.checkNotNullParameter($this$fireEvent, "$this$fireEvent");
                        Iterable iterable = this.$removedParticipants;
                        Bridge bridge2 = this.$session.getBridge();
                        ColibriSessionManager.Listener listener = $this$fireEvent;
                        boolean $i$f$map = false;
                        void var4_6 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(it.getId());
                        }
                        collection = (List)destination$iv$iv;
                        listener.bridgeRemoved(bridge2, CollectionsKt.toList((Iterable)collection));
                    }
                });
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void updateParticipant(@NotNull Participant participant, @Nullable IceUdpTransportPacketExtension transport, @Nullable ConferenceSourceMap sources, boolean suppressLocalBridgeUpdate) {
        Intrinsics.checkNotNullParameter(participant, "participant");
        Object object = this.syncRoot;
        synchronized (object) {
            boolean bl = false;
            this.logger.info("Updating " + participant + " with transport=" + transport + ", sources=" + sources);
            ParticipantInfo participantInfo = this.participants.get(participant.getEndpointId());
            if (participantInfo == null) {
                ColibriV2SessionManager $this$updateParticipant_u24lambda_u2d45_u24lambda_u2d42 = this;
                boolean bl2 = false;
                $this$updateParticipant_u24lambda_u2d45_u24lambda_u2d42.logger.error("No ParticipantInfo for " + participant.getEndpointId());
                return;
            }
            ParticipantInfo participantInfo2 = participantInfo;
            if (!suppressLocalBridgeUpdate) {
                participantInfo2.getSession().updateParticipant$jicofo(participantInfo2, transport, sources);
            }
            if (sources != null) {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                participantInfo2.setSources(sources);
                Iterable $this$filter$iv = this.sessions.values();
                boolean $i$f$filter = false;
                Iterable $this$updateParticipant_u24lambda_u2d45_u24lambda_u2d42 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Colibri2Session it = (Colibri2Session)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!Intrinsics.areEqual(it, participantInfo2.getSession()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Colibri2Session it = (Colibri2Session)element$iv;
                    boolean bl4 = false;
                    String string = participantInfo2.getSession().getRelayId();
                    Intrinsics.checkNotNull(string);
                    it.updateRemoteParticipant$jicofo(participantInfo2, string, false);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String getBridgeSessionId(@NotNull Participant participant) {
        Intrinsics.checkNotNullParameter(participant, "participant");
        Object object = this.syncRoot;
        synchronized (object) {
            boolean bl = false;
            Object object2 = this.participants.get(participant.getEndpointId());
            String string = object2 != null && (object2 = ((ParticipantInfo)object2).getSession()) != null ? ((Colibri2Session)object2).getId() : null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<String> removeBridge(@NotNull Bridge bridge2) {
        List list;
        Intrinsics.checkNotNullParameter(bridge2, "bridge");
        Object object = this.syncRoot;
        synchronized (object) {
            ParticipantInfo it;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Colibri2Session colibri2Session;
            block8: {
                Object v0;
                block7: {
                    boolean bl = false;
                    Iterable iterable = this.sessions.values();
                    for (Object t : iterable) {
                        Colibri2Session it2 = (Colibri2Session)t;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it2.getBridge().getJid(), bridge2.getJid())) continue;
                        v0 = t;
                        break block7;
                    }
                    v0 = null;
                }
                if ((Colibri2Session)v0 != null) break block8;
                List<String> list2 = CollectionsKt.emptyList();
                return list2;
            }
            Colibri2Session sessionToRemove = colibri2Session;
            this.logger.info("Removing bridges: " + bridge2);
            List<ParticipantInfo> participantsToRemove = this.getSessionParticipants(sessionToRemove);
            this.removeParticipantInfosBySession(MapsKt.mapOf(TuplesKt.to(sessionToRemove, participantsToRemove)));
            Iterable iterable = participantsToRemove;
            Object object2 = this.logger;
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            object2.info("Removed participants: " + (List)destination$iv$iv);
            $this$map$iv = participantsToRemove;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (ParticipantInfo)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.add(it.getId());
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public OrderedJsonObject getDebugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$_get_debugState__u24lambda_u2d57 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        Object object = this.syncRoot;
        synchronized (object) {
            boolean bl2 = false;
            OrderedJsonObject participantsJson = new OrderedJsonObject();
            Iterable $this$forEach$iv = this.participants.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParticipantInfo it = (ParticipantInfo)element$iv;
                boolean bl3 = false;
                ((Map)participantsJson).put(it.getId(), it.toJson());
            }
            $this$_get_debugState__u24lambda_u2d57.put("participants", participantsJson);
            OrderedJsonObject sessionsJson = new OrderedJsonObject();
            Iterable $this$forEach$iv2 = this.sessions.values();
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                String string;
                JSONArray jSONArray;
                OrderedJsonObject orderedJsonObject2;
                Colibri2Session it = (Colibri2Session)element$iv;
                boolean bl4 = false;
                Map map = sessionsJson;
                Intrinsics.checkNotNullExpressionValue(it.getBridge().getJid().getResourceOrNull().toString(), "it.bridge.jid.resourceOrNull.toString()");
                OrderedJsonObject sessionJson = orderedJsonObject2 = it.toJson();
                boolean bl5 = false;
                Map map2 = sessionJson;
                String string2 = "participants";
                JSONArray $this$_get_debugState__u24lambda_u2d57_u24lambda_u2d56_u24lambda_u2d55_u24lambda_u2d54_u24lambda_u2d53 = jSONArray = new JSONArray();
                boolean bl6 = false;
                Iterable $this$forEach$iv3 = this.getSessionParticipants(it);
                boolean $i$f$forEach3 = false;
                for (Object element$iv2 : $this$forEach$iv3) {
                    ParticipantInfo participant = (ParticipantInfo)element$iv2;
                    boolean bl7 = false;
                    $this$_get_debugState__u24lambda_u2d57_u24lambda_u2d56_u24lambda_u2d55_u24lambda_u2d54_u24lambda_u2d53.add(participant.getId());
                }
                map2.put(string2, jSONArray);
                map.put(string, orderedJsonObject2);
            }
            $this$_get_debugState__u24lambda_u2d57.put("sessions", sessionsJson);
            Unit unit = Unit.INSTANCE;
        }
        return orderedJsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setRelayTransport$jicofo(@NotNull Colibri2Session session, @NotNull IceUdpTransportPacketExtension transport, @NotNull String relayId) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(transport, "transport");
        Intrinsics.checkNotNullParameter(relayId, "relayId");
        this.logger.info("Received transport from " + session + " for relay " + relayId);
        this.logger.debug(() -> ColibriV2SessionManager.setRelayTransport$lambda-58(session, relayId, transport));
        Object object = this.syncRoot;
        synchronized (object) {
            Object object2;
            Object v0;
            block7: {
                boolean bl = false;
                if (!this.sessions.containsKey(session.getBridge()) || !Intrinsics.areEqual(this.sessions.get(session.getBridge()), session)) {
                    this.logger.info("Received a response for a session that is no longer active. Ignoring.");
                    return;
                }
                Iterable iterable = this.sessions.values();
                for (Object t : iterable) {
                    Colibri2Session it = (Colibri2Session)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getRelayId(), relayId)) continue;
                    v0 = t;
                    break block7;
                }
                v0 = null;
            }
            Colibri2Session colibri2Session = v0;
            if (colibri2Session != null) {
                String string = session.getRelayId();
                Intrinsics.checkNotNull(string);
                colibri2Session.setRelayTransport$jicofo(transport, string);
                object2 = Unit.INSTANCE;
            } else {
                object2 = new Function0<Unit>(this){
                    final /* synthetic */ ColibriV2SessionManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        ColibriV2SessionManager.access$getLogger$p(this.this$0).warn("Response for a relay that is no longer active. Ignoring.");
                    }
                };
            }
            Object object3 = object2;
        }
    }

    private final void clear() {
        this.participants.clear();
        this.participantsBySession.clear();
    }

    private final List<ParticipantInfo> getSessionParticipants(Colibri2Session session) {
        List<ParticipantInfo> list = this.participantsBySession.get(session);
        if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void remove(ParticipantInfo participantInfo) {
        block0: {
            this.participants.remove(participantInfo.getId());
            List<ParticipantInfo> list = this.participantsBySession.get(participantInfo.getSession());
            if (list == null) break block0;
            list.remove(participantInfo);
        }
    }

    private final void add(ParticipantInfo participantInfo) {
        this.participants.put(participantInfo.getId(), participantInfo);
        this.participantsBySession.computeIfAbsent(participantInfo.getSession(), ColibriV2SessionManager::add$lambda-61).add(participantInfo);
    }

    @Override
    public boolean mute(@NotNull String participantId, boolean doMute, @NotNull MediaType mediaType) {
        return ColibriSessionManager.DefaultImpls.mute(this, participantId, doMute, mediaType);
    }

    @Override
    public void updateParticipant(@NotNull Participant participant, @Nullable IceUdpTransportPacketExtension transport, @Nullable ConferenceSourceMap sources) {
        ColibriSessionManager.DefaultImpls.updateParticipant(this, participant, transport, sources);
    }

    private static final String expire$lambda-2$lambda-1$lambda-0(Colibri2Session $session) {
        Intrinsics.checkNotNullParameter($session, "$session");
        return "Expiring " + $session;
    }

    private static final String removeParticipant$lambda-5$lambda-3(Participant $participant) {
        Intrinsics.checkNotNullParameter($participant, "$participant");
        return "Asked to remove " + $participant.getEndpointId();
    }

    /*
     * WARNING - void declaration
     */
    private static final String removeParticipantInfosBySession$lambda-15$lambda-10(Colibri2Session $session, List $sessionParticipantsToRemove) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter($session, "$session");
        Intrinsics.checkNotNullParameter($sessionParticipantsToRemove, "$sessionParticipantsToRemove");
        Iterable iterable = $sessionParticipantsToRemove;
        Colibri2Session colibri2Session = $session;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParticipantInfo participantInfo = (ParticipantInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        return "Removing participants from session " + colibri2Session + ": " + (List)destination$iv$iv;
    }

    private static final Set mute$lambda-19$lambda-17$lambda-16(Colibri2Session it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new LinkedHashSet();
    }

    private static final String allocate$lambda-38$lambda-34$lambda-33(Ref.ObjectRef $session, Colibri2Session $it) {
        Intrinsics.checkNotNullParameter($session, "$session");
        Intrinsics.checkNotNullParameter($it, "$it");
        return "Creating relays between " + $session.element + " and " + $it + ".";
    }

    private static final String allocate$lambda-38$lambda-37$lambda-36(Colibri2Session $it, Ref.ObjectRef $participantInfo) {
        Intrinsics.checkNotNullParameter($it, "$it");
        Intrinsics.checkNotNullParameter($participantInfo, "$participantInfo");
        return "Adding a relayed endpoint to " + $it + " for " + ((ParticipantInfo)$participantInfo.element).getId() + ".";
    }

    private static final String allocate$lambda-39(IQ $response) {
        IQ iQ = $response;
        return "Received response: " + (iQ != null ? iQ.toXML() : null);
    }

    private static final String setRelayTransport$lambda-58(Colibri2Session $session, String $relayId, IceUdpTransportPacketExtension $transport) {
        Intrinsics.checkNotNullParameter($session, "$session");
        Intrinsics.checkNotNullParameter($relayId, "$relayId");
        Intrinsics.checkNotNullParameter($transport, "$transport");
        return "Received transport from " + $session + " for relay " + $relayId + ": " + $transport.toXML();
    }

    private static final List add$lambda-61(Colibri2Session it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new ArrayList();
    }

    public static final /* synthetic */ Map access$getSessions$p(ColibriV2SessionManager $this) {
        return $this.sessions;
    }

    public static final /* synthetic */ Logger access$getLogger$p(ColibriV2SessionManager $this) {
        return $this.logger;
    }

    public static final /* synthetic */ JitsiMeetConferenceImpl access$getConference$p(ColibriV2SessionManager $this) {
        return $this.conference;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StanzaError.Condition.values().length];
            nArray[StanzaError.Condition.bad_request.ordinal()] = 1;
            nArray[StanzaError.Condition.item_not_found.ordinal()] = 2;
            nArray[StanzaError.Condition.conflict.ordinal()] = 3;
            nArray[StanzaError.Condition.service_unavailable.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

