/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.health;

import java.time.Clock;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import kotlin.Unit;
import org.jitsi.health.HealthCheckService;
import org.jitsi.health.HealthChecker;
import org.jitsi.impl.protocol.xmpp.XmppProvider;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.bridge.BridgeSelector;
import org.jitsi.jicofo.health.HealthConfig;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smackx.ping.packet.Ping;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.stringprep.XmppStringprepException;

public class JicofoHealthChecker
implements HealthCheckService {
    private static final Logger logger = new LoggerImpl(JicofoHealthChecker.class.getName());
    private static final Map<String, String> JITSI_MEET_CONFIG = Collections.emptyMap();
    private static final Random RANDOM = new Random();
    private long totalSlowHealthChecks = 0L;
    private FocusManager focusManager;
    private final HealthChecker healthChecker;

    public JicofoHealthChecker(HealthConfig config, FocusManager focusManager) {
        this.focusManager = focusManager;
        this.healthChecker = new HealthChecker(config.getInterval(), config.getTimeout(), config.getMaxCheckDuration(), false, Duration.ofMinutes(5L), this::performCheck, Clock.systemUTC());
    }

    public void start() {
        this.healthChecker.start();
    }

    public void shutdown() {
        this.focusManager = null;
        try {
            this.healthChecker.stop();
        }
        catch (Exception e) {
            logger.warn("Failed to stop.", e);
        }
    }

    public Unit performCheck() {
        Objects.requireNonNull(this.focusManager, "FocusManager is not set.");
        long start2 = System.currentTimeMillis();
        JicofoHealthChecker.check(this.focusManager);
        long duration = System.currentTimeMillis() - start2;
        if (duration > HealthConfig.config.getMaxCheckDuration().toMillis()) {
            logger.error("Health check took too long: " + duration + "ms");
            ++this.totalSlowHealthChecks;
        }
        return Unit.INSTANCE;
    }

    private static void check(FocusManager focusManager) {
        EntityBareJid roomName;
        JicofoServices jicofoServices = JicofoServices.jicofoServicesSingleton;
        if (jicofoServices == null) {
            throw new RuntimeException("No JicofoServices available");
        }
        BridgeSelector bridgeSelector = jicofoServices.getBridgeSelector();
        if (bridgeSelector.getOperationalBridgeCount() <= 0) {
            throw new RuntimeException("No operational bridges available (total bridge count: " + bridgeSelector.getBridgeCount() + ")");
        }
        while (focusManager.getConference(roomName = JidCreate.entityBareFrom(JicofoHealthChecker.generateRoomName(), XmppConfig.client.getConferenceMucJid())) != null) {
        }
        try {
            if (!focusManager.conferenceRequest(roomName, JITSI_MEET_CONFIG, Level.WARNING, false)) {
                throw new RuntimeException("Failed to create conference with room name " + roomName);
            }
            JicofoHealthChecker.pingClientConnection();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create conference with room name " + roomName + ":" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pingClientConnection() throws Exception {
        CountDownLatch pingResponseWait = new CountDownLatch(1);
        Ping p = new Ping(JidCreate.bareFrom(XmppConfig.client.getXmppDomain()));
        XmppProvider provider = Objects.requireNonNull(JicofoServices.jicofoServicesSingleton).getXmppServices().getClientConnection();
        AbstractXMPPConnection connection = provider.getXmppConnection();
        StanzaListener listener = packet -> pingResponseWait.countDown();
        try {
            connection.addSyncStanzaListener(listener, stanza -> stanza.getStanzaId() != null && stanza.getStanzaId().equals(p.getStanzaId()));
            connection.sendStanza(p);
            if (!pingResponseWait.await(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("did not receive ping from the xmpp server");
            }
        }
        finally {
            connection.removeSyncStanzaListener(listener);
        }
    }

    private static Localpart generateRoomName() {
        try {
            return Localpart.from(HealthConfig.config.getRoomNamePrefix() + "-" + Long.toHexString(System.currentTimeMillis() + RANDOM.nextLong()));
        }
        catch (XmppStringprepException e) {
            return null;
        }
    }

    public long getTotalSlowHealthChecks() {
        return this.totalSlowHealthChecks;
    }

    @Override
    public Exception getResult() {
        return this.healthChecker.getResult();
    }
}

