/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.rest;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.time.Duration;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.JicofoServices;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

@Path(value="/pin")
public class Pin {
    @NotNull
    private final JicofoServices jicofoServices = Objects.requireNonNull(JicofoServices.jicofoServicesSingleton, "jicofoServices");

    @GET
    @Produces(value={"application/json"})
    public String getPins() {
        return this.jicofoServices.getFocusManager().getPinnedConferences().toJSONString();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response pin(PinJson pinJson, @Context HttpServletRequest request) {
        try {
            EntityBareJid conferenceJid = JidCreate.entityBareFrom(pinJson.conferenceId);
            this.jicofoServices.getFocusManager().pinConference(conferenceJid, pinJson.jvbVersion, Duration.ofMinutes(pinJson.minutes.intValue()));
            return Response.ok().build();
        }
        catch (XmppStringprepException x) {
            return Response.status(400).build();
        }
        catch (Throwable t) {
            return Response.status(500).build();
        }
    }

    @Path(value="/remove")
    @POST
    @Consumes(value={"application/json"})
    public Response unpin(UnpinJson unpinJson, @Context HttpServletRequest request) {
        try {
            EntityBareJid conferenceJid = JidCreate.entityBareFrom(unpinJson.conferenceId);
            this.jicofoServices.getFocusManager().unpinConference(conferenceJid);
            return Response.ok().build();
        }
        catch (XmppStringprepException x) {
            return Response.status(400).build();
        }
        catch (Throwable t) {
            return Response.status(500).build();
        }
    }

    public static class UnpinJson {
        @JsonProperty(value="conference-id", required=true)
        private String conferenceId;

        @JsonCreator
        public UnpinJson(@JsonProperty(value="conference-id", required=true) String conferenceId) {
            this.conferenceId = conferenceId;
        }
    }

    public static class PinJson {
        @JsonProperty(value="conference-id", required=true)
        private String conferenceId;
        @JsonProperty(value="jvb-version", required=true)
        private String jvbVersion;
        @JsonProperty(value="duration-minutes", required=true)
        private Integer minutes;

        @JsonCreator
        public PinJson(@JsonProperty(value="conference-id", required=true) String conferenceId, @JsonProperty(value="jvb-version", required=true) String jvbVersion, @JsonProperty(value="duration-minutes", required=true) Integer minutes) {
            this.conferenceId = conferenceId;
            this.jvbVersion = jvbVersion;
            this.minutes = minutes;
        }
    }
}

