/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iqversion.packet;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.util.StringUtils;
import org.jxmpp.jid.Jid;

public class Version
extends IQ {
    public static final String ELEMENT = "query";
    public static final String NAMESPACE = "jabber:iq:version";
    private final String name;
    private final String version;
    private String os;

    public Version() {
        super(ELEMENT, NAMESPACE);
        this.name = null;
        this.version = null;
        this.setType(IQ.Type.get);
    }

    public Version(Jid to) {
        this();
        this.setTo(to);
    }

    public Version(String name, String version) {
        this(name, version, null);
    }

    public Version(String name, String version, String os) {
        super(ELEMENT, NAMESPACE);
        this.setType(IQ.Type.result);
        this.name = StringUtils.requireNotNullNorEmpty(name, "name must not be null");
        this.version = StringUtils.requireNotNullNorEmpty(version, "version must not be null");
        this.os = os;
    }

    public Version(Version original) {
        this(original.name, original.version, original.os);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
        xml.rightAngleBracket();
        xml.optElement("name", this.name);
        xml.optElement("version", this.version);
        xml.optElement("os", this.os);
        return xml;
    }

    public static Version createResultFor(Stanza request, Version version) {
        Version result2 = new Version(version);
        result2.setStanzaId(request.getStanzaId());
        result2.setTo(request.getFrom());
        return result2;
    }
}

