/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.input;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.logstash.DLQEntry;
import org.logstash.Timestamp;
import org.logstash.ackedqueue.Queueable;
import org.logstash.common.io.DeadLetterQueueReader;

public class DeadLetterQueueInputPlugin {
    private static final Logger logger = LogManager.getLogger(DeadLetterQueueInputPlugin.class);
    private static final char VERSION = '1';
    private final DeadLetterQueueReader queueReader;
    private final boolean commitOffsets;
    private final Path sinceDbPath;
    private final AtomicBoolean open;
    private final Timestamp targetTimestamp;

    public DeadLetterQueueInputPlugin(Path path, boolean commitOffsets, Path sinceDbPath, Timestamp targetTimestamp) throws Exception {
        this.queueReader = new DeadLetterQueueReader(path);
        this.commitOffsets = commitOffsets;
        this.open = new AtomicBoolean(true);
        this.sinceDbPath = sinceDbPath;
        this.targetTimestamp = targetTimestamp;
    }

    public DeadLetterQueueReader getQueueReader() {
        return this.queueReader;
    }

    public void register() throws IOException {
        if (this.sinceDbPath != null && Files.exists(this.sinceDbPath, new LinkOption[0]) && this.targetTimestamp == null) {
            byte[] bytes = Files.readAllBytes(this.sinceDbPath);
            if (bytes.length == 0) {
                return;
            }
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            char version = buffer.getChar();
            if ('1' != version) {
                throw new RuntimeException("Sincdb version:" + version + " does not match: " + '1');
            }
            int segmentPathStringLength = buffer.getInt();
            byte[] segmentPathBytes = new byte[segmentPathStringLength];
            buffer.get(segmentPathBytes);
            long offset = buffer.getLong();
            this.queueReader.setCurrentReaderAndPosition(Paths.get(new String(segmentPathBytes), new String[0]), offset);
        } else if (this.targetTimestamp != null) {
            this.queueReader.seekToNextEvent(this.targetTimestamp);
        }
    }

    public void run(Consumer<Queueable> queueConsumer) throws Exception {
        while (this.open.get()) {
            DLQEntry entry = this.queueReader.pollEntry(100L);
            if (entry == null) continue;
            queueConsumer.accept((Queueable)entry);
        }
    }

    private void writeOffsets(Path segment, long offset) throws IOException {
        logger.info("writing offsets");
        String path = segment.toAbsolutePath().toString();
        ByteBuffer buffer = ByteBuffer.allocate(path.length() + 1 + 64);
        buffer.putChar('1');
        buffer.putInt(path.length());
        buffer.put(path.getBytes());
        buffer.putLong(offset);
        Files.write(this.sinceDbPath, buffer.array(), new OpenOption[0]);
    }

    public void close() throws IOException {
        logger.warn("closing dead letter queue input plugin");
        if (this.commitOffsets) {
            this.writeOffsets(this.queueReader.getCurrentSegment(), this.queueReader.getCurrentPosition());
        }
        this.queueReader.close();
        this.open.set(false);
    }
}

