/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIMeshKey;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiMeshAnim")
public class AIMeshAnim
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MNUMKEYS;
    public static final int MKEYS;

    public AIMeshAnim(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIMeshAnim.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIMeshAnim.nmName(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumKeys() {
        return AIMeshAnim.nmNumKeys(this.address());
    }

    @NativeType(value="struct aiMeshKey *")
    public AIMeshKey.Buffer mKeys() {
        return AIMeshAnim.nmKeys(this.address());
    }

    public AIMeshAnim mName(@NativeType(value="struct aiString") AIString value) {
        AIMeshAnim.nmName(this.address(), value);
        return this;
    }

    public AIMeshAnim mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIMeshAnim mKeys(@NativeType(value="struct aiMeshKey *") AIMeshKey.Buffer value) {
        AIMeshAnim.nmKeys(this.address(), value);
        return this;
    }

    public AIMeshAnim set(AIString mName, AIMeshKey.Buffer mKeys) {
        this.mName(mName);
        this.mKeys(mKeys);
        return this;
    }

    public AIMeshAnim set(AIMeshAnim src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIMeshAnim malloc() {
        return (AIMeshAnim)AIMeshAnim.wrap(AIMeshAnim.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static AIMeshAnim calloc() {
        return (AIMeshAnim)AIMeshAnim.wrap(AIMeshAnim.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static AIMeshAnim create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (AIMeshAnim)AIMeshAnim.wrap(AIMeshAnim.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static AIMeshAnim create(long address) {
        return (AIMeshAnim)AIMeshAnim.wrap(AIMeshAnim.class, (long)address);
    }

    @Nullable
    public static AIMeshAnim createSafe(long address) {
        return address == 0L ? null : (AIMeshAnim)AIMeshAnim.wrap(AIMeshAnim.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)AIMeshAnim.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)AIMeshAnim.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)AIMeshAnim.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIMeshAnim.__create((int)capacity, (int)SIZEOF);
        return (Buffer)AIMeshAnim.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AIMeshAnim.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AIMeshAnim.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIMeshAnim mallocStack() {
        return AIMeshAnim.mallocStack(MemoryStack.stackGet());
    }

    public static AIMeshAnim callocStack() {
        return AIMeshAnim.callocStack(MemoryStack.stackGet());
    }

    public static AIMeshAnim mallocStack(MemoryStack stack) {
        return (AIMeshAnim)AIMeshAnim.wrap(AIMeshAnim.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static AIMeshAnim callocStack(MemoryStack stack) {
        return (AIMeshAnim)AIMeshAnim.wrap(AIMeshAnim.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return AIMeshAnim.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return AIMeshAnim.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIMeshAnim.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)AIMeshAnim.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmNumKeys(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMKEYS);
    }

    public static AIMeshKey.Buffer nmKeys(long struct) {
        return AIMeshKey.create(MemoryUtil.memGetAddress((long)(struct + (long)MKEYS)), AIMeshAnim.nmNumKeys(struct));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)MNAME), (long)AIString.SIZEOF);
    }

    public static void nmNumKeys(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMKEYS, value);
    }

    public static void nmKeys(long struct, AIMeshKey.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)MKEYS), (long)value.address());
        AIMeshAnim.nmNumKeys(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)MKEYS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            AIMeshAnim.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = AIMeshAnim.__struct((Struct.Member[])new Struct.Member[]{AIMeshAnim.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AIMeshAnim.__member((int)4), AIMeshAnim.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MNUMKEYS = layout.offsetof(1);
        MKEYS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<AIMeshAnim, Buffer>
    implements NativeResource {
        private static final AIMeshAnim ELEMENT_FACTORY = AIMeshAnim.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AIMeshAnim getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIMeshAnim.nmName(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumKeys() {
            return AIMeshAnim.nmNumKeys(this.address());
        }

        @NativeType(value="struct aiMeshKey *")
        public AIMeshKey.Buffer mKeys() {
            return AIMeshAnim.nmKeys(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIMeshAnim.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mKeys(@NativeType(value="struct aiMeshKey *") AIMeshKey.Buffer value) {
            AIMeshAnim.nmKeys(this.address(), value);
            return this;
        }
    }
}

