/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.nodes;

import java.io.CharConversionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonMavenModuleBuild;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.api.ui.OpenableInBrowser;
import org.netbeans.modules.hudson.ui.actions.OpenUrlAction;
import org.netbeans.modules.hudson.ui.api.UI;
import org.netbeans.modules.hudson.ui.nodes.HudsonArtifactsNode;
import org.netbeans.modules.hudson.ui.nodes.HudsonMavenModuleBuildNode;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

class HudsonJobBuildNode
extends AbstractNode {
    private final HudsonJobBuild build;
    private String htmlDisplayName;

    public HudsonJobBuildNode(HudsonJobBuild build) {
        super(HudsonJobBuildNode.makeChildren(build), Lookups.singleton((Object)build));
        this.setName(Integer.toString(build.getNumber()));
        this.setDisplayName(NbBundle.getMessage(HudsonJobBuildNode.class, (String)"HudsonJobBuildNode.displayName", (Object)build.getNumber()));
        HudsonJob.Color effectiveColor = build.isBuilding() ? build.getJob().getColor() : Utilities.getColorForBuild((HudsonJobBuild)build);
        try {
            this.htmlDisplayName = effectiveColor.colorizeDisplayName(XMLUtil.toElementContent((String)this.getDisplayName()));
        }
        catch (CharConversionException x) {
            this.htmlDisplayName = null;
        }
        this.setIconBaseWithExtension(effectiveColor.iconBase());
        this.build = build;
    }

    public String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(UI.showChangesAction(this.build));
        actions.add(UI.showConsoleAction(this.build));
        actions.add((Action)UI.showFailuresAction());
        actions.add(null);
        if (this.build instanceof OpenableInBrowser) {
            actions.add(OpenUrlAction.forOpenable((OpenableInBrowser)this.build));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private static Children makeChildren(final HudsonJobBuild build) {
        return Children.create((ChildFactory)new ChildFactory<Object>(){
            final Object ARTIFACTS = new Object();

            protected boolean createKeys(List<Object> toPopulate) {
                Collection modules = build.getMavenModules();
                if (modules.isEmpty()) {
                    if (build.getArtifacts() != null) {
                        toPopulate.add(this.ARTIFACTS);
                    }
                } else {
                    toPopulate.addAll(modules);
                }
                return true;
            }

            protected Node createNodeForKey(Object key) {
                if (key instanceof HudsonMavenModuleBuild) {
                    return new HudsonMavenModuleBuildNode((HudsonMavenModuleBuild)key);
                }
                assert (key == this.ARTIFACTS) : key;
                return new HudsonArtifactsNode(build);
            }
        }, (boolean)false);
    }
}

