/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phing;

import java.util.Iterator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.phing.Bundle;
import org.netbeans.modules.php.phing.exec.PhingExecutable;
import org.netbeans.modules.php.phing.file.BuildXml;
import org.netbeans.modules.php.phing.file.PhingTargets;
import org.netbeans.modules.php.phing.preferences.PhingPreferences;
import org.netbeans.modules.php.phing.util.PhingUtils;
import org.netbeans.modules.web.clientproject.spi.build.BuildToolImplementation;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;

public final class PhingBuildTool
implements BuildToolImplementation {
    private static final Logger LOGGER = Logger.getLogger(PhingBuildTool.class.getName());
    public static final String IDENTIFIER = "Phing";
    private final Project project;
    private final BuildXml projectBuildXml;
    private final PhingTargets projectPhingTargets;
    private final PhingPreferences phingPreferences;
    final ConcurrentMap<FileObject, PhingTargets> phingTargets = new ConcurrentHashMap<FileObject, PhingTargets>();
    private final ChangeListener cleanupListener = new CleanupListener();

    public PhingBuildTool(Project project) {
        assert (project != null);
        this.project = project;
        this.projectBuildXml = new BuildXml(project.getProjectDirectory());
        this.projectPhingTargets = PhingTargets.create(project, this.projectBuildXml);
        this.phingPreferences = new PhingPreferences(project);
    }

    @NonNull
    public static PhingBuildTool forProject(Project project) {
        PhingBuildTool buildTool = PhingBuildTool.inProject(project);
        assert (buildTool != null) : "PhingBuildTool should be found in project " + project.getClass().getName() + " (lookup: " + project.getLookup() + ")";
        return buildTool;
    }

    @CheckForNull
    public static PhingBuildTool inProject(Project project) {
        assert (project != null);
        return (PhingBuildTool)project.getLookup().lookup(PhingBuildTool.class);
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getDisplayName() {
        return Bundle.PhingBuildTool_name();
    }

    public BuildXml getProjectBuildXml() {
        return this.projectBuildXml;
    }

    public PhingTargets getProjectPhingTargets() {
        return this.projectPhingTargets;
    }

    public PhingTargets getPhingTargets(@NullAllowed FileObject buildXml) {
        if (buildXml == null || buildXml.getParent().equals(this.project.getProjectDirectory())) {
            return this.getProjectPhingTargets();
        }
        PhingTargets targets = (PhingTargets)this.phingTargets.get(buildXml);
        if (targets != null) {
            return targets;
        }
        BuildXml file = new BuildXml(buildXml.getParent());
        targets = PhingTargets.create(this.project, file);
        PhingTargets currentTargets = this.phingTargets.putIfAbsent(buildXml, targets);
        if (currentTargets != null) {
            return currentTargets;
        }
        file.addChangeListener(WeakListeners.change((ChangeListener)this.cleanupListener, (Object)file));
        return targets;
    }

    public PhingPreferences getPhingPreferences() {
        return this.phingPreferences;
    }

    public boolean isEnabled() {
        return this.projectBuildXml.exists();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean run(String commandId, boolean waitFinished, boolean warnUser) {
        assert (this.isEnabled()) : this.project.getProjectDirectory().getNameExt();
        assert (this.projectBuildXml.exists()) : this.project.getProjectDirectory().getNameExt();
        String phingBuild = this.phingPreferences.getTarget(commandId);
        if (phingBuild != null) {
            PhingExecutable phing = PhingExecutable.getDefault(this.project, warnUser);
            if (phing == null) return true;
            PhingUtils.logUsagePhingBuild();
            Future<Integer> result = phing.run(phingBuild.split(" "));
            if (!waitFinished) return true;
            try {
                result.get();
                return true;
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return true;
            }
            catch (CancellationException ex) {
                LOGGER.log(Level.FINE, null, ex);
                return true;
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
                if (!warnUser) return true;
            }
            return true;
        } else {
            Object option;
            if (!warnUser || (option = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Bundle.PhingBuildTool_configure(), 0))) != NotifyDescriptor.YES_OPTION) return true;
            ((CustomizerProvider2)this.project.getLookup().lookup(CustomizerProvider2.class)).showCustomizer(IDENTIFIER, null);
        }
        return true;
    }

    private final class CleanupListener
    implements ChangeListener {
        private CleanupListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Iterator iterator = PhingBuildTool.this.phingTargets.keySet().iterator();
            while (iterator.hasNext()) {
                FileObject buildXml = (FileObject)iterator.next();
                if (buildXml.isValid()) continue;
                LOGGER.log(Level.FINE, "Removing invalid phing file {0}", buildXml);
                iterator.remove();
            }
        }
    }
}

