/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.TenancyInstance;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;

public class OCITenancyProvider
implements ServerInstanceProvider,
ChangeListener {
    private final ChangeSupport listeners = new ChangeSupport((Object)this);
    private final List<ServerInstance> instances = new ArrayList<ServerInstance>();
    private static OCITenancyProvider instance;

    private OCITenancyProvider() {
        this.refresh();
    }

    public static synchronized OCITenancyProvider getProvider() {
        if (instance == null) {
            instance = new OCITenancyProvider();
        }
        return instance;
    }

    public List<ServerInstance> getInstances() {
        return Collections.unmodifiableList(this.instances);
    }

    private void refresh() {
        OCIManager.getDefault().getTenancy().ifPresent(tenancy -> {
            ServerInstance si = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)new TenancyInstance((OCIItem)tenancy));
            this.instances.add(si);
            this.listeners.fireChange();
        });
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.removeChangeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh();
    }
}

