/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.adm.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.adm.model.SortOrder;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListWorkRequestErrorsRequest
extends BmcRequest<Void> {
    private String workRequestId;
    private String opcRequestId;
    private String page;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;

    @ConstructorProperties(value={"workRequestId", "opcRequestId", "page", "limit", "sortBy", "sortOrder"})
    ListWorkRequestErrorsRequest(String workRequestId, String opcRequestId, String page, Integer limit, SortBy sortBy, SortOrder sortOrder) {
        this.workRequestId = workRequestId;
        this.opcRequestId = opcRequestId;
        this.page = page;
        this.limit = limit;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().workRequestId(this.workRequestId).opcRequestId(this.opcRequestId).page(this.page).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder);
    }

    public String toString() {
        return "ListWorkRequestErrorsRequest(super=" + super.toString() + ", workRequestId=" + this.getWorkRequestId() + ", opcRequestId=" + this.getOpcRequestId() + ", page=" + this.getPage() + ", limit=" + this.getLimit() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListWorkRequestErrorsRequest)) {
            return false;
        }
        ListWorkRequestErrorsRequest other = (ListWorkRequestErrorsRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$workRequestId = this.getWorkRequestId();
        String other$workRequestId = other.getWorkRequestId();
        if (this$workRequestId == null ? other$workRequestId != null : !this$workRequestId.equals(other$workRequestId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        if (this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        return !(this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListWorkRequestErrorsRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $workRequestId = this.getWorkRequestId();
        result = result * 59 + ($workRequestId == null ? 43 : $workRequestId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        return result;
    }

    public String getWorkRequestId() {
        return this.workRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListWorkRequestErrorsRequest, Void> {
        private String workRequestId;
        private String opcRequestId;
        private String page;
        private Integer limit;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListWorkRequestErrorsRequest o) {
            this.workRequestId(o.getWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListWorkRequestErrorsRequest build() {
            ListWorkRequestErrorsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder workRequestId(String workRequestId) {
            this.workRequestId = workRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListWorkRequestErrorsRequest buildWithoutInvocationCallback() {
            return new ListWorkRequestErrorsRequest(this.workRequestId, this.opcRequestId, this.page, this.limit, this.sortBy, this.sortOrder);
        }

        public String toString() {
            return "ListWorkRequestErrorsRequest.Builder(workRequestId=" + this.workRequestId + ", opcRequestId=" + this.opcRequestId + ", page=" + this.page + ", limit=" + this.limit + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }

    public static enum SortBy {
        TimeAccepted("timeAccepted");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

