/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.source;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.queries.BinaryForSourceQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

public final class SourceBinaryTranslator {
    private static final String[] SOURCE_IDS = new String[]{"resources", "java", "modules"};

    public static URI source2Binary(FileObject fileObject) {
        BinaryForSourceQueryImplementation binaryForSource;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null && (binaryForSource = (BinaryForSourceQueryImplementation)project.getLookup().lookup(BinaryForSourceQueryImplementation.class)) != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            for (String sourceId : SOURCE_IDS) {
                SourceGroup[] sourceGroups;
                for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups(sourceId)) {
                    URL[] roots;
                    BinaryForSourceQuery.Result binaryRoots;
                    FileObject sourceRoot = sourceGroup.getRootFolder();
                    String relativePath = FileUtil.getRelativePath((FileObject)sourceRoot, (FileObject)fileObject);
                    if (relativePath == null || (binaryRoots = binaryForSource.findBinaryRoots(sourceRoot.toURL())) == null) continue;
                    for (URL root : roots = binaryRoots.getRoots()) {
                        FileObject binaryFo;
                        FileObject rootFo = URLMapper.findFileObject((URL)root);
                        if (rootFo == null || (binaryFo = rootFo.getFileObject(relativePath)) == null || binaryFo.getSize() != fileObject.getSize()) continue;
                        return binaryFo.toURI();
                    }
                }
            }
        }
        return fileObject.toURI();
    }

    public static URI binary2Source(URI uri) {
        BinaryForSourceQueryImplementation binaryForSource;
        Project project;
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)uri.toURL());
        }
        catch (MalformedURLException ex) {
            return uri;
        }
        if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (binaryForSource = (BinaryForSourceQueryImplementation)project.getLookup().lookup(BinaryForSourceQueryImplementation.class)) != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            for (String sourceId : SOURCE_IDS) {
                SourceGroup[] sourceGroups;
                for (SourceGroup sourceGroup : sourceGroups = sources.getSourceGroups(sourceId)) {
                    URL[] roots;
                    FileObject sourceRoot = sourceGroup.getRootFolder();
                    BinaryForSourceQuery.Result binaryRoots = binaryForSource.findBinaryRoots(sourceRoot.toURL());
                    if (binaryRoots == null) continue;
                    for (URL root : roots = binaryRoots.getRoots()) {
                        FileObject sourceFo;
                        String relativePath;
                        FileObject rootFo = URLMapper.findFileObject((URL)root);
                        if (rootFo == null || (relativePath = FileUtil.getRelativePath((FileObject)rootFo, (FileObject)fileObject)) == null || (sourceFo = sourceRoot.getFileObject(relativePath)) == null || sourceFo.getSize() != fileObject.getSize()) continue;
                        return sourceFo.toURI();
                    }
                }
            }
        }
        return uri;
    }
}

