/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JRTIndex;
import com.sun.tools.javac.file.Locations;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import nbjavac.ModuleWrapper;
import nbjavac.ServiceLoaderWrapper;

public class JavacFileManager
extends BaseFileManager
implements StandardJavaFileManager {
    private FSInfo fsInfo;
    private static final Set<JavaFileObject.Kind> SOURCE_OR_CLASS = Collections.unmodifiableSet(new HashSet<JavaFileObject.Kind>(Arrays.asList(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS)));
    protected boolean symbolFileEnabled;
    private StandardJavaFileManager.PathFactory pathFactory = Paths::get;
    protected SortFiles sortFiles;
    private Map<JavaFileManager.Location, Map<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>>> pathsAndContainersByLocationAndRelativeDirectory = new HashMap<JavaFileManager.Location, Map<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>>>();
    private Map<JavaFileManager.Location, java.util.List<PathAndContainer>> nonIndexingContainersByLocation = new HashMap<JavaFileManager.Location, java.util.List<PathAndContainer>>();
    private final Map<Path, Container> containers = new HashMap<Path, Container>();
    private static final Container MISSING_CONTAINER = new Container(){

        @Override
        public void list(Path userPath, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) throws IOException {
        }

        @Override
        public JavaFileObject getFileObject(Path userPath, RelativePath.RelativeFile name) throws IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean maintainsDirectoryIndex() {
            return false;
        }

        @Override
        public Iterable<RelativePath.RelativeDirectory> indexedDirectories() {
            return List.nil();
        }
    };
    private JRTIndex jrtIndex;
    private static final Set<FileVisitOption> NO_FILE_VISIT_OPTIONS = Collections.unmodifiableSet(new HashSet<FileVisitOption>(Arrays.asList(new FileVisitOption[0])));
    private static final Set<FileVisitOption> FOLLOW_LINKS_OPTIONS = Collections.unmodifiableSet(new HashSet<FileVisitOption>(Arrays.asList(FileVisitOption.FOLLOW_LINKS)));
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';

    public static char[] toArray(CharBuffer buffer) {
        if (buffer.hasArray()) {
            return ((CharBuffer)buffer.compact().flip()).array();
        }
        return buffer.toString().toCharArray();
    }

    public static void preRegister(Context context) {
        context.put(JavaFileManager.class, c -> new JavacFileManager(c, true, null));
    }

    public JavacFileManager(Context context, boolean register, Charset charset) {
        super(charset);
        if (register) {
            context.put(JavaFileManager.class, this);
        }
        this.setContext(context);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.fsInfo = FSInfo.instance(context);
        this.symbolFileEnabled = !this.options.isSet("ignore.symbol.file");
        String sf = this.options.get("sortFiles");
        if (sf != null) {
            this.sortFiles = sf.equals("reverse") ? SortFiles.REVERSE : SortFiles.FORWARD;
        }
    }

    @Override
    public void setPathFactory(StandardJavaFileManager.PathFactory f) {
        this.pathFactory = Objects.requireNonNull(f);
        this.locations.setPathFactory(f);
    }

    private Path getPath(String first, String ... more) {
        return this.pathFactory.getPath(first, more);
    }

    public void setSymbolFileEnabled(boolean b) {
        this.symbolFileEnabled = b;
    }

    public boolean isSymbolFileEnabled() {
        return this.symbolFileEnabled;
    }

    public JavaFileObject getJavaFileObject(String name) {
        return this.getJavaFileObjects(name).iterator().next();
    }

    public JavaFileObject getJavaFileObject(Path file) {
        return this.getJavaFileObjects(file).iterator().next();
    }

    public JavaFileObject getFileForOutput(String classname, JavaFileObject.Kind kind, JavaFileObject sibling) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, classname, kind, sibling);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> names) {
        ListBuffer<Path> paths = new ListBuffer<Path>();
        for (String name : names) {
            paths.append(this.getPath(JavacFileManager.nullCheck(name), new String[0]));
        }
        return this.getJavaFileObjectsFromPaths(paths.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... names) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList(JavacFileManager.nullCheck(names)));
    }

    private static boolean isValidName(String name) {
        for (String s : name.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(s)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String className) {
        if (!JavacFileManager.isValidName(className)) {
            throw new IllegalArgumentException("Invalid class name: " + className);
        }
    }

    private static void validatePackageName(String packageName) {
        if (packageName.length() > 0 && !JavacFileManager.isValidName(packageName)) {
            throw new IllegalArgumentException("Invalid packageName name: " + packageName);
        }
    }

    public static void testName(String name, boolean isValidPackageName, boolean isValidClassName) {
        try {
            JavacFileManager.validatePackageName(name);
            if (!isValidPackageName) {
                throw new AssertionError((Object)("Invalid package name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidPackageName) {
                throw new AssertionError((Object)("Valid package name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", name);
        }
        try {
            JavacFileManager.validateClassName(name);
            if (!isValidClassName) {
                throw new AssertionError((Object)("Invalid class name accepted: " + name));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", name);
        }
        catch (IllegalArgumentException e) {
            if (isValidClassName) {
                throw new AssertionError((Object)("Valid class name rejected: " + name));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", name);
        }
    }

    private static void printAscii(String format, Object ... args) {
        String message = new String(String.format(null, format, args).getBytes(StandardCharsets.US_ASCII), StandardCharsets.US_ASCII);
        System.out.println(message);
    }

    synchronized Container getContainer(Path path) throws IOException {
        Container fs = this.containers.get(path);
        if (fs != null) {
            return fs;
        }
        if (this.fsInfo.isFile(path) && path.equals(Locations.thisSystemModules)) {
            fs = new JRTImageContainer();
            this.containers.put(path, fs);
            return fs;
        }
        Path realPath = this.fsInfo.getCanonicalFile(path);
        fs = this.containers.get(realPath);
        if (fs != null) {
            this.containers.put(path, fs);
            return fs;
        }
        BasicFileAttributes attr = null;
        try {
            attr = Files.readAttributes(realPath, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException ex) {
            fs = MISSING_CONTAINER;
        }
        if (attr != null) {
            if (attr.isDirectory()) {
                fs = new DirectoryContainer(realPath);
            } else {
                try {
                    fs = new ArchiveContainer(path);
                }
                catch (SecurityException | ProviderNotFoundException ex) {
                    throw new IOException(ex);
                }
            }
        }
        this.containers.put(realPath, fs);
        this.containers.put(path, fs);
        return fs;
    }

    private synchronized JRTIndex getJRTIndex() {
        if (this.jrtIndex == null) {
            this.jrtIndex = JRTIndex.getSharedInstance();
        }
        return this.jrtIndex;
    }

    private boolean isValidFile(String s, Set<JavaFileObject.Kind> fileKinds) {
        JavaFileObject.Kind kind = JavacFileManager.getKind(s);
        return fileKinds.contains((Object)kind);
    }

    private boolean caseMapCheck(Path f, RelativePath name) {
        char sep;
        String path;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            path = f.toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
            sep = f.getFileSystem().getSeparator().charAt(0);
        }
        catch (IOException ex) {
            return false;
        }
        char[] pcs = path.toCharArray();
        char[] ncs = name.path.toCharArray();
        int i = pcs.length - 1;
        int j = ncs.length - 1;
        while (i >= 0 && j >= 0) {
            while (i >= 0 && pcs[i] == sep) {
                --i;
            }
            while (j >= 0 && ncs[j] == '/') {
                --j;
            }
            if (i < 0 || j < 0) continue;
            if (pcs[i] != ncs[j]) {
                return false;
            }
            --i;
            --j;
        }
        return j < 0;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
        this.pathsAndContainersByLocationAndRelativeDirectory.clear();
        this.nonIndexingContainersByLocation.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.deferredCloseTimeout > 0L) {
            this.deferredClose();
            return;
        }
        this.locations.close();
        for (Container container : this.containers.values()) {
            container.close();
        }
        this.containers.clear();
        this.pathsAndContainersByLocationAndRelativeDirectory.clear();
        this.nonIndexingContainersByLocation.clear();
        this.contentCache.clear();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        this.checkNotModuleOrientedLocation(location);
        Iterable<? extends File> path = this.getLocation(location);
        if (path == null) {
            return null;
        }
        ListBuffer<URL> lb = new ListBuffer<URL>();
        for (File file : path) {
            try {
                lb.append(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.getClassLoader(lb.toArray(new URL[lb.size()]));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(packageName);
        JavacFileManager.nullCheck(kinds);
        RelativePath.RelativeDirectory subdirectory = RelativePath.RelativeDirectory.forPackage(packageName);
        ListBuffer<JavaFileObject> results = new ListBuffer<JavaFileObject>();
        for (PathAndContainer pathAndContainer : this.pathsAndContainers(location, subdirectory)) {
            Path directory = pathAndContainer.path;
            Container container = pathAndContainer.container;
            container.list(directory, subdirectory, kinds, recurse, results);
        }
        return results.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        this.checkNotModuleOrientedLocation(location);
        Objects.requireNonNull(file);
        Iterable path = this.getLocationAsPaths(location);
        if (path == null) {
            return null;
        }
        if (file instanceof PathFileObject) {
            PathFileObject pathFileObject = (PathFileObject)file;
            return pathFileObject.inferBinaryName(path);
        }
        throw new IllegalArgumentException(file.getClass().getName());
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        JavacFileManager.nullCheck(a);
        JavacFileManager.nullCheck(b);
        if (a instanceof PathFileObject) {
            PathFileObject pathFileObjectA = (PathFileObject)a;
            if (b instanceof PathFileObject) {
                PathFileObject pathFileObjectB = (PathFileObject)b;
                return pathFileObjectA.isSameFile(pathFileObjectB);
            }
        }
        return a.equals(b);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.hasLocation(location);
    }

    protected boolean hasExplicitLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.hasExplicitLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!SOURCE_OR_CLASS.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForInput(location, RelativePath.RelativeFile.forClass(className, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(relativeName)) {
            throw new IllegalArgumentException("Invalid relative name: " + relativeName);
        }
        RelativePath.RelativeFile name = packageName.length() == 0 ? new RelativePath.RelativeFile(relativeName) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(packageName), relativeName);
        return this.getFileForInput(location, name);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, RelativePath.RelativeFile name) throws IOException {
        Iterable path = this.getLocationAsPaths(location);
        if (path == null) {
            return null;
        }
        for (Path file : path) {
            JavaFileObject fo = this.getContainer(file).getFileObject(file, name);
            if (fo == null) continue;
            return fo;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        this.checkOutputLocation(location);
        JavacFileManager.nullCheck(className);
        JavacFileManager.nullCheck(kind);
        if (!SOURCE_OR_CLASS.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + (Object)((Object)kind));
        }
        return this.getFileForOutput(location, RelativePath.RelativeFile.forClass(className, kind), sibling);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        this.checkOutputLocation(location);
        JavacFileManager.nullCheck(packageName);
        if (!JavacFileManager.isRelativeUri(relativeName)) {
            throw new IllegalArgumentException("Invalid relative name: " + relativeName);
        }
        RelativePath.RelativeFile name = packageName.length() == 0 ? new RelativePath.RelativeFile(relativeName) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(packageName), relativeName);
        return this.getFileForOutput(location, name, sibling);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile fileName, FileObject sibling) throws IOException {
        Path dir;
        block10: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    dir = this.getClassOutDir();
                    break block10;
                } else {
                    String string = fileName.basename();
                    if (sibling != null && sibling instanceof PathFileObject) {
                        PathFileObject pathFileObject = (PathFileObject)sibling;
                        return pathFileObject.getSibling(string);
                    }
                    Path p = this.getPath(string, new String[0]);
                    Path real = this.fsInfo.getCanonicalFile(p);
                    return PathFileObject.forSimplePath(this, real, p);
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                dir = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                Collection<Path> collection = this.locations.getLocation(location);
                dir = null;
                Iterator iterator = collection.iterator();
                if (iterator.hasNext()) {
                    Path f;
                    dir = f = (Path)iterator.next();
                }
            }
        }
        try {
            if (dir == null) {
                dir = this.getPath(System.getProperty("user.dir"), new String[0]);
            }
            Path path = fileName.resolveAgainst(this.fsInfo.getCanonicalFile(dir));
            return PathFileObject.forDirectoryPath(this, path, dir, fileName);
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("bad filename " + fileName, invalidPathException);
        }
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> files) {
        ArrayList<PathFileObject> result;
        if (files instanceof Collection) {
            Collection collection = (Collection)files;
            result = new ArrayList(collection.size());
        } else {
            result = new ArrayList<PathFileObject>();
        }
        for (File file : files) {
            Objects.requireNonNull(file);
            Path p = file.toPath();
            result.add(PathFileObject.forSimplePath(this, this.fsInfo.getCanonicalFile(p), p));
        }
        return result;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Collection<? extends Path> paths) {
        ArrayList<PathFileObject> result;
        if (paths != null) {
            result = new ArrayList(paths.size());
            for (Path path : paths) {
                result.add(PathFileObject.forSimplePath(this, this.fsInfo.getCanonicalFile(path), path));
            }
        } else {
            result = new ArrayList<PathFileObject>();
        }
        return result;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... files) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList(JavacFileManager.nullCheck(files)));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... paths) {
        return this.getJavaFileObjectsFromPaths((Collection<? extends Path>)Arrays.asList(JavacFileManager.nullCheck(paths)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> searchpath) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, JavacFileManager.asPaths(searchpath));
        this.clearCachesForLocation(location);
    }

    @Override
    public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> searchpath) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, JavacFileManager.nullCheck(searchpath));
        this.clearCachesForLocation(location);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return JavacFileManager.asFiles(this.locations.getLocation(location));
    }

    public Collection<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.getLocation(location);
    }

    private java.util.List<PathAndContainer> pathsAndContainers(JavaFileManager.Location location, RelativePath.RelativeDirectory relativeDirectory) throws IOException {
        try {
            return this.pathsAndContainersByLocationAndRelativeDirectory.computeIfAbsent(location, this::indexPathsAndContainersByRelativeDirectory).computeIfAbsent(relativeDirectory, d -> this.nonIndexingContainersByLocation.get(location));
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    private Map<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>> indexPathsAndContainersByRelativeDirectory(JavaFileManager.Location location) {
        HashMap<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>> result = new HashMap<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>>();
        java.util.List<PathAndContainer> allPathsAndContainers = this.pathsAndContainers(location);
        ArrayList<PathAndContainer> nonIndexingContainers = new ArrayList<PathAndContainer>();
        for (PathAndContainer pathAndContainer : allPathsAndContainers) {
            if (pathAndContainer.container.maintainsDirectoryIndex()) continue;
            nonIndexingContainers.add(pathAndContainer);
        }
        for (PathAndContainer pathAndContainer : allPathsAndContainers) {
            Container container = pathAndContainer.container;
            if (!container.maintainsDirectoryIndex()) continue;
            for (RelativePath.RelativeDirectory directory : container.indexedDirectories()) {
                result.computeIfAbsent(directory, d -> new ArrayList(nonIndexingContainers)).add(pathAndContainer);
            }
        }
        this.nonIndexingContainersByLocation.put(location, nonIndexingContainers);
        result.values().forEach(pathAndContainerList -> Collections.sort(pathAndContainerList));
        return result;
    }

    private java.util.List<PathAndContainer> pathsAndContainers(JavaFileManager.Location location) {
        Iterable paths = this.getLocationAsPaths(location);
        if (paths == null) {
            return List.nil();
        }
        ArrayList<PathAndContainer> pathsAndContainers = new ArrayList<PathAndContainer>(paths.size());
        for (Path path : paths) {
            Container container;
            try {
                container = this.getContainer(path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            pathsAndContainers.add(new PathAndContainer(path, container, pathsAndContainers.size()));
        }
        return pathsAndContainers;
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fo) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(fo);
        Path p = this.asPath(fo);
        return this.locations.contains(location, p);
    }

    private Path getClassOutDir() {
        return this.locations.getOutputLocation(StandardLocation.CLASS_OUTPUT);
    }

    private Path getSourceOutDir() {
        return this.locations.getOutputLocation(StandardLocation.SOURCE_OUTPUT);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String moduleName) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        JavacFileManager.nullCheck(moduleName);
        if (location == StandardLocation.SOURCE_OUTPUT && this.getSourceOutDir() == null) {
            location = StandardLocation.CLASS_OUTPUT;
        }
        return this.locations.getLocationForModule(location, moduleName);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> service) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(service);
        ModuleWrapper.getModule(this.getClass()).addUses(service);
        if (location.isModuleOrientedLocation()) {
            Collection<Path> paths = this.locations.getLocation(location);
            ModuleWrapper.ModuleFinder finder = ModuleWrapper.ModuleFinder.of(paths.toArray(new Path[paths.size()]));
            ModuleWrapper.ModuleLayer bootLayer = ModuleWrapper.ModuleLayer.boot();
            ModuleWrapper.Configuration cf = bootLayer.configuration().resolveAndBind(ModuleWrapper.ModuleFinder.of(new Path[0]), finder, Collections.emptySet());
            ModuleWrapper.ModuleLayer layer = bootLayer.defineModulesWithOneLoader(cf, ToolProvider.class.getClassLoader());
            return ServiceLoaderWrapper.load(layer, service);
        }
        return ServiceLoaderWrapper.loadWithClassLoader(service, this.getClassLoader(location));
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject fo) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        if (!(fo instanceof PathFileObject)) {
            return null;
        }
        PathFileObject pathFileObject = (PathFileObject)fo;
        Path p = Locations.normalize(pathFileObject.path);
        return this.locations.getLocationForModule(location, p);
    }

    @Override
    public void setLocationForModule(JavaFileManager.Location location, String moduleName, Collection<? extends Path> paths) throws IOException {
        JavacFileManager.nullCheck(location);
        this.checkModuleOrientedOrOutputLocation(location);
        this.locations.setLocationForModule(location, JavacFileManager.nullCheck(moduleName), JavacFileManager.nullCheck(paths));
        this.clearCachesForLocation(location);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) {
        this.checkNotModuleOrientedLocation(location);
        return this.locations.inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        return this.locations.listLocationsForModules(location);
    }

    @Override
    public Path asPath(FileObject file) {
        if (file instanceof PathFileObject) {
            PathFileObject pathFileObject = (PathFileObject)file;
            return pathFileObject.path;
        }
        throw new IllegalArgumentException(file.getName());
    }

    protected static boolean isRelativeUri(URI uri) {
        if (uri.isAbsolute()) {
            return false;
        }
        String path = uri.normalize().getPath();
        if (path.length() == 0) {
            return false;
        }
        if (!path.equals(uri.getPath())) {
            return false;
        }
        return !path.startsWith("/") && !path.startsWith("./") && !path.startsWith("../");
    }

    protected static boolean isRelativeUri(String u) {
        try {
            return JavacFileManager.isRelativeUri(new URI(u));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static String getRelativeName(File file) {
        String result;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(result = file.getPath().replace(File.separatorChar, '/'))) {
            return result;
        }
        throw new IllegalArgumentException("Invalid relative path: " + file);
    }

    public static String getMessage(IOException e) {
        String s = e.getLocalizedMessage();
        if (s != null) {
            return s;
        }
        s = e.getMessage();
        if (s != null) {
            return s;
        }
        return e.toString();
    }

    private void checkOutputLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException("location is not an output location: " + location.getName());
        }
    }

    private void checkModuleOrientedOrOutputLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (!location.isModuleOrientedLocation() && !location.isOutputLocation()) {
            throw new IllegalArgumentException("location is not an output location or a module-oriented location: " + location.getName());
        }
    }

    private void checkNotModuleOrientedLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (location.isModuleOrientedLocation()) {
            throw new IllegalArgumentException("location is module-oriented: " + location.getName());
        }
    }

    private static Iterable<Path> asPaths(final Iterable<? extends File> files) {
        if (files == null) {
            return null;
        }
        return () -> new Iterator<Path>(){
            Iterator<? extends File> iter;
            {
                this.iter = files.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return this.iter.next().toPath();
            }
        };
    }

    private static Iterable<File> asFiles(final Iterable<? extends Path> paths) {
        if (paths == null) {
            return null;
        }
        return () -> new Iterator<File>(){
            Iterator<? extends Path> iter;
            {
                this.iter = paths.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                try {
                    return this.iter.next().toFile();
                }
                catch (UnsupportedOperationException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    @Override
    public boolean handleOption(Option option, String value) {
        if (javacFileManagerOptions.contains((Object)option)) {
            this.pathsAndContainersByLocationAndRelativeDirectory.clear();
            this.nonIndexingContainersByLocation.clear();
        }
        return super.handleOption(option, value);
    }

    private void clearCachesForLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        this.pathsAndContainersByLocationAndRelativeDirectory.remove(location);
        this.nonIndexingContainersByLocation.remove(location);
    }

    protected static enum SortFiles implements Comparator<Path>
    {
        FORWARD{

            @Override
            public int compare(Path f1, Path f2) {
                return f1.getFileName().compareTo(f2.getFileName());
            }
        }
        ,
        REVERSE{

            @Override
            public int compare(Path f1, Path f2) {
                return f2.getFileName().compareTo(f1.getFileName());
            }
        };

    }

    private static interface Container {
        public void list(Path var1, RelativePath.RelativeDirectory var2, Set<JavaFileObject.Kind> var3, boolean var4, ListBuffer<JavaFileObject> var5) throws IOException;

        public JavaFileObject getFileObject(Path var1, RelativePath.RelativeFile var2) throws IOException;

        public void close() throws IOException;

        public boolean maintainsDirectoryIndex();

        public Iterable<RelativePath.RelativeDirectory> indexedDirectories();
    }

    private final class JRTImageContainer
    implements Container {
        private JRTImageContainer() {
        }

        @Override
        public void list(Path userPath, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) throws IOException {
            try {
                JRTIndex.Entry e = JavacFileManager.this.getJRTIndex().getEntry(subdirectory);
                if (JavacFileManager.this.symbolFileEnabled && e.ctSym.hidden) {
                    return;
                }
                for (Path file : e.files.values()) {
                    if (!fileKinds.contains((Object)BaseFileManager.getKind(file))) continue;
                    PathFileObject fe = PathFileObject.forJRTPath(JavacFileManager.this, file);
                    resultList.append(fe);
                }
                if (recurse) {
                    for (RelativePath.RelativeDirectory rd : e.subdirs) {
                        this.list(userPath, rd, fileKinds, recurse, resultList);
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
                JavacFileManager.this.log.error(CompilerProperties.Errors.ErrorReadingFile(userPath, JavacFileManager.getMessage(ex)));
            }
        }

        @Override
        public JavaFileObject getFileObject(Path userPath, RelativePath.RelativeFile name) throws IOException {
            JRTIndex.Entry e = JavacFileManager.this.getJRTIndex().getEntry(name.dirname());
            if (JavacFileManager.this.symbolFileEnabled && e.ctSym.hidden) {
                return null;
            }
            Path p = e.files.get(name.basename());
            if (p != null) {
                return PathFileObject.forJRTPath(JavacFileManager.this, p);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean maintainsDirectoryIndex() {
            return false;
        }

        @Override
        public Iterable<RelativePath.RelativeDirectory> indexedDirectories() {
            return List.nil();
        }
    }

    private final class DirectoryContainer
    implements Container {
        private final Path directory;

        public DirectoryContainer(Path directory) {
            this.directory = directory;
        }

        @Override
        public void list(Path userPath, RelativePath.RelativeDirectory subdirectory, Set<JavaFileObject.Kind> fileKinds, boolean recurse, ListBuffer<JavaFileObject> resultList) throws IOException {
            java.util.List files;
            Path d;
            try {
                d = subdirectory.resolveAgainst(userPath);
            }
            catch (InvalidPathException ignore) {
                return;
            }
            if (!Files.exists(d, new LinkOption[0])) {
                return;
            }
            if (!JavacFileManager.this.caseMapCheck(d, subdirectory)) {
                return;
            }
            try (Stream<Path> s = Files.list(d);){
                files = (JavacFileManager.this.sortFiles == null ? s : s.sorted(JavacFileManager.this.sortFiles)).collect(Collectors.toList());
            }
            catch (IOException ignore) {
                return;
            }
            for (Path f : files) {
                String fname = f.getFileName().toString();
                if (fname.endsWith("/")) {
                    fname = fname.substring(0, fname.length() - 1);
                }
                if (Files.isDirectory(f, new LinkOption[0])) {
                    if (!recurse || !SourceVersion.isIdentifier(fname)) continue;
                    this.list(userPath, new RelativePath.RelativeDirectory(subdirectory, fname), fileKinds, recurse, resultList);
                    continue;
                }
                if (!JavacFileManager.this.isValidFile(fname, fileKinds)) continue;
                try {
                    RelativePath.RelativeFile file = new RelativePath.RelativeFile(subdirectory, fname);
                    PathFileObject fe = PathFileObject.forDirectoryPath(JavacFileManager.this, file.resolveAgainst(this.directory), userPath, file);
                    resultList.append(fe);
                }
                catch (InvalidPathException e) {
                    throw new IOException("error accessing directory " + this.directory + e);
                }
            }
        }

        @Override
        public JavaFileObject getFileObject(Path userPath, RelativePath.RelativeFile name) throws IOException {
            try {
                Path f = name.resolveAgainst(userPath);
                if (Files.exists(f, new LinkOption[0])) {
                    return PathFileObject.forSimplePath(JavacFileManager.this, JavacFileManager.this.fsInfo.getCanonicalFile(f), f);
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean maintainsDirectoryIndex() {
            return false;
        }

        @Override
        public Iterable<RelativePath.RelativeDirectory> indexedDirectories() {
            return List.nil();
        }
    }

    private final class ArchiveContainer
    implements Container {
        private final Path archivePath;
        private final FileSystem fileSystem;
        private final Map<RelativePath.RelativeDirectory, Path> packages;

        public ArchiveContainer(Path archivePath) throws IOException, ProviderNotFoundException, SecurityException {
            this.archivePath = archivePath;
            if (JavacFileManager.this.multiReleaseValue != null && archivePath.toString().endsWith(".jar")) {
                Map<String, String> env = Collections.singletonMap("multi-release", JavacFileManager.this.multiReleaseValue);
                FileSystemProvider jarFSProvider = JavacFileManager.this.fsInfo.getJarFSProvider();
                Assert.checkNonNull(jarFSProvider, "should have been caught before!");
                this.fileSystem = jarFSProvider.newFileSystem(archivePath, env);
            } else {
                this.fileSystem = FileSystems.newFileSystem(archivePath, (ClassLoader)null);
            }
            this.packages = new HashMap<RelativePath.RelativeDirectory, Path>();
            for (final Path root : this.fileSystem.getRootDirectories()) {
                Files.walkFileTree(root, NO_FILE_VISIT_OPTIONS, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        if (ArchiveContainer.this.isValid(dir.getFileName())) {
                            ArchiveContainer.this.packages.put(new RelativePath.RelativeDirectory(root.relativize(dir).toString()), dir);
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                });
            }
        }

        @Override
        public void list(Path userPath, RelativePath.RelativeDirectory subdirectory, final Set<JavaFileObject.Kind> fileKinds, boolean recurse, final ListBuffer<JavaFileObject> resultList) throws IOException {
            Path resolvedSubdirectory = this.packages.get(subdirectory);
            if (resolvedSubdirectory == null) {
                return;
            }
            int maxDepth = recurse ? Integer.MAX_VALUE : 1;
            Files.walkFileTree(resolvedSubdirectory, FOLLOW_LINKS_OPTIONS, maxDepth, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    if (ArchiveContainer.this.isValid(dir.getFileName())) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (attrs.isRegularFile() && fileKinds.contains((Object)BaseFileManager.getKind(file.getFileName().toString()))) {
                        PathFileObject fe = PathFileObject.forJarPath(JavacFileManager.this, file, ArchiveContainer.this.archivePath);
                        resultList.append(fe);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private boolean isValid(Path fileName) {
            if (fileName == null) {
                return true;
            }
            String name = fileName.toString();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            return SourceVersion.isIdentifier(name);
        }

        @Override
        public JavaFileObject getFileObject(Path userPath, RelativePath.RelativeFile name) throws IOException {
            Path relpath;
            RelativePath.RelativeDirectory root = name.dirname();
            Path packagepath = this.packages.get(root);
            if (packagepath != null && Files.exists(relpath = packagepath.resolve(name.basename()), new LinkOption[0])) {
                return PathFileObject.forJarPath(JavacFileManager.this, relpath, userPath);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.fileSystem.close();
        }

        @Override
        public boolean maintainsDirectoryIndex() {
            return true;
        }

        @Override
        public Iterable<RelativePath.RelativeDirectory> indexedDirectories() {
            return this.packages.keySet();
        }
    }

    private static class PathAndContainer
    implements Comparable<PathAndContainer> {
        private final Path path;
        private final Container container;
        private final int index;

        PathAndContainer(Path path, Container container, int index) {
            this.path = path;
            this.container = container;
            this.index = index;
        }

        @Override
        public int compareTo(PathAndContainer other) {
            return this.index - other.index;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object o) {
            if (!(o instanceof PathAndContainer)) return false;
            PathAndContainer pathAndContainer = (PathAndContainer)o;
            if (!this.path.equals(pathAndContainer.path)) return false;
            if (!this.container.equals(pathAndContainer.container)) return false;
            if (this.index != pathAndContainer.index) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.container, this.index);
        }
    }
}

